/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.wfutil.dao;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.cp.eip.mc.BizPackageMapCollection;
import com.kingdee.eas.cp.eip.mc.BizPackageMapFactory;
import com.kingdee.eas.cp.eip.mc.BizPackageMapInfo;
import com.kingdee.eas.cp.eip.mc.IBizPackageMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CPMsgBizTypeSingleton {
    Logger logger = Logger.getLogger((String)CPMsgBizTypeSingleton.class.getName());
    private static CPMsgBizTypeSingleton instance = null;
    private static HashMap bizMap = new HashMap();

    private CPMsgBizTypeSingleton(Context context) {
        try {
            IBizPackageMap bizPackageMap = BizPackageMapFactory.getLocalInstance((Context)context);
            BizPackageMapCollection items = bizPackageMap.getBizPackageMapCollection();
            if (items != null && items.size() > 0) {
                BizPackageMapInfo info = null;
                ArrayList bizList = null;
                for (int i = 0; i < items.size(); ++i) {
                    info = items.get(i);
                    if (bizMap.containsKey(info.getBizSysType())) {
                        bizList = (ArrayList)bizMap.get(info.getBizSysType());
                        bizList.add(info.getBizPackage());
                        continue;
                    }
                    bizList = new ArrayList();
                    bizList.add(info.getBizPackage());
                    bizMap.put(info.getBizSysType(), bizList);
                }
            }
            this.logger.info((Object)("\u521d\u59cb\u5316\u6d88\u606f\u4e2d\u5fc3\u4e1a\u52a1\u5206\u7c7b\u6210\u529f\uff1a" + bizMap));
        }
        catch (Exception e) {
            this.logger.error((Object)("\u521d\u59cb\u5316\u6d88\u606f\u4e2d\u5fc3\u4e1a\u52a1\u5305\u5206\u7c7b\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CPMsgBizTypeSingleton getInstance(Context context) {
        Class<CPMsgBizTypeSingleton> clazz = CPMsgBizTypeSingleton.class;
        synchronized (CPMsgBizTypeSingleton.class) {
            if (instance == null) {
                instance = new CPMsgBizTypeSingleton(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static String getBizPackageFilter(String bizType) {
        StringBuffer temp = new StringBuffer();
        ArrayList list = null;
        if (bizType != null && !bizType.equals("")) {
            if (bizType.equals("other")) {
                Iterator its = bizMap.values().iterator();
                String biz = null;
                int j = 0;
                while (its.hasNext()) {
                    list = (ArrayList)its.next();
                    if (list == null || list.size() <= 0) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        biz = (String)list.get(i);
                        if (biz.equals("other")) continue;
                        if (j == 0) {
                            temp.append(" FBizPackage not like '");
                            temp.append(biz);
                            temp.append("%'");
                        } else {
                            temp.append(" and ");
                            temp.append("FBizPackage not like '");
                            temp.append(biz);
                            temp.append("%'");
                        }
                        ++j;
                    }
                }
            } else {
                list = (ArrayList)bizMap.get(bizType);
                if (list != null && list.size() > 0) {
                    String biz = null;
                    for (int i = 0; i < list.size(); ++i) {
                        biz = (String)list.get(i);
                        if (i == 0) {
                            temp.append(" FBizPackage like '");
                            temp.append(biz);
                            temp.append("%'");
                            continue;
                        }
                        temp.append(" or ");
                        temp.append("FBizPackage like '");
                        temp.append(biz);
                        temp.append("%'");
                    }
                }
            }
        }
        if (temp.toString().length() > 0) {
            if (bizType.equals("other")) {
                return "and ((" + temp.toString() + ") or FBizPackage is null)";
            }
            return "and (" + temp.toString() + ")";
        }
        return temp.toString();
    }

    public FilterInfo getFilterInfoByBizType(String bizType) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("type", (Object)new Integer(10));
        filterInfo.getFilterItems().add(filterItemInfo);
        StringBuffer temp = new StringBuffer();
        ArrayList list = null;
        if (bizType != null && !bizType.equals("")) {
            if (bizType.equals("other")) {
                Iterator its = bizMap.values().iterator();
                String biz = null;
                int j = 0;
                while (its.hasNext()) {
                    list = (ArrayList)its.next();
                    if (list == null || list.size() <= 0) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        biz = (String)list.get(i);
                        if (biz.equals("other")) continue;
                        filterItemInfo = new FilterItemInfo("bizPackage", (Object)(biz + "%"), CompareType.NOTLIKE);
                        filterInfo.getFilterItems().add(filterItemInfo);
                        temp.append(" AND #" + ++j);
                    }
                }
            } else {
                list = (ArrayList)bizMap.get(bizType);
                if (list != null && list.size() > 0) {
                    String biz = null;
                    int j = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        biz = (String)list.get(i);
                        j = i + 1;
                        if (i == 0) {
                            temp.append(" AND (#" + j);
                        } else {
                            temp.append(" OR #" + j);
                        }
                        filterItemInfo = new FilterItemInfo("bizPackage", (Object)(biz + "%"), CompareType.LIKE);
                        filterInfo.getFilterItems().add(filterItemInfo);
                    }
                    temp.append(")");
                }
            }
        }
        filterInfo.setMaskString(" #0 " + temp.toString());
        return filterInfo;
    }

    public static void main(String[] args) {
        ArrayList<String> cpList = new ArrayList<String>();
        cpList.add("com.kingdee.eas.cp.");
        cpList.add("com.kingdee.eas.scm.");
        bizMap.put("cp", cpList);
        ArrayList<String> hrList = new ArrayList<String>();
        hrList.add("com.kingdee.eas.hr.");
        bizMap.put("hr", hrList);
        ArrayList<String> otherList = new ArrayList<String>();
        otherList.add("other");
        bizMap.put("other", otherList);
        System.out.println("cp filter=" + CPMsgBizTypeSingleton.getBizPackageFilter("cp"));
        System.out.println("ht filter=" + CPMsgBizTypeSingleton.getBizPackageFilter("hr"));
        System.out.println("other filter=" + CPMsgBizTypeSingleton.getBizPackageFilter("other"));
    }
}

