/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.wfutil.dao;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.base.wfutil.Message;
import com.kingdee.eas.cp.base.wfutil.MessageExtraFilter;
import com.kingdee.eas.cp.base.wfutil.dao.CPMessageDAO;
import com.kingdee.eas.cp.common.web.util.DAOException;
import com.kingdee.eas.cp.common.web.util.ValueListDAO;
import com.kingdee.eas.cp.eip.mc.web.MsgType;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CPOfficeMessageDAOImpl
implements CPMessageDAO,
ValueListDAO {
    Logger logger = Logger.getLogger((String)CPOfficeMessageDAOImpl.class.getName());
    private Context context;
    private ResultSet rs;
    private String local = "L2";
    private boolean history = false;
    private String ctCountSql = "";
    private String countSql = "";
    private String recsCtSql = "";
    private String recsHisSql = "";
    private String recsSql = "";
    private String filterSql = "";
    private MessageExtraFilter extraFilter;

    public CPOfficeMessageDAOImpl(Context context, boolean isHst) throws DAOException {
        this.setContext(context, isHst);
    }

    public CPOfficeMessageDAOImpl(Context context, MsgType type, boolean isHst) throws DAOException {
        this.setContext(context, isHst);
        this.extraFilter = new MessageExtraFilter(CPOfficeMessageDAOImpl.class.getName(), this.local, type);
        this.setMessageSql(context.getCaller().toString(), type);
    }

    private void setMessageSql(String userId, MsgType type) throws DAOException {
        StringBuffer tempBuf = new StringBuffer();
        tempBuf.append(" FReceiver = '");
        tempBuf.append(userId);
        tempBuf.append("'");
        if (type.getMsgDate() != null && !"".equals(type.getMsgDate())) {
            String beginStr = type.getMsgDate() + " 00:00:00";
            String endStr = type.getMsgDate() + " 23:59:59";
            Timestamp begin = Timestamp.valueOf(beginStr);
            Timestamp end = Timestamp.valueOf(endStr);
            tempBuf.append(" and FCREATEDTIME >={");
            tempBuf.append(begin);
            tempBuf.append("} and FCREATEDTIME <={");
            tempBuf.append(end);
            tempBuf.append("}");
        }
        this.extraFilter.setFilterSql(tempBuf);
        this.countSql = this.ctCountSql + tempBuf.toString();
        this.recsSql = this.recsCtSql + tempBuf.toString();
    }

    public int getRecordsCount() throws DAOException {
        try {
            int count = 0;
            this.logger.debug((Object)("\u6267\u884c\u6d88\u606f\u67e5\u8be2\u8bed\u53e5\uff1a" + this.countSql));
            this.rs = DbUtil.executeQuery((Context)this.context, (String)this.countSql);
            while (this.rs.next()) {
                count += this.rs.getInt(1);
            }
            this.logger.info((Object)("\u672c\u6b21\u67e5\u8be2\u6761\u4ef6\u53d6\u5f97\u7684\u8bb0\u5f55\u6570\u4e3a:" + count));
            return count;
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5f97\u5230\u6d88\u606f\u6570\u91cf\u65f6\u53d1\u751f\u9519\u8bef" + e.getMessage()));
            throw new DAOException((Throwable)e);
        }
    }

    public List getRecords(int pageSize, int pageNo, String orderByField, String orderType) throws DAOException {
        ArrayList<Message> list = new ArrayList<Message>();
        if (pageNo <= 0) {
            return list;
        }
        try {
            Message message;
            this.recsSql = "select top " + pageSize * pageNo + this.recsSql;
            this.recsSql = orderByField != null && orderByField.trim().length() > 0 ? this.recsSql + " order by " + this.getRealOrderByfield(orderByField) + " " + orderType : this.recsSql + " order by  FReceiveTime DESC";
            this.logger.debug((Object)("\u6267\u884c\u67e5\u8be2\u6d88\u606f\u8bb0\u5f55\u7684\u8bed\u53e5\uff1a" + this.recsSql));
            this.rs = DbUtil.executeQuery((Context)this.context, (String)this.recsSql);
            int i = 0;
            while (this.rs.next()) {
                if (i == (pageNo - 1) * pageSize) {
                    message = new Message();
                    message.setLocale(new Locale(this.local));
                    message.setID(this.rs.getString(1));
                    message.setType(this.rs.getInt(2));
                    message.setBizType(this.rs.getInt(3));
                    message.setSender(this.rs.getString(4));
                    message.setPriority(this.rs.getInt(5));
                    message.setStatus(this.rs.getInt(6));
                    message.setSourceStatus(this.rs.getInt(7));
                    message.setTitle(this.rs.getString(8));
                    message.setSendTime(this.rs.getTimestamp(9));
                    message.setReceiveTime(this.rs.getTimestamp(10));
                    message.setSourceID(this.rs.getString(11));
                    message.setReceiver(this.rs.getString(12));
                    list.add(message);
                    break;
                }
                ++i;
            }
            while (this.rs.next()) {
                message = new Message();
                message.setID(this.rs.getString(1));
                message.setType(this.rs.getInt(2));
                message.setBizType(this.rs.getInt(3));
                message.setSender(this.rs.getString(4));
                message.setPriority(this.rs.getInt(5));
                message.setStatus(this.rs.getInt(6));
                message.setSourceStatus(this.rs.getInt(7));
                message.setTitle(this.rs.getString(8));
                message.setSendTime(this.rs.getTimestamp(9));
                message.setReceiveTime(this.rs.getTimestamp(10));
                message.setSourceID(this.rs.getString(11));
                message.setReceiver(this.rs.getString(12));
                list.add(message);
            }
        }
        catch (SQLException sqle) {
            this.logger.error((Object)("\u53d6\u6d88\u606f\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + sqle.getMessage()));
            throw new DAOException((Throwable)sqle);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u53d6\u6d88\u606f\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
            throw new DAOException((Throwable)e);
        }
        return list;
    }

    public void setContext(Context context, boolean isHst) {
        this.local = context.getLocale().toString();
        if (!isHst) {
            this.recsCtSql = " FID as FID, 10 as FType, 30 as FBizType, FSender,FPriority,FStatus, FSourceStatus, FTitle,FReceiveTime as FSendTime,FReceiveTime, FSourceID, FReceiver from T_BAS_Messageyr where  ";
            this.ctCountSql = "select count(*) from T_BAS_Messageyr where  ";
        } else {
            this.recsCtSql = " FID as FID, 10 as FType, 30 as FBizType, FSender,FPriority,FStatus, FSourceStatus, FTitle,FReceiveTime as FSendTime,FReceiveTime, FSourceID, FReceiver from T_BAS_MessageyrHst where  ";
            this.ctCountSql = "select count(*) from T_BAS_MessageyrHst where  ";
        }
        this.context = context;
    }

    public String getRecsCountSql() {
        return this.countSql;
    }

    public String getRecsSql() {
        return this.recsSql;
    }

    private String getRealOrderByfield(String orderField) {
        if (orderField.startsWith("FTitle_")) {
            return "FTitle";
        }
        if (orderField.startsWith("FSender_")) {
            return "FSender";
        }
        return orderField;
    }
}

