/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.util.AttachmentUtils;
import com.kingdee.eas.cp.base.xt.AttchmentDTO;
import com.kingdee.eas.cp.base.xt.CompressPic;
import com.kingdee.eas.cp.base.xt.XTUtil;
import com.kingdee.eas.cp.base.xt.XtImageUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.ThumbnailSizeEnum;
import com.kingdee.lightapp.util.image.ImageUtil;
import com.kingdee.util.UuidException;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AttchmentUtil {
    public static List getAttchmentList(Context ctx, String billId) {
        IRowSet rowSet = null;
        ArrayList<AttchmentDTO> list = new ArrayList<AttchmentDTO>();
        String sql = "select att.fid,att.fname_l2, att.fsize, att.fsimplename, att.flastupdatetime,att.fcreateTime  from t_Bas_Attachment att, t_bas_boattchasso bo  where att.fid = bo.fAttachmentid and bo.fboid = '" + billId + "' and att.Fname_l2 not like 'docBody_%' order by att.fname_l2 ";
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet == null) {
                return null;
            }
            while (rowSet.next()) {
                String lastUpdateTime = rowSet.getString("flastupdatetime");
                String createTime = rowSet.getString("fcreateTime");
                if (lastUpdateTime != null && lastUpdateTime.length() > 16) {
                    lastUpdateTime = lastUpdateTime.substring(0, 16);
                }
                if (createTime != null && createTime.length() > 16) {
                    createTime = createTime.substring(0, 16);
                }
                AttchmentDTO dto = new AttchmentDTO();
                dto.setId(rowSet.getString("fid"));
                dto.setName(rowSet.getString("fname_l2"));
                dto.setSize(rowSet.getString("fsize"));
                dto.setSimplename(rowSet.getString("fsimplename"));
                dto.setExtCss(AttchmentUtil.getFileExtName(rowSet.getString("fsimplename")));
                dto.setLastupdatetime(lastUpdateTime);
                dto.setCreateTime(createTime);
                list.add(dto);
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getFileExtName(String fileType) {
        String extName = "type-pic htm";
        if (StringUtils.isEmpty((String)fileType)) {
            return extName;
        }
        extName = "doc".equalsIgnoreCase(fileType = fileType.toLowerCase()) || "docx".equalsIgnoreCase(fileType) ? "type-pic doc" : ("xls".equalsIgnoreCase(fileType) || "xlsx".equalsIgnoreCase(fileType) ? "type-pic xls" : ("ppt".equalsIgnoreCase(fileType) || "pptx".equalsIgnoreCase(fileType) ? "type-pic ppt" : ("jpg".equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType) || "png".equalsIgnoreCase(fileType) || "bmp".equalsIgnoreCase(fileType) || "gif".equalsIgnoreCase(fileType) ? "type-pic img" : ("zip".equalsIgnoreCase(fileType) || "rar".equalsIgnoreCase(fileType) ? "type-pic rar" : ("pdf".equalsIgnoreCase(fileType) ? "type-pic pdf" : ("mp3".equalsIgnoreCase(fileType) ? "type-pic mp3" : ("mp4".equalsIgnoreCase(fileType) || "rm".equalsIgnoreCase(fileType) || "rmvb".equalsIgnoreCase(fileType) || "avi".equalsIgnoreCase(fileType) || "mov".equalsIgnoreCase(fileType) || "3gp".equalsIgnoreCase(fileType) ? "type-pic vdo" : ("txt".equalsIgnoreCase(fileType) ? "type-pic htm" : "type-pic htm"))))))));
        return extName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPicGroupAttchment(File contentFolder, Context ctx, String id) {
        File file = null;
        if (StringUtils.isEmpty((String)id)) {
            return "";
        }
        id = AttachmentUtils.init().checkID(id);
        AttachmentInfo info = null;
        try {
            BOSUuid.read((String)id);
            info = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (Exception e) {
            System.out.println("getAttachmentInfo: " + e.getMessage());
        }
        FileOutputStream out = null;
        try {
            String path = contentFolder.getPath() + File.separator + "images" + File.separator;
            String fileName = "";
            file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            fileName = XTUtil.formatFileName(id) + "." + info.getSimpleName();
            file = new File(path + fileName);
            if (!file.exists()) {
                AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
                byte[] size = asm.download(info.getId().toString());
                if (size != null) {
                    size = ImageUtil.scaleByWidth((byte[])size, (int)ThumbnailSizeEnum.BIG_WIDTH.value(), (String)info.getSimpleName());
                }
                XtImageUtil.createImageFile(contentFolder, "images" + File.separator + fileName, size);
                CompressPic pic = new CompressPic();
                pic.setInputDir(file.getPath());
                pic.setOutputDir(path);
                pic.setOutputFileName("title" + file.getName());
                pic.setWidthAndHeight(150, 150);
                pic.setProportion(true);
                pic.setMin(true);
                pic.compressPic();
            }
        }
        catch (Exception e) {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return file.getName();
    }
}

