/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.xt;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class CompressPic {
    private File file = null;
    private String inputDir = "";
    private String outputDir = "";
    private String inputFileName = "";
    private String outputFileName = "";
    private int outputWidth = 150;
    private int outputHeight = 150;
    private boolean proportion = true;
    private boolean isMin = true;

    public void setInputDir(String inputDir) {
        this.inputDir = inputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setOutputWidth(int outputWidth) {
        this.outputWidth = outputWidth;
    }

    public void setOutputHeight(int outputHeight) {
        this.outputHeight = outputHeight;
    }

    public void setWidthAndHeight(int width, int height) {
        this.outputWidth = width;
        this.outputHeight = height;
    }

    public boolean isProportion() {
        return this.proportion;
    }

    public void setProportion(boolean proportion) {
        this.proportion = proportion;
    }

    public boolean isMin() {
        return this.isMin;
    }

    public void setMin(boolean isMin) {
        this.isMin = isMin;
    }

    public long getPicSize(String path) {
        this.file = new File(path);
        return this.file.length();
    }

    public boolean compressPic() {
        boolean flag = false;
        try {
            int newHeight;
            int newWidth;
            this.file = new File(this.inputDir);
            if (!this.file.exists()) {
                return flag;
            }
            BufferedImage img = ImageIO.read(this.file);
            if (((Image)img).getWidth(null) == -1) {
                System.out.println(" can't read,retry!<BR>");
                return flag;
            }
            if (this.proportion) {
                double rate2;
                int img_w = ((Image)img).getWidth(null);
                int img_h = ((Image)img).getHeight(null);
                double rate1 = (double)((Image)img).getWidth(null) / (double)this.outputWidth + 0.1;
                double rate = rate1 > (rate2 = (double)((Image)img).getHeight(null) / (double)this.outputHeight + 0.1) ? rate1 : rate2;
                newWidth = (int)((double)((Image)img).getWidth(null) / rate);
                newHeight = (int)((double)((Image)img).getHeight(null) / rate);
                if (img_w > this.outputWidth && img_h > this.outputWidth) {
                    newWidth = img_w > img_h ? this.outputWidth : newWidth;
                    newHeight = img_w < img_h ? this.outputHeight : newHeight;
                } else {
                    newWidth = this.outputWidth;
                    newHeight = this.outputHeight;
                }
            } else {
                newWidth = this.outputWidth;
                newHeight = this.outputHeight;
            }
            BufferedImage tag = new BufferedImage(newWidth, newHeight, 1);
            tag.getGraphics().drawImage(img.getScaledInstance(newWidth, newHeight, 4), 0, 0, null);
            File f = new File(this.outputDir);
            if (!f.exists()) {
                f.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(this.outputDir + this.outputFileName);
            ImageIO.write((RenderedImage)tag, "png", out);
            out.close();
            flag = true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            flag = false;
        }
        return flag;
    }

    public boolean compressPic(String outputDir, String inputFileName, String outputFileName) {
        this.outputDir = outputDir;
        this.inputFileName = inputFileName;
        this.outputFileName = outputFileName;
        return this.compressPic();
    }

    public boolean compressPic(String inputDir, String outputDir, String inputFileName, String outputFileName, int width, int height, boolean proportion) {
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.inputFileName = inputFileName;
        this.outputFileName = outputFileName;
        this.setWidthAndHeight(width, height);
        this.proportion = proportion;
        return this.compressPic();
    }
}

