/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.xt;

import com.kingdee.lightapp.util.image.IImageByteConverter;
import com.kingdee.lightapp.util.image.ImageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;

public class HTMLUtil {
    private static final String regxpForHtmlTagSelf = "(?<=<|/)\\s*\\w+\\s*(?=\\s|>)";
    private static final String regxpForHtml = "<([^>]*)>";
    private static final String regxpForImgTag = "(<\\s*img\\s+)([^>]*)(\\s*>)";
    private static final String regxpForImaTagSrcAttribute = "(src=\")([^\"]+)(\")";

    private HTMLUtil() {
    }

    public static String convertHtmlTagToLowerCase(String content) {
        String regxp = regxpForHtmlTagSelf;
        Pattern pattern = Pattern.compile(regxp);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            matcher.appendReplacement(sb, matcher.group(0).toLowerCase());
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String convertSymbolToEntity(String content) {
        content = content.replaceAll("&", "&amp;");
        content = content.replaceAll("\"", "&quot;");
        content = content.replaceAll("'", "&#039;");
        content = content.replaceAll("<", "&lt;");
        content = content.replaceAll(">", "&gt;");
        return content;
    }

    public static String convertEntityToSymbol(String content) {
        content = content.replaceAll("&amp;", "&");
        content = content.replaceAll("&quot;", "\"");
        content = content.replaceAll("&#039;", "'");
        content = content.replaceAll("&lt;", "<");
        content = content.replaceAll("&gt;", ">");
        return content;
    }

    public static String convertReturnToBr(String content) {
        return content.replaceAll("\n", "<br>");
    }

    public static String convertBrToReturn(String content) {
        return content.replaceAll("<br>", "\n");
    }

    public static String convertBlankToNBSP(String content) {
        return content.replaceAll(" ", "&nbsp;");
    }

    public static String convertNBSPToBlank(String content) {
        return content.replaceAll("&nbsp;", " ");
    }

    public static String convertImgSrcToData(String content, String prefix, IImageByteConverter convert) {
        String regxpForTag = regxpForImgTag;
        String regxpForTagAttribute = regxpForImaTagSrcAttribute;
        Pattern patternForTag = Pattern.compile(regxpForTag);
        Pattern patternForAttribute = Pattern.compile(regxpForTagAttribute);
        Matcher matcherForTag = patternForTag.matcher(content);
        StringBuffer sb = new StringBuffer();
        boolean result = matcherForTag.find();
        while (result) {
            StringBuffer sbreplace = new StringBuffer();
            Matcher matcherForAttribute = patternForAttribute.matcher(matcherForTag.group(2));
            if (matcherForAttribute.find()) {
                String path = matcherForAttribute.group(2);
                if (path.substring(0, prefix.length()).equalsIgnoreCase(prefix)) {
                    convert.setPath(path);
                    String format = convert.getFormat();
                    String type = new MimetypesFileTypeMap().getContentType("." + format);
                    if (type.equals("application/octet-stream")) {
                        format = "jpg";
                        type = new MimetypesFileTypeMap().getContentType("." + format);
                    }
                    String base64 = ImageUtil.getImageBase64String((String)path, (String)format, (IImageByteConverter)convert);
                    matcherForAttribute.appendReplacement(sbreplace, "$1data:" + type + ";base64," + base64 + "$3");
                    matcherForTag.appendReplacement(sb, "$1" + sbreplace.toString() + "$3");
                } else {
                    matcherForTag.appendReplacement(sb, "$0");
                }
            } else {
                matcherForTag.appendReplacement(sb, "$0");
            }
            result = matcherForTag.find();
        }
        matcherForTag.appendTail(sb);
        return sb.toString();
    }

    public static String stripHtml(String content) {
        Pattern pattern = Pattern.compile(regxpForHtml);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, "");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String stripHtmlSingleTag(String content, String tag) {
        String regxp = "<\\/?(?:" + tag + ")[^>]*>";
        Pattern pattern = Pattern.compile(regxp);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, "");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String stripHtmlPairTagIncludeContent(String content, String tag) {
        content = content.replaceAll("<" + tag + "([^>]*)>([\\s\\S]*?)</" + tag + ">", "");
        return content;
    }

    public static String stripHtmlPairTagExcludeContent(String content, String tag) {
        content = content.replaceAll("<" + tag + "([^>]*)>([\\s\\S]*?)</" + tag + ">", "$2");
        return content;
    }

    public static String stripHtmlDocumentTags(String content) {
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "html");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "body");
        content = HTMLUtil.stripHtmlSingleTag(content, "(html|body)");
        return content;
    }

    public static String stripHtmlTableTags(String content) {
        return content;
    }

    private static String stripHtmlTableSingleTags(String content) {
        content = HTMLUtil.stripHtmlSingleTag(content, "(table|thead|tbody|tfoot|tr|td|th\b|col\b|colgroup|caption)");
        return content;
    }

    public static String stripHtmlListTags(String content) {
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "ul");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "ol");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "li");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "dl");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "dt");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "dd");
        content = HTMLUtil.stripHtmlSingleTag(content, "(ul|ol|li|dl|dt|dd)");
        return content;
    }

    public static String stripHtmlArticleTags(String content) {
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "h1");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "h2");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "h3");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "h4");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "h5");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "h6");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "span");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "bdo");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "pre");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "acronym");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "abbr");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "address");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "q");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "ins");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "del");
        content = HTMLUtil.stripHtmlSingleTag(content, "(h1|h2|h3|h4|h5|h6|span|bdo|pre|acronym|abbr|address|q\b|ins|del)");
        return content;
    }

    public static String stripHtmlTextTags(String content) {
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "font");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "u");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "center");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "s");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "strike");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "basefont");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "tt");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "i");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "b");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "big");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "small");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "em");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "strong");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "dfn");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "code");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "samp");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "kbd");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "var");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "cite");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "sup");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "sub");
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "blockquote");
        content = HTMLUtil.stripHtmlSingleTag(content, "(font|u\b|center|s\b|strike|basefont|tt|i\b|b\b|big|small|em|strong|dfn|code|samp|kbd|var|cite|sup|sub|blockquote)");
        return content;
    }

    public static String stripHtmlSpecialTags(String content) {
        content = HTMLUtil.stripHtmlSingleTag(content, "(!DOCTYPE|!|hr)");
        return content;
    }

    public static String stripHtmlLayoutTag(String content) {
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "div");
        content = HTMLUtil.stripHtmlSingleTag(content, "div");
        return content;
    }

    public static String stripHtmlHrefTag(String content) {
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "a");
        content = HTMLUtil.stripHtmlSingleTag(content, "a\b");
        return content;
    }

    public static String stripHtmlDocumentContent(String content) {
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "head");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "style");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "script");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "noscript");
        content = HTMLUtil.stripHtmlSingleTag(content, "(head|title|meat|base|style|link|script|noscript)");
        return content;
    }

    public static String stripHtmlMediaContent(String content) {
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "object");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "area");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "map");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "video");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "audio");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "embed");
        content = HTMLUtil.stripHtmlSingleTag(content, "(object|pram|area|video|audio|embed)");
        return content;
    }

    public static String stripHtmlFormContent(String content) {
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "form");
        content = HTMLUtil.stripHtmlSingleTag(content, "(form|input|textarea|button|select|optgroup|option|label|fieldset|legend)");
        return content;
    }

    public static String stripHtmlFrameContent(String content) {
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "frameset");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "iframe");
        content = HTMLUtil.stripHtmlSingleTag(content, "(frameset|frame|noframes|iframe)");
        return content;
    }

    public static String stripHtmlTableContent(String content) {
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "table");
        content = HTMLUtil.stripHtmlTableSingleTags(content);
        return content;
    }

    public static String stripHtmlHrefContent(String content) {
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "a");
        return content;
    }

    public static String stripXMLTag(String content) {
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "xml");
        return content;
    }

    public static String stripHtmlWordFormat(String content) {
        content = HTMLUtil.stripHtmlPairTagExcludeContent(content, "v:shape");
        content = content.replaceAll("(<p)([^>]*)(>.*?)(<\\/p>)", "<p$3</p>");
        content = content.replaceAll("<[/]?(font|span|xml|del|ins|meta|[ovwxpOVWXP]:\\w+)[^>]*?>", "");
        content = content.replaceAll("<([^>]*)(?:lang|LANG|class|CLASS|style|STYLE|size|SIZE|face|FACE|[ovwxpOVWXP]:\\w+)=(?:'[^']*'|\"\"[^\"\"]*\"\"|[^>]+)([^>]*)>", "<$1$2>");
        content = HTMLUtil.stripHtmlPairTagIncludeContent(content, "(style)");
        content = HTMLUtil.stripHtmlComment(content);
        content = HTMLUtil.stripHtmlSingleTag(content, "!\\[if !vml\\]");
        content = HTMLUtil.stripHtmlSingleTag(content, "!\\[endif\\]");
        return content;
    }

    public static String stripHtmlAttribute(String content, String attrib) {
        content = content.replaceAll(attrib + "=(\"?\\w*\"?)", "");
        return content;
    }

    public static String stripHtmlImageAttribute(String content) {
        content = HTMLUtil.stripHtmlAttribute(content, "(width|height|style|class)");
        return content;
    }

    public static String stripHtmlImgStyle(String content) {
        String regxp = "(width|height|style|class)=\"([^\"]+)\"";
        Pattern pattern = Pattern.compile(regxp);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            matcher.appendReplacement(sb, "");
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String stripHtmlComment(String content) {
        content = content.replaceAll("<!--[\\s\\S]*?-->", "");
        return content;
    }

    public static String stripHtmlBlankLine(String content) {
        content = content.replaceAll("(\\r\\n)*", "");
        return content;
    }

    public static String stripHtmlSpace(String content) {
        content = content.replaceAll("(?<=<[^>]{1,10000}>)\\s+(?=<[^>]+>)", "");
        return content;
    }

    public static List<String> getImgSrcList(String content) {
        ArrayList<String> list = null;
        Pattern patternForTag = Pattern.compile(regxpForImgTag);
        Matcher matcherForTag = patternForTag.matcher(content);
        boolean result = matcherForTag.find();
        while (result) {
            Pattern patternForAttribute = Pattern.compile(regxpForImaTagSrcAttribute);
            Matcher matcherForAttribute = patternForAttribute.matcher(matcherForTag.group(0));
            if (matcherForAttribute.find()) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(matcherForAttribute.group(2));
            }
            result = matcherForTag.find();
        }
        return list;
    }
}

