/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.xt;

import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.util.stream.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MHTUtil {
    public static byte[] getHtmlDataFromMhtData(byte[] mhtData, ResourceSaveModeEnum resMode) {
        byte[] data = null;
        try {
            String text = MHTUtil.getHtmlStringFromMhtData(mhtData, resMode);
            data = text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static String getHtmlStringFromMhtData(byte[] mhtData, ResourceSaveModeEnum resMode) {
        String text = "";
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(mhtData);
            text = MHTUtil.convertMht(is, null, resMode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    public static void getHtmlFileFromMhtFile(String mhtPath, String htmlPath, ResourceSaveModeEnum resMode) {
        try {
            FileInputStream is = new FileInputStream(mhtPath);
            MHTUtil.convertMht(is, htmlPath, resMode);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void getHtmlFileFromMhtData(byte[] mhtData, String htmlPath, ResourceSaveModeEnum resMode) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(mhtData);
            MHTUtil.convertMht(is, htmlPath, resMode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String convertMht(InputStream is, String htmlPath, ResourceSaveModeEnum resMode) {
        String text = "";
        try {
            System.out.println("into convertMht......");
            List<MimeBodyPart> list = MHTUtil.getMimeBodyParts(is);
            MimeBodyPart bp2 = list.get(0);
            String encodng = MHTUtil.getEncoding(bp2);
            text = MHTUtil.getHtmlText(bp2, encodng);
            text = text.replace("v:imagedata", "img");
            String pathPrefix = MHTUtil.getPathPrefix(bp2);
            if (text != null) {
                File parent = null;
                if (resMode == ResourceSaveModeEnum.SaveAllToFile || resMode == ResourceSaveModeEnum.SaveImageToFile) {
                    parent = MHTUtil.createResourceFolder(htmlPath, list);
                    if (!StringUtil.isEmpty((String)htmlPath) && parent == null) {
                        return null;
                    }
                }
                for (MimeBodyPart bp2 : list) {
                    String url = MHTUtil.getResourcesUrl(bp2);
                    if (!StringUtil.isEmpty((String)url)) {
                        text = MHTUtil.getRealURLText(text, bp2, pathPrefix, url, resMode, parent);
                    }
                    MHTUtil.SaveHtml(text, htmlPath, encodng);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    private static File createResourceFolder(String htmlPath, List<MimeBodyPart> list) {
        File parent = null;
        if (!StringUtil.isEmpty((String)htmlPath) && list.size() > 1) {
            parent = new File(new File(htmlPath).getAbsolutePath() + ".files");
            parent.mkdirs();
            if (!parent.exists()) {
                return null;
            }
        }
        return parent;
    }

    private static String getRealURLText(String text, MimeBodyPart bp, String pathPrefix, String url, ResourceSaveModeEnum resMode, File parent) throws IOException, MessagingException {
        if (!(resMode != ResourceSaveModeEnum.SaveImageToFile && resMode != ResourceSaveModeEnum.EmbedImageToHTML || bp.getContentType().substring(0, 6).equals("image/"))) {
            return text;
        }
        if (resMode == ResourceSaveModeEnum.SaveAllToFile || resMode == ResourceSaveModeEnum.SaveImageToFile) {
            String FilePath = parent.getAbsolutePath() + File.separator + MHTUtil.getName(url);
            File resources = new File(FilePath);
            if (MHTUtil.SaveResourcesFile(resources, bp.getInputStream())) {
                text = text.replace(url.replaceAll(pathPrefix, ""), "file://" + resources.getAbsolutePath());
            }
        } else if (resMode == ResourceSaveModeEnum.EmbedImageToHTML) {
            String base64 = StringUtil.getBase64FromByte((byte[])StreamUtil.getByteFromInputStream((InputStream)bp.getInputStream()));
            text = text.replace(url.replace(pathPrefix, ""), "data:" + bp.getContentType() + ";base64," + base64);
        }
        return text;
    }

    private static String getPathPrefix(MimeBodyPart bp) {
        if (bp == null) {
            return null;
        }
        try {
            Enumeration list = bp.getAllHeaders();
            while (list.hasMoreElements()) {
                int i;
                Header head = (Header)list.nextElement();
                if (!head.getName().equalsIgnoreCase("Content-Location")) continue;
                String location = head.getValue();
                String pathPrefix = "";
                if (location.substring(0, 5).equalsIgnoreCase("file:") && (i = location.lastIndexOf(47)) > 0 && i < location.length() - 1) {
                    pathPrefix = location.substring(0, i + 1);
                }
                return pathPrefix;
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getName(String strName) {
        int separator1 = 47;
        int separator2 = 92;
        if ((strName = strName.replaceAll("\r\n", "")).lastIndexOf(separator1) >= 0) {
            return strName.substring(strName.lastIndexOf(separator1) + 1);
        }
        if (strName.lastIndexOf(separator2) >= 0) {
            return strName.substring(strName.lastIndexOf(separator2) + 1);
        }
        return "";
    }

    private static boolean SaveHtml(String htmlText, String htmlPath, String encode) {
        if (!StringUtil.isEmpty((String)htmlPath)) {
            try {
                OutputStreamWriter out = null;
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlPath, false), encode);
                out.write(htmlText);
                ((Writer)out).close();
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static List<MimeBodyPart> getMimeBodyParts(InputStream is) {
        ArrayList<MimeBodyPart> list = new ArrayList<MimeBodyPart>();
        try {
            System.out.println("into getMimeBodyParts......");
            Session mailSession = Session.getDefaultInstance((Properties)System.getProperties(), null);
            System.out.println("**************Session.getDefaultInstance(System.getProperties(), null)************");
            MimeMessage msg = new MimeMessage(mailSession, is);
            System.out.println("**************MimeMessage msg = new MimeMessage(mailSession, is)************");
            Object content = msg.getContent();
            System.out.println("************** msg.getContent()************");
            if (content instanceof Multipart) {
                System.out.println("************** if (content instanceof Multipart)************");
                MimeMultipart mp = (MimeMultipart)content;
                for (int i = 0; i < mp.getCount(); ++i) {
                    list.add((MimeBodyPart)mp.getBodyPart(i));
                }
                System.out.println("************** end if (content instanceof Multipart)************");
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean SaveResourcesFile(File SrcFile, InputStream inputStream) {
        if (SrcFile == null || inputStream == null) {
            return false;
        }
        BufferedInputStream in = null;
        FileOutputStream fio = null;
        FilterOutputStream osw = null;
        try {
            in = new BufferedInputStream(inputStream);
            fio = new FileOutputStream(SrcFile);
            osw = new BufferedOutputStream(new DataOutputStream(fio));
            int index = 0;
            byte[] a = new byte[1024];
            while ((index = in.read(a)) != -1) {
                ((BufferedOutputStream)osw).write(a, 0, index);
            }
            ((BufferedOutputStream)osw).flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
                if (fio != null) {
                    fio.close();
                }
                if (in != null) {
                    in.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    private static String getResourcesUrl(MimeBodyPart bp) {
        if (bp == null) {
            return null;
        }
        try {
            Enumeration list = bp.getAllHeaders();
            while (list.hasMoreElements()) {
                Header head = (Header)list.nextElement();
                if (head.getName().compareTo("Content-Location") != 0) continue;
                return head.getValue();
            }
            return null;
        }
        catch (MessagingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHtmlText(MimeBodyPart bp, String strEncoding) {
        StringBuffer strHtml = new StringBuffer("");
        InputStream textStream = null;
        BufferedInputStream buff = null;
        BufferedReader br = null;
        InputStreamReader r = null;
        try {
            textStream = bp.getInputStream();
            buff = new BufferedInputStream(textStream);
            r = new InputStreamReader((InputStream)buff, strEncoding);
            br = new BufferedReader(r);
            String strLine = null;
            while ((strLine = br.readLine()) != null) {
                strHtml.append(strLine + "\r\n");
            }
            br.close();
            ((Reader)r).close();
            textStream.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (buff != null) {
                    buff.close();
                }
                if (textStream != null) {
                    textStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return strHtml.toString();
    }

    private static String getEncoding(MimeBodyPart bp) {
        if (bp == null) {
            return null;
        }
        try {
            Enumeration list = bp.getAllHeaders();
            while (list.hasMoreElements()) {
                String strType;
                int pos;
                Header head = (Header)list.nextElement();
                if (!head.getName().equalsIgnoreCase("Content-Type") || (pos = (strType = head.getValue()).indexOf("charset=")) < 0) continue;
                String strEncoding = strType.substring(pos + 8, strType.length());
                if (strEncoding.startsWith("\"") || strEncoding.startsWith("'")) {
                    strEncoding = strEncoding.substring(1, strEncoding.length());
                }
                if (strEncoding.endsWith("\"") || strEncoding.endsWith("'")) {
                    strEncoding = strEncoding.substring(0, strEncoding.length() - 1);
                }
                if (strEncoding.toLowerCase().compareTo("gb2312") == 0) {
                    strEncoding = "gbk";
                }
                return strEncoding;
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum ResourceSaveModeEnum {
        SaveAllToFile,
        SaveImageToFile,
        EmbedImageToHTML;

    }
}

