/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.ByteArray;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInput;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInputInterface;
import com.kingdee.eas.cp.hsqldb.lib.HsqlDateTime;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class BinaryServerRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    public BinaryServerRowInput(byte[] bin) throws IOException {
        super(bin, -1);
    }

    public BinaryServerRowInput(byte[] bin, int pos) throws IOException {
        super(bin, pos);
    }

    byte[] readByteArray() throws IOException {
        byte[] b = new byte[this.readInt()];
        this.readFully(b);
        return b;
    }

    @Override
    public int readType() throws IOException {
        return this.readShort();
    }

    @Override
    public int readIntData() throws IOException {
        return this.readInt();
    }

    @Override
    public String readString() throws IOException {
        byte[] bytes = new byte[this.readInt()];
        this.readFully(bytes);
        return new String(bytes, "utf-8");
    }

    @Override
    protected boolean checkNull() throws IOException {
        byte b = this.readByte();
        return b == 0;
    }

    @Override
    protected String readChar(int type) throws IOException {
        return this.readString();
    }

    @Override
    protected Integer readSmallint() throws IOException, SQLException {
        return new Integer(this.readShort());
    }

    @Override
    protected Integer readInteger() throws IOException, SQLException {
        return new Integer(this.readInt());
    }

    @Override
    protected Long readBigint() throws IOException, SQLException {
        return new Long(this.readLong());
    }

    @Override
    protected Double readReal(int type) throws IOException, SQLException {
        return new Double(Double.longBitsToDouble(this.readLong()));
    }

    @Override
    protected BigDecimal readDecimal() throws IOException, SQLException {
        byte[] bytes = this.readByteArray();
        int scale = this.readInt();
        BigInteger bigint = new BigInteger(bytes);
        return new BigDecimal(bigint, scale);
    }

    @Override
    protected Boolean readBit() throws IOException, SQLException {
        return new Boolean(this.readBoolean());
    }

    @Override
    protected Time readTime() throws IOException, SQLException {
        return new Time(this.readLong());
    }

    @Override
    protected Date readDate() throws IOException, SQLException {
        return new Date(this.readLong());
    }

    @Override
    protected Timestamp readTimestamp() throws IOException, SQLException {
        return HsqlDateTime.timestampValue(this.readLong(), this.readInt());
    }

    @Override
    protected Object readOther() throws IOException, SQLException {
        byte[] o = this.readByteArray();
        return ByteArray.deserialize(o);
    }

    @Override
    protected byte[] readBinary(int type) throws IOException, SQLException {
        return this.readByteArray();
    }
}

