/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.StringConverter;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;

class ByteArray {
    private ByteArray() {
    }

    static byte[] hexToByteArray(String hexString) throws SQLException {
        return StringConverter.hexToByte(hexString);
    }

    static int compareTo(byte[] o1, byte[] o2) {
        int len = o1.length;
        int lenb = o2.length;
        int i = 0;
        while (true) {
            int a = 0;
            int b = 0;
            if (i < len) {
                a = o1[i] & 0xFF;
            } else if (i >= lenb) {
                return 0;
            }
            if (i < lenb) {
                b = o2[i] & 0xFF;
            }
            if (a > b) {
                return 1;
            }
            if (b > a) {
                return -1;
            }
            ++i;
        }
    }

    static byte[] serialize(Object s) throws SQLException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bo);
            os.writeObject(s);
            return bo.toByteArray();
        }
        catch (Exception e) {
            throw Trace.error(18, e.getMessage());
        }
    }

    static String serializeToString(Object s) throws SQLException {
        return StringConverter.byteToHex(ByteArray.serialize(s));
    }

    static Object deserialize(byte[] ba) throws SQLException {
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(ba);
            ObjectInputStream is = new ObjectInputStream(bi);
            return is.readObject();
        }
        catch (Exception e) {
            throw Trace.error(18, e.getMessage());
        }
    }

    public static String toString(byte[] o) {
        return StringConverter.byteToHex(o);
    }
}

