/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.BinaryDatabaseRowInput;
import com.kingdee.eas.cp.hsqldb.BinaryDatabaseRowOutput;
import com.kingdee.eas.cp.hsqldb.BinaryServerRowInput;
import com.kingdee.eas.cp.hsqldb.BinaryServerRowOutput;
import com.kingdee.eas.cp.hsqldb.CacheFree;
import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.DatabaseFile;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInput;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInputInterface;
import com.kingdee.eas.cp.hsqldb.DatabaseRowOutput;
import com.kingdee.eas.cp.hsqldb.HsqlDatabaseProperties;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

class Cache {
    private HsqlDatabaseProperties props;
    private boolean newCacheType;
    private final int cacheLength;
    private final int writerLength;
    private final int maxCacheSize;
    private final int multiplierMask;
    private CachedRow[] rData;
    private CachedRow[] rWriter;
    private CachedRow rFirst;
    private CachedRow rLastChecked;
    protected String sName;
    protected int iFreePos;
    protected DatabaseFile rFile;
    private static final int FREE_POS_POS = 16;
    private static final int INITIAL_FREE_POS = 32;
    private static final int MAX_FREE_COUNT = 1024;
    private CacheFree fRoot;
    private int iFreeCount;
    private int iCacheSize;

    Cache(String name, HsqlDatabaseProperties props) {
        this.props = props;
        int cacheScale = 0;
        try {
            cacheScale = props.getIntegerProperty("hsqldb.cache_scale", 0);
        }
        catch (NumberFormatException e) {
            Trace.printSystemOut("bad value for hsqldb.cache_scale in properties file");
        }
        if (cacheScale == 0) {
            cacheScale = 15;
        } else if (cacheScale < 8) {
            cacheScale = 8;
        } else if (cacheScale > 16) {
            cacheScale = 16;
        }
        this.cacheLength = 1 << cacheScale;
        this.writerLength = this.cacheLength - 3;
        this.maxCacheSize = this.cacheLength * 3;
        this.multiplierMask = this.cacheLength - 1;
        this.sName = name;
        this.rData = new CachedRow[this.cacheLength];
        this.rWriter = new CachedRow[this.writerLength];
    }

    void open(boolean readonly) throws SQLException {
        try {
            boolean exists = false;
            File f = new File(this.sName);
            if (f.exists() && f.length() > 16L) {
                exists = true;
            }
            this.rFile = new DatabaseFile(this.sName, readonly ? "r" : "rw", 2048);
            if (exists) {
                this.rFile.readSeek(16L);
                this.iFreePos = this.rFile.readInteger();
            } else {
                this.iFreePos = 32;
                this.props.setProperty("hsqldb.cache_version", "1.7.0");
            }
            String cacheVersion = this.props.getProperty("hsqldb.cache_version", "1.6.0");
            if (cacheVersion.equals("1.7.0")) {
                this.newCacheType = true;
            }
        }
        catch (Exception e) {
            throw Trace.error(29, "error " + e + " opening " + this.sName);
        }
    }

    void flush() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.seek(16L);
            this.rFile.writeInteger(this.iFreePos);
            this.saveAll();
            boolean empty = this.rFile.length() < 32L;
            this.rFile.close();
            this.rFile = null;
            if (empty) {
                new File(this.sName).delete();
            }
        }
        catch (Exception e) {
            throw Trace.error(29, "error " + e + " closing " + this.sName);
        }
    }

    void closeFile() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.close();
            this.rFile = null;
        }
        catch (Exception e) {
            throw Trace.error(29, "error " + e + " in shutdown " + this.sName);
        }
    }

    void free(CachedRow r) throws SQLException {
        ++this.iFreeCount;
        CacheFree n = new CacheFree();
        n.iPos = r.iPos;
        n.iLength = r.storageSize;
        if (this.iFreeCount > 1024) {
            this.iFreeCount = 0;
        } else {
            n.fNext = this.fRoot;
        }
        this.fRoot = n;
        this.remove(r);
    }

    protected void setStorageSize(CachedRow r) throws SQLException {
        Table t = r.getTable();
        int size = 8 + 32 * t.getIndexCount();
        size = this.newCacheType ? (size += BinaryServerRowOutput.getSize(r)) : (size += BinaryDatabaseRowOutput.getSize(r));
        r.storageSize = size = (size + 7) / 8 * 8;
    }

    void add(CachedRow r) throws SQLException {
        int k;
        CachedRow before;
        int rowSize;
        this.setStorageSize(r);
        int size = rowSize = r.storageSize;
        CacheFree f = this.fRoot;
        CacheFree last = null;
        int i = this.iFreePos;
        while (f != null) {
            if (Trace.TRACE) {
                Trace.stop();
            }
            if (f.iLength >= size) {
                i = f.iPos;
                if ((size = f.iLength - size) < 8) {
                    if (last == null) {
                        this.fRoot = f.fNext;
                    } else {
                        last.fNext = f.fNext;
                    }
                    --this.iFreeCount;
                    break;
                }
                f.iLength = size;
                f.iPos += rowSize;
                break;
            }
            last = f;
            f = f.fNext;
        }
        r.setPos(i);
        if (i == this.iFreePos) {
            this.iFreePos += size;
        }
        if ((before = this.rData[k = i >> 3 & this.multiplierMask]) == null) {
            before = this.rFirst;
        }
        r.insert(before);
        ++this.iCacheSize;
        this.rData[k] = r;
        this.rFirst = r;
    }

    protected CachedRow makeRow(int pos, Table t) throws SQLException {
        CachedRow r = null;
        try {
            this.rFile.readSeek(pos);
            int size = this.rFile.readInteger();
            byte[] buffer = new byte[size];
            this.rFile.read(buffer);
            DatabaseRowInput in = this.newCacheType ? new BinaryServerRowInput(buffer, pos) : new BinaryDatabaseRowInput(buffer, pos);
            r = new CachedRow(t, (DatabaseRowInputInterface)((Object)in));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Trace.error(29, "reading: " + e);
        }
        return r;
    }

    CachedRow getRow(int pos, Table t) throws SQLException {
        CachedRow before;
        CachedRow r;
        int k = pos >> 3 & this.multiplierMask;
        CachedRow start = r = this.rData[k];
        int p = 0;
        while (r != null) {
            p = r.iPos;
            if (p == pos) {
                return r;
            }
            if ((p >> 3 & this.multiplierMask) == k && (r = r.rNext) != start) continue;
        }
        if ((before = this.rData[k]) == null) {
            before = this.rFirst;
        }
        if ((r = this.makeRow(pos, t)) != null) {
            r.insert(before);
            ++this.iCacheSize;
            this.rData[r.iPos >> 3 & this.multiplierMask] = r;
            this.rFirst = r;
            t.indexRow(r, false);
        }
        return r;
    }

    void cleanUp() throws SQLException {
        if (this.iCacheSize < this.maxCacheSize) {
            return;
        }
        int count = 0;
        int j = 0;
        while (j++ < this.cacheLength && this.iCacheSize > this.maxCacheSize / 2 && count < this.writerLength) {
            CachedRow r = this.getWorst();
            if (r == null) {
                return;
            }
            if (r.hasChanged()) {
                r.iLastAccess = CachedRow.iCurrentAccess;
                this.rWriter[count++] = r;
                continue;
            }
            if (r.isRoot()) continue;
            this.remove(r);
        }
        if (count != 0) {
            this.saveSorted(count);
        }
        for (int i = 0; i < count; ++i) {
            CachedRow r = this.rWriter[i];
            if (!r.isRoot()) {
                this.remove(r);
            }
            this.rWriter[i] = null;
        }
    }

    protected void remove(CachedRow r) throws SQLException {
        int k;
        if (r == this.rLastChecked) {
            this.rLastChecked = this.rLastChecked.rNext;
            if (this.rLastChecked == r) {
                this.rLastChecked = null;
            }
        }
        if (this.rData[k = r.iPos >> 3 & this.multiplierMask] == r) {
            CachedRow n;
            this.rFirst = n = r.rNext;
            if (n == r || (n.iPos >> 3 & this.multiplierMask) != k) {
                n = null;
            }
            this.rData[k] = n;
        }
        if (r == this.rFirst) {
            this.rFirst = this.rFirst.rNext;
            if (r == this.rFirst) {
                this.rFirst = null;
            }
        }
        r.free();
        --this.iCacheSize;
    }

    private CachedRow getWorst() throws SQLException {
        CachedRow r;
        if (this.rLastChecked == null) {
            this.rLastChecked = this.rFirst;
        }
        if ((r = this.rLastChecked) == null) {
            return null;
        }
        CachedRow candidate = r;
        int worst = CachedRow.iCurrentAccess;
        for (int i = 0; i < 6; ++i) {
            int w = r.iLastAccess;
            if (w < worst) {
                candidate = r;
                worst = w;
            }
            r = r.rNext;
        }
        this.rLastChecked = r.rNext;
        return candidate;
    }

    protected void saveAll() throws SQLException {
        if (this.rFirst == null) {
            return;
        }
        CachedRow r = this.rFirst;
        block0: while (true) {
            int count = 0;
            CachedRow begin = r;
            do {
                if (!r.hasChanged()) continue;
                this.rWriter[count++] = r;
            } while ((r = r.rNext) != begin && count < this.writerLength);
            if (count == 0) {
                return;
            }
            this.saveSorted(count);
            int i = 0;
            while (true) {
                if (i >= count) continue block0;
                this.rWriter[i] = null;
                ++i;
            }
            break;
        }
    }

    protected void saveRow(CachedRow r) throws IOException, SQLException {
        this.rFile.seek(r.iPos);
        DatabaseRowOutput out = this.newCacheType ? new BinaryServerRowOutput(r.storageSize) : new BinaryDatabaseRowOutput(r.storageSize);
        r.write(out);
        this.rFile.write(out.toByteArray());
    }

    private void saveSorted(int count) throws SQLException {
        Cache.sort(this.rWriter, 0, count - 1);
        try {
            for (int i = 0; i < count; ++i) {
                this.saveRow(this.rWriter[i]);
            }
        }
        catch (Exception e) {
            throw Trace.error(29, "saveSorted " + e);
        }
    }

    private static final void sort(CachedRow[] w, int l, int r) throws SQLException {
        int j;
        int i;
        while (r - l > 10) {
            i = r + l >> 1;
            if (w[l].iPos > w[r].iPos) {
                Cache.swap(w, l, r);
            }
            if (w[i].iPos < w[l].iPos) {
                Cache.swap(w, l, i);
            } else if (w[i].iPos > w[r].iPos) {
                Cache.swap(w, i, r);
            }
            j = r - 1;
            Cache.swap(w, i, j);
            int p = w[j].iPos;
            i = l;
            while (true) {
                if (w[++i].iPos < p) {
                    continue;
                }
                while (w[--j].iPos > p) {
                }
                if (i >= j) break;
                Cache.swap(w, i, j);
            }
            Cache.swap(w, i, r - 1);
            Cache.sort(w, l, i - 1);
            l = i + 1;
        }
        for (i = l + 1; i <= r; ++i) {
            CachedRow t = w[i];
            for (j = i - 1; j >= l && w[j].iPos > t.iPos; --j) {
                w[j + 1] = w[j];
            }
            w[j + 1] = t;
        }
    }

    private static void swap(CachedRow[] w, int a, int b) {
        CachedRow t = w[a];
        w[a] = w[b];
        w[b] = t;
    }

    int getFreePos() {
        return this.iFreePos;
    }
}

