/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.DatabaseRowInputInterface;
import com.kingdee.eas.cp.hsqldb.DatabaseRowOutputInterface;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.PointerNode;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Row;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.IOException;
import java.sql.SQLException;

class CachedRow
extends Row {
    static final int NO_POS = -1;
    static int iCurrentAccess = 0;
    protected Table tTable;
    int iLastAccess;
    CachedRow rLast;
    CachedRow rNext;
    int iPos = -1;
    int storageSize;
    private boolean bChanged;

    CachedRow(Table t, Object[] o) throws SQLException {
        this.tTable = t;
        int index = t.getIndexCount();
        Node n = this.nPrimaryNode = Node.newNode(this, 0, t);
        for (int i = 1; i < index; ++i) {
            n = n.nNext = Node.newNode(this, i, t);
        }
        this.oData = o;
        this.bChanged = true;
        this.iLastAccess = iCurrentAccess++;
        t.putRow(this);
    }

    void setPos(int pos) {
        this.iPos = pos;
        Node n = this.nPrimaryNode;
        while (n != null) {
            n.setKey(pos);
            n = n.nNext;
        }
    }

    void changed() {
        this.bChanged = true;
        this.iLastAccess = iCurrentAccess++;
    }

    boolean hasChanged() {
        return this.bChanged;
    }

    @Override
    Node getNode(int index) {
        this.iLastAccess = iCurrentAccess++;
        return super.getNode(index);
    }

    @Override
    Node getNextNode(Node n) {
        this.iLastAccess = iCurrentAccess++;
        return super.getNextNode(n);
    }

    @Override
    Object[] getData() {
        this.iLastAccess = iCurrentAccess++;
        return this.oData;
    }

    Table getTable() {
        return this.tTable;
    }

    void insert(CachedRow before) {
        ++Record.memoryRecords;
        if (before == null) {
            this.rNext = this;
            this.rLast = this;
        } else {
            this.rNext = before;
            this.rLast = before.rLast;
            before.rLast = this;
            this.rLast.rNext = this;
        }
    }

    boolean isRoot() throws SQLException {
        Node n = this.nPrimaryNode;
        while (n != null) {
            if (n.isRoot()) {
                return true;
            }
            n = n.nNext;
        }
        return false;
    }

    void write(DatabaseRowOutputInterface out) throws IOException, SQLException {
        out.writeSize(this.storageSize);
        if (this.tTable.isIndexCached()) {
            Node n = this.nPrimaryNode;
            while (n != null) {
                n.write(out);
                n = n.nNext;
            }
        }
        out.writeData(this.oData, this.tTable);
        out.writePos(this.iPos);
        this.bChanged = false;
    }

    @Override
    void delete() throws SQLException {
        ++Record.memoryRecords;
        this.bChanged = false;
        this.tTable.removeRow(this);
        this.rNext = null;
        this.rLast = null;
        this.tTable = null;
        this.oData = null;
        this.nPrimaryNode = null;
    }

    void free() throws SQLException {
        this.rLast.rNext = this.rNext;
        this.rNext.rLast = this.rLast;
        if (this.rNext == this) {
            this.rLast = null;
            this.rNext = null;
        }
    }

    CachedRow(Table t, DatabaseRowInputInterface in) throws IOException, SQLException {
        this.tTable = t;
        this.iPos = in.getPos();
        this.storageSize = in.getSize();
        int index = t.getIndexCount();
        Node n = this.nPrimaryNode = Node.newNode(this, in, 0, t);
        if (t.getIndexType() == 2) {
            ((PointerNode)this.nPrimaryNode).setNextKey(in.getNextPos());
        }
        for (int i = 1; i < index; ++i) {
            n = n.nNext = Node.newNode(this, in, i, t);
        }
        this.oData = in.readData(this.tTable.getColumnTypes());
        if (this.tTable.isIndexCached()) {
            Trace.check(in.readIntData() == this.iPos, 34);
        }
        this.iLastAccess = iCurrentAccess++;
    }
}

