/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.ByteArray;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Library;
import com.kingdee.eas.cp.hsqldb.StringConverter;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.lib.HsqlDateTime;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Hashtable;

class Column {
    static final int VARCHAR_IGNORECASE = 100;
    private static Hashtable hTypes;
    static final int[] numericTypes;
    static final int[] otherTypes;
    static final int[][] typesArray;
    HsqlName columnName;
    private int colType;
    private int colSize;
    private int colScale;
    private boolean isNullable;
    private boolean isIdentity;
    private boolean isPrimaryKey;
    private String defaultString;
    private static final BigDecimal BIGDECIMAL_0;
    private static Collator i18nCollator;
    private static boolean sql_compare_in_locale;

    Column(HsqlName name, boolean nullable, int type, int size, int scale, boolean identity, boolean primarykey, String defstring) {
        this.columnName = name;
        this.isNullable = nullable;
        this.colType = type;
        this.colSize = size;
        this.colScale = scale;
        this.isIdentity = identity;
        this.isPrimaryKey = primarykey;
        this.defaultString = defstring;
    }

    boolean isIdentity() {
        return this.isIdentity;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    void setNullable(boolean value) {
        this.isNullable = value;
    }

    boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
    }

    String getDefaultString() {
        return this.defaultString;
    }

    int getType() {
        return this.colType;
    }

    int getSize() {
        return this.colSize;
    }

    int getScale() {
        return this.colScale;
    }

    static int getTypeNr(String type) throws SQLException {
        Integer i = (Integer)hTypes.get(type);
        Trace.check(i != null, 16, type);
        return i;
    }

    static String getTypeString(int type) throws SQLException {
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 4: {
                return "INTEGER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 3: {
                return "DECIMAL";
            }
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMERIC";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 1111: {
                return "OBJECT";
            }
        }
        throw Trace.error(16, type);
    }

    static Object add(Object a, Object b, int type) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return new Double(ad + bd);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return (String)a + (String)b;
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.add(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return new Integer(ai + bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return new Long(longa + longb);
            }
        }
        throw Trace.error(20, type);
    }

    static Object concat(Object a, Object b) throws SQLException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Column.convertObject(a) + Column.convertObject(b);
    }

    static Object negate(Object a, int type) throws SQLException {
        if (a == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(-((Number)a).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).negate();
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(-((Number)a).intValue());
            }
            case -5: {
                return new Long(-((Number)a).longValue());
            }
        }
        throw Trace.error(20, type);
    }

    static Object multiply(Object a, Object b, int type) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return new Double(ad * bd);
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.multiply(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return new Integer(ai * bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return new Long(longa * longb);
            }
        }
        throw Trace.error(20, type);
    }

    static Object divide(Object a, Object b, int type) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return new Double(ad / bd);
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                int scale = abd.scale() > bbd.scale() ? abd.scale() : bbd.scale();
                return bbd.signum() == 0 ? null : abd.divide(bbd, scale, 5);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                Trace.check(bi != 0, 6);
                return new Integer(ai / bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return longb == 0L ? null : new Long(longa / longb);
            }
        }
        throw Trace.error(20, type);
    }

    static Object subtract(Object a, Object b, int type) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return new Double(ad - bd);
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.subtract(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return new Integer(ai - bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return new Long(longa - longb);
            }
        }
        throw Trace.error(20, type);
    }

    static Object sum(Object a, Object b, int type) throws SQLException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(((Number)a).doubleValue() + ((Number)b).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).add((BigDecimal)b);
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(((Number)a).intValue() + ((Number)b).intValue());
            }
            case -5: {
                return new Long(((Number)a).longValue() + ((Number)b).longValue());
            }
        }
        throw Trace.error(15);
    }

    static Object avg(Object a, int type, int count) throws SQLException {
        if (a == null || count == 0) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double((Double)a / (double)count);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).divide(new BigDecimal(count), 5);
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(((Number)a).intValue() / count);
            }
            case -5: {
                return new Long((Long)a / (long)count);
            }
        }
        throw Trace.error(15);
    }

    static Object min(Object a, Object b, int type) throws SQLException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (Column.compare(a, b, type) < 0) {
            return a;
        }
        return b;
    }

    static Object max(Object a, Object b, int type) throws SQLException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (Column.compare(a, b, type) > 0) {
            return a;
        }
        return b;
    }

    static void setCompareInLocal(boolean value) {
        sql_compare_in_locale = value;
    }

    static int compare(Object a, Object b, int type) throws SQLException {
        int i = 0;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (type) {
            case 0: {
                return 0;
            }
            case -1: 
            case 12: {
                if (sql_compare_in_locale) {
                    i = i18nCollator.compare((String)a, (String)b);
                    break;
                }
                i = ((String)a).compareTo((String)b);
                break;
            }
            case 1: {
                if (sql_compare_in_locale) {
                    i = i18nCollator.compare(Library.rtrim((String)a), Library.rtrim((String)b));
                    break;
                }
                i = Library.rtrim((String)a).compareTo(Library.rtrim((String)b));
                break;
            }
            case 100: {
                if (sql_compare_in_locale) {
                    i = i18nCollator.compare(((String)a).toUpperCase(), ((String)b).toUpperCase());
                    break;
                }
                i = ((String)a).toUpperCase().compareTo(((String)b).toUpperCase());
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ai > bi ? 1 : (bi > ai ? -1 : 0);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return longa > longb ? 1 : (longb > longa ? -1 : 0);
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ad > bd ? 1 : (bd > ad ? -1 : 0);
            }
            case 2: 
            case 3: {
                i = ((BigDecimal)a).compareTo((BigDecimal)b);
                break;
            }
            case 91: {
                if (((Date)a).after((Date)b)) {
                    return 1;
                }
                if (((Date)a).before((Date)b)) {
                    return -1;
                }
                return 0;
            }
            case 92: {
                if (((Time)a).after((Time)b)) {
                    return 1;
                }
                if (((Time)a).before((Time)b)) {
                    return -1;
                }
                return 0;
            }
            case 93: {
                if (((Timestamp)a).after((Timestamp)b)) {
                    return 1;
                }
                if (((Timestamp)a).before((Timestamp)b)) {
                    return -1;
                }
                return 0;
            }
            case -7: {
                boolean boola = (Boolean)a;
                boolean boolb = (Boolean)b;
                return boola == boolb ? 0 : (boolb ? -1 : 1);
            }
            case -4: 
            case -3: 
            case -2: {
                i = ByteArray.compareTo((byte[])a, (byte[])b);
                break;
            }
            case 1111: {
                return 0;
            }
            default: {
                throw Trace.error(20, type);
            }
        }
        return i > 0 ? 1 : (i < 0 ? -1 : 0);
    }

    private static String convertObject(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    static Object convertObject(Object o, int type) throws SQLException {
        try {
            if (o == null) {
                return null;
            }
            switch (type) {
                case 0: {
                    return null;
                }
                case -6: {
                    if (o instanceof String) {
                        o = new Integer((String)o);
                    }
                    if (o instanceof Integer || o instanceof Long) {
                        int temp = ((Number)o).intValue();
                        if (127 < temp || temp < -128) {
                            throw new NumberFormatException();
                        }
                        return o;
                    }
                    if (!(o instanceof Byte)) break;
                    return new Integer(((Number)o).intValue());
                }
                case 5: {
                    if (o instanceof String) {
                        o = new Integer((String)o);
                    }
                    if (o instanceof Integer || o instanceof Long) {
                        int temp = ((Number)o).intValue();
                        if (Short.MAX_VALUE < temp || temp < Short.MIN_VALUE) {
                            throw new NumberFormatException();
                        }
                        return o;
                    }
                    if (!(o instanceof Byte) && !(o instanceof Short)) break;
                    return new Integer(((Number)o).intValue());
                }
                case 4: {
                    if (o instanceof String) {
                        return new Integer((String)o);
                    }
                    if (o instanceof Integer) {
                        return o;
                    }
                    if (!(o instanceof Long)) break;
                    long temp = ((Number)o).longValue();
                    if (Integer.MAX_VALUE < temp || temp < Integer.MIN_VALUE) {
                        throw new NumberFormatException();
                    }
                    return new Integer(((Number)o).intValue());
                }
                case -5: {
                    if (o instanceof Long) {
                        return o;
                    }
                    if (o instanceof String) {
                        return new Long((String)o);
                    }
                    if (!(o instanceof Integer)) break;
                    return new Long(((Integer)o).longValue());
                }
                case 6: 
                case 7: 
                case 8: {
                    if (o instanceof Double) {
                        return o;
                    }
                    if (o instanceof String) {
                        return new Double((String)o);
                    }
                    if (!(o instanceof Number)) break;
                    return new Double(((Number)o).doubleValue());
                }
                case 2: 
                case 3: {
                    if (!(o instanceof BigDecimal)) break;
                    return o;
                }
                case -7: {
                    if (o instanceof Boolean) {
                        return o;
                    }
                    if (o instanceof String) {
                        return new Boolean((String)o);
                    }
                    if (o instanceof Integer || o instanceof Long) {
                        boolean bit = ((Number)o).longValue() != 0L;
                        return new Boolean(bit);
                    }
                    if (o instanceof Double) {
                        boolean bit = (Double)o != 0.0;
                        return new Boolean(bit);
                    }
                    if (!(o instanceof BigDecimal)) break;
                    boolean bit = ((BigDecimal)o).compareTo(BIGDECIMAL_0) != 0;
                    return new Boolean(bit);
                }
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    if (o instanceof String) {
                        return o;
                    }
                    if (!(o instanceof byte[])) break;
                    return ByteArray.toString((byte[])o);
                }
                case 92: {
                    if (o instanceof Timestamp) {
                        return new Time(((Timestamp)o).getTime());
                    }
                    if (!(o instanceof Date)) break;
                    return new Time(0L);
                }
                case 91: {
                    if (!(o instanceof Timestamp)) break;
                    return new Date(((Timestamp)o).getTime());
                }
                case -4: 
                case -3: 
                case -2: {
                    if (!(o instanceof byte[])) break;
                    return o;
                }
                case 1111: {
                    if (o instanceof String) break;
                    return o;
                }
            }
            return Column.convertString(o.toString(), type);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Trace.error(16, e.getMessage());
        }
    }

    private static Object convertString(String s, int type) throws SQLException {
        switch (type) {
            case -6: 
            case 5: {
                return Column.convertObject(s, type);
            }
            case 4: {
                return new Integer(s);
            }
            case -5: {
                return new Long(s);
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(s);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return s;
            }
            case 91: {
                return HsqlDateTime.dateValue(s);
            }
            case 92: {
                return HsqlDateTime.timeValue(s);
            }
            case 93: {
                return HsqlDateTime.timestampValue(s);
            }
            case 2: 
            case 3: {
                return new BigDecimal(s.trim());
            }
            case -7: {
                return new Boolean(s);
            }
            case -4: 
            case -3: 
            case -2: {
                return ByteArray.hexToByteArray(s);
            }
            case 1111: {
                return ByteArray.deserialize(ByteArray.hexToByteArray(s));
            }
        }
        throw Trace.error(20, type);
    }

    static String createSQLString(Object o, int type) throws SQLException {
        if (o == null) {
            return "NULL";
        }
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 6: 
            case 7: 
            case 8: {
                return Column.createSQLString(((Number)o).doubleValue());
            }
            case 91: 
            case 92: 
            case 93: {
                return StringConverter.toQuotedString(o.toString(), '\'', false);
            }
            case -4: 
            case -3: 
            case -2: {
                return StringConverter.toQuotedString(ByteArray.toString((byte[])o), '\'', false);
            }
            case 1111: {
                return StringConverter.toQuotedString(ByteArray.serializeToString(o), '\'', false);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.createSQLString((String)o);
            }
        }
        return o.toString();
    }

    static String createSQLString(double x) throws SQLException {
        if (x == Double.NEGATIVE_INFINITY) {
            return "-1E0/0";
        }
        if (x == Double.POSITIVE_INFINITY) {
            return "1E0/0";
        }
        if (Double.isNaN(x)) {
            return "0E0/0E0";
        }
        String s = Double.toString(x);
        if (s.indexOf(69) < 0) {
            s = s.concat("E0");
        }
        return s;
    }

    static String createSQLString(String s) {
        return StringConverter.toQuotedString(s, '\'', true);
    }

    static int getCombinedNumberType(int type1, int type2, int expType) {
        int typeWidth1 = Column.getNumTypeWidth(type1);
        int typeWidth2 = Column.getNumTypeWidth(type2);
        if (typeWidth1 == 16 || typeWidth2 == 16) {
            return 8;
        }
        if (expType != 14) {
            if (typeWidth1 + typeWidth2 <= 4) {
                return 4;
            }
            if (typeWidth1 + typeWidth2 <= 8) {
                return -5;
            }
            if (typeWidth1 + typeWidth2 <= 16) {
                return 2;
            }
        }
        return typeWidth1 > typeWidth2 ? type1 : type2;
    }

    private static int getNumTypeWidth(int type) {
        switch (type) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: 
            case 7: 
            case 8: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return 32;
    }

    static {
        numericTypes = new int[]{-6, 5, 4, -5, 2, 3, 6, 7, 8};
        otherTypes = new int[]{-7, -4, -3, -2, -1, 1, 12, 91, 92, 93, 1111};
        typesArray = new int[][]{numericTypes, otherTypes};
        BIGDECIMAL_0 = new BigDecimal("0");
        hTypes = new Hashtable(67, 1.0f);
        hTypes.put("INTEGER", new Integer(4));
        hTypes.put("INT", new Integer(4));
        hTypes.put("int", new Integer(4));
        hTypes.put("java.lang.Integer", new Integer(4));
        hTypes.put("IDENTITY", new Integer(4));
        hTypes.put("DOUBLE", new Integer(8));
        hTypes.put("double", new Integer(8));
        hTypes.put("java.lang.Double", new Integer(8));
        hTypes.put("FLOAT", new Integer(6));
        hTypes.put("REAL", new Integer(7));
        hTypes.put("VARCHAR", new Integer(12));
        hTypes.put("java.lang.String", new Integer(12));
        hTypes.put("CHAR", new Integer(1));
        hTypes.put("CHARACTER", new Integer(1));
        hTypes.put("LONGVARCHAR", new Integer(-1));
        hTypes.put("VARCHAR_IGNORECASE", new Integer(100));
        hTypes.put("DATE", new Integer(91));
        hTypes.put("java.sql.Date", new Integer(91));
        hTypes.put("TIME", new Integer(92));
        hTypes.put("java.sql.Time", new Integer(92));
        hTypes.put("TIMESTAMP", new Integer(93));
        hTypes.put("java.sql.Timestamp", new Integer(93));
        hTypes.put("DATETIME", new Integer(93));
        hTypes.put("DECIMAL", new Integer(3));
        hTypes.put("java.math.BigDecimal", new Integer(3));
        hTypes.put("NUMERIC", new Integer(2));
        hTypes.put("BIT", new Integer(-7));
        hTypes.put("boolean", new Integer(-7));
        hTypes.put("java.lang.Boolean", new Integer(-7));
        hTypes.put("TINYINT", new Integer(-6));
        hTypes.put("byte", new Integer(-6));
        hTypes.put("java.lang.Byte", new Integer(-6));
        hTypes.put("SMALLINT", new Integer(5));
        hTypes.put("short", new Integer(5));
        hTypes.put("java.lang.Short", new Integer(5));
        hTypes.put("BIGINT", new Integer(-5));
        hTypes.put("long", new Integer(-5));
        hTypes.put("java.lang.Long", new Integer(-5));
        hTypes.put("BINARY", new Integer(-2));
        hTypes.put("[B", new Integer(-2));
        hTypes.put("VARBINARY", new Integer(-3));
        hTypes.put("LONGVARBINARY", new Integer(-4));
        hTypes.put("OTHER", new Integer(1111));
        hTypes.put("OBJECT", new Integer(1111));
        hTypes.put("java.lang.Object", new Integer(1111));
        hTypes.put("NULL", new Integer(0));
        hTypes.put("void", new Integer(0));
        hTypes.put("java.lang.Void", new Integer(0));
        i18nCollator = Collator.getInstance();
        sql_compare_in_locale = false;
    }
}

