/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Constraint;
import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Index;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.User;
import com.kingdee.eas.cp.hsqldb.UserManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

class DatabaseInformation {
    private Database dDatabase;
    private UserManager aAccess;
    private Vector tTable;
    private static final Integer INTEGER_0 = new Integer(0);
    static final String META_SCHEM = "SCHEM";
    static final String META_CAT = "CAT";
    static final String META_COLUMN_SIZE = "COLUMN_SIZE";
    static final String META_BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String META_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String META_NUM_PREC_RADIX = "NUM_PREC_RADIX";
    static final String META_FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    static final String META_ORDINAL_POSITION = "ORDINAL_POSITION";
    static final String META_ASC_OR_DESC = "ASC_OR_DESC";
    private static Hashtable sysTableNames;
    private static final int SYSTEM_PROCEDURES = 1;
    private static final int SYSTEM_PROCEDURECOLUMNS = 2;
    private static final int SYSTEM_TABLES = 3;
    private static final int SYSTEM_SCHEMAS = 4;
    private static final int SYSTEM_CATALOGS = 5;
    private static final int SYSTEM_TABLETYPES = 6;
    private static final int SYSTEM_COLUMNS = 7;
    private static final int SYSTEM_COLUMNPRIVILEGES = 8;
    private static final int SYSTEM_TABLEPRIVILEGES = 9;
    private static final int SYSTEM_BESTROWIDENTIFIER = 10;
    private static final int SYSTEM_VERSIONCOLUMNS = 11;
    private static final int SYSTEM_PRIMARYKEYS = 12;
    private static final int SYSTEM_IMPORTEDKEYS = 13;
    private static final int SYSTEM_EXPORTEDKEYS = 14;
    private static final int SYSTEM_CROSSREFERENCE = 15;
    private static final int SYSTEM_TYPEINFO = 16;
    private static final int SYSTEM_INDEXINFO = 17;
    private static final int SYSTEM_UDTS = 18;
    private static final int SYSTEM_CONNECTIONINFO = 19;
    private static final int SYSTEM_USERS = 20;
    private static final String[] tableTypes;
    static final Short importedKeyNoActionShort;
    static final Short importedKeyCascadeShort;
    static final Short importedKeyNotDeferrableShort;

    DatabaseInformation(Database db, Vector tables, UserManager access) {
        this.dDatabase = db;
        this.tTable = tables;
        this.aAccess = access;
    }

    static boolean isSystemTable(String name) {
        return sysTableNames.get(name) != null;
    }

    Table getSystemTable(String tablename, Session session) throws SQLException {
        HsqlName name = new HsqlName(tablename, false);
        Integer tableId = (Integer)sysTableNames.get(tablename);
        if (tableId == null) {
            return null;
        }
        int tableIdValue = tableId;
        Table t = this.createTable(name);
        switch (tableIdValue) {
            case 1: {
                t.addColumn("PROCEDURE_CAT", 12);
                t.addColumn("PROCEDURE_SCHEM", 12);
                t.addColumn("PROCEDURE_NAME", 12);
                t.addColumn("NUM_INPUT_PARAMS", 4);
                t.addColumn("NUM_OUTPUT_PARAMS", 4);
                t.addColumn("NUM_RESULT_SETS", 4);
                t.addColumn("REMARKS", 12);
                t.addColumn("PROCEDURE_TYPE", 5);
                t.createPrimaryKey();
                return t;
            }
            case 2: {
                t.addColumn("PROCEDURE_CAT", 12);
                t.addColumn("PROCEDURE_SCHEM", 12);
                t.addColumn("PROCEDURE_NAME", 12);
                t.addColumn("COLUMN_NAME", 12);
                t.addColumn("COLUMN_TYPE", 5);
                t.addColumn("DATA_TYPE", 5);
                t.addColumn("TYPE_NAME", 12);
                t.addColumn("PRECISION", 4);
                t.addColumn("LENGTH", 4);
                t.addColumn("SCALE", 5);
                t.addColumn("RADIX", 5);
                t.addColumn("NULLABLE", 5);
                t.addColumn("REMARKS", 12);
                t.createPrimaryKey();
                return t;
            }
            case 3: {
                t.addColumn("TABLE_CAT", 12);
                t.addColumn("TABLE_SCHEM", 12);
                t.addColumn("TABLE_NAME", 12);
                t.addColumn("TABLE_TYPE", 12);
                t.addColumn("REMARKS", 12);
                t.addColumn("TYPE_CAT", 12);
                t.addColumn("TYPE_SCHEM", 12);
                t.addColumn("TYPE_NAME", 12);
                t.addColumn("SELF_REFERENCING_COL_NAME", 12);
                t.addColumn("REF_GENERATION", 12);
                t.createPrimaryKey();
                int tSize = this.tTable.size();
                block23: for (int i = 0; i < tSize; ++i) {
                    String dataSource;
                    Table table = (Table)this.tTable.elementAt(i);
                    Object[] o = t.getNewRow();
                    o[1] = "";
                    o[0] = "";
                    o[2] = table.getName().name;
                    switch (table.tableType) {
                        case 6: {
                            o[3] = "VIEW";
                            break;
                        }
                        case 1: 
                        case 4: {
                            if (this.dDatabase.findUserTable(table.getName().name, session) == null) continue block23;
                            o[3] = "GLOBAL TEMPORARY";
                            break;
                        }
                        default: {
                            o[3] = "TABLE";
                        }
                    }
                    if (table.isDataReadOnly()) {
                        o[4] = "ReadOnlyData=true";
                    }
                    if ((dataSource = table.getDataSource()) != null) {
                        o[4] = o[4] == null ? "" : o[4] + "; ";
                        o[4] = o[4] + "DataSource=\"" + dataSource + "\"";
                        if (table.isDescDataSource()) {
                            o[4] = o[4] + " DESC";
                        }
                    }
                    t.insert(o, null);
                }
                return t;
            }
            case 4: {
                t.addColumn("TABLE_SCHEM", 12);
                t.addColumn("TABLE_CATALOG", 12);
                t.createPrimaryKey();
                return t;
            }
            case 5: {
                t.addColumn("TABLE_CAT", 12);
                t.createPrimaryKey();
                return t;
            }
            case 6: {
                t.addColumn("TABLE_TYPE", 12);
                t.createPrimaryKey();
                for (int i = 0; i < tableTypes.length; ++i) {
                    Object[] o = t.getNewRow();
                    o[0] = tableTypes[i];
                    t.insert(o, null);
                }
                return t;
            }
            case 7: {
                t.addColumn("TABLE_CAT", 12);
                t.addColumn("TABLE_SCHEM", 12);
                t.addColumn("TABLE_NAME", 12);
                t.addColumn("COLUMN_NAME", 12);
                t.addColumn("DATA_TYPE", 5);
                t.addColumn("TYPE_NAME", 12);
                t.addColumn(META_COLUMN_SIZE, 4);
                t.addColumn(META_BUFFER_LENGTH, 4);
                t.addColumn(META_DECIMAL_DIGITS, 4);
                t.addColumn(META_NUM_PREC_RADIX, 4);
                t.addColumn("NULLABLE", 4);
                t.addColumn("REMARKS", 12);
                t.addColumn("COLUMN_DEF", 12);
                t.addColumn("SQL_DATA_TYPE", 4);
                t.addColumn("SQL_DATETIME_SUB", 4);
                t.addColumn("CHAR_OCTET_LENGTH", 4);
                t.addColumn(META_ORDINAL_POSITION, 4);
                t.addColumn("IS_NULLABLE", 12);
                t.addColumn("SCOPE_CATLOG", 12);
                t.addColumn("SCOPE_SCHEMA", 12);
                t.addColumn("SCOPE_TABLE", 12);
                t.addColumn("SOURCE_DATA_TYPE", 12);
                t.addColumn("SCOPE_CATLOG ", 5);
                t.createPrimaryKey();
                int tSize = this.tTable.size();
                for (int i = 0; i < tSize; ++i) {
                    Table table = (Table)this.tTable.elementAt(i);
                    int columnCount = table.getColumnCount();
                    if ((table.tableType == 1 || table.tableType == 4) && this.dDatabase.findUserTable(table.getName().name, session) == null) continue;
                    for (int j = 0; j < columnCount; ++j) {
                        int nullable;
                        Column column = table.getColumn(j);
                        Object[] o = t.getNewRow();
                        o[1] = "";
                        o[0] = "";
                        o[2] = table.getName().name;
                        o[3] = column.columnName.name;
                        o[4] = new Integer(column.getType());
                        o[5] = Column.getTypeString(column.getType());
                        o[6] = new Integer(column.getSize());
                        o[8] = new Integer(column.getScale());
                        o[9] = new Integer(10);
                        if (column.isNullable()) {
                            nullable = 1;
                            o[17] = new String("YES");
                        } else {
                            nullable = 0;
                            o[17] = new String("NO");
                        }
                        o[10] = new Integer(nullable);
                        if (table.getIdentityColumn() == j) {
                            o[11] = "IDENTITY";
                        }
                        o[12] = column.getDefaultString();
                        o[16] = new Integer(j + 1);
                        t.insert(o, null);
                    }
                }
                return t;
            }
            case 8: {
                t.addColumn("TABLE_CAT", 12);
                t.addColumn("TABLE_SCHEM", 12);
                t.addColumn("TABLE_NAME", 12);
                t.addColumn("COLUMN_NAME", 12);
                t.addColumn("GRANTOR", 12);
                t.addColumn("GRANTEE", 12);
                t.addColumn("PRIVILEGE", 12);
                t.addColumn("IS_GRANTABLE", 12);
                t.createPrimaryKey();
                return t;
            }
            case 9: {
                t.addColumn("TABLE_CAT", 12);
                t.addColumn("TABLE_SCHEM", 12);
                t.addColumn("TABLE_NAME", 12);
                t.addColumn("GRANTOR", 12);
                t.addColumn("GRANTEE", 12);
                t.addColumn("PRIVILEGE", 12);
                t.addColumn("IS_GRANTABLE", 12);
                t.createPrimaryKey();
                int tSize = this.tTable.size();
                for (int i = 0; i < tSize; ++i) {
                    Table table = (Table)this.tTable.elementAt(i);
                    if ((table.tableType == 1 || table.tableType == 4) && this.dDatabase.findUserTable(table.getName().name, session) == null) continue;
                    Object[] o = t.getNewRow();
                    o[1] = "";
                    o[0] = "";
                    o[2] = table.getName().name;
                    o[3] = "sa";
                    o[5] = "FULL";
                    t.insert(o, null);
                }
                return t;
            }
            case 10: 
            case 11: {
                t.addColumn("SCOPE", 5);
                t.addColumn("COLUMN_NAME", 12);
                t.addColumn("DATA_TYPE", 5);
                t.addColumn("TYPE_NAME", 12);
                t.addColumn(META_COLUMN_SIZE, 4);
                t.addColumn(META_BUFFER_LENGTH, 4);
                t.addColumn(META_DECIMAL_DIGITS, 5);
                t.addColumn("PSEUDO_COLUMN", 5);
                t.addColumn("TABLE_NAME", 12);
                t.createPrimaryKey();
                if (tableIdValue == 11) {
                    return t;
                }
                int tSize = this.tTable.size();
                for (int i = 0; i < tSize; ++i) {
                    Table table = (Table)this.tTable.elementAt(i);
                    if (table.tableType == 6 || (table.tableType == 1 || table.tableType == 4) && this.dDatabase.findUserTable(table.getName().name, session) == null) continue;
                    Index index = null;
                    int[] cols = null;
                    for (int j = 0; j < table.getIndexCount(); ++j) {
                        index = table.getIndex(j);
                        if (!index.isUnique()) continue;
                        cols = index.getColumns();
                        if (cols[0] != table.getColumnCount()) break;
                        cols = null;
                    }
                    if (cols == null) continue;
                    int len = cols.length;
                    for (int j = 0; j < len; ++j) {
                        Column column = table.getColumn(cols[j]);
                        Object[] o = t.getNewRow();
                        o[0] = new Short(0);
                        o[1] = column.columnName.name;
                        o[2] = new Short((short)column.getType());
                        o[3] = Column.getTypeString(column.getType());
                        o[4] = new Integer(column.getSize());
                        o[6] = new Integer(column.getScale());
                        o[7] = new Short(1);
                        o[8] = table.getName().name;
                        t.insert(o, null);
                    }
                }
                return t;
            }
            case 12: {
                t.addColumn("TABLE_CAT", 12);
                t.addColumn("TABLE_SCHEM", 12);
                t.addColumn("TABLE_NAME", 12);
                t.addColumn("COLUMN_NAME", 12);
                t.addColumn("KEY_SEQ", 5);
                t.addColumn("PK_NAME", 12);
                t.createPrimaryKey();
                int tSize = this.tTable.size();
                for (int i = 0; i < tSize; ++i) {
                    Index index;
                    int[] cols;
                    Table table = (Table)this.tTable.elementAt(i);
                    if (table.tableType == 6 || (table.tableType == 1 || table.tableType == 4) && this.dDatabase.findUserTable(table.getName().name, session) == null || (cols = (index = table.getIndex(0)).getColumns())[0] == table.getColumnCount()) continue;
                    int len = cols.length;
                    for (int j = 0; j < len; ++j) {
                        Object[] o = t.getNewRow();
                        o[1] = "";
                        o[0] = "";
                        o[2] = table.getName().name;
                        o[3] = table.getColumn((int)cols[j]).columnName.name;
                        o[4] = new Integer(j + 1);
                        o[5] = index.getName().name;
                        t.insert(o, null);
                    }
                }
                return t;
            }
            case 13: 
            case 14: 
            case 15: {
                return this.getCrossReference(name, session);
            }
            case 16: {
                t.addColumn("TYPE_NAME", 12);
                t.addColumn("DATA_TYPE", 5);
                t.addColumn("PRECISION", 4);
                t.addColumn("LITERAL_PREFIX", 12);
                t.addColumn("LITERAL_SUFFIX", 12);
                t.addColumn("CREATE_PARAMS", 12);
                t.addColumn("NULLABLE", 5);
                t.addColumn("CASE_SENSITIVE", -7);
                t.addColumn("SEARCHABLE", 5);
                t.addColumn("UNSIGNED_ATTRIBUTE", -7);
                t.addColumn(META_FIXED_PREC_SCALE, -7);
                t.addColumn("AUTO_INCREMENT", -7);
                t.addColumn("LOCAL_TYPE_NAME", 12);
                t.addColumn("MINIMUM_SCALE", 5);
                t.addColumn("MAXIMUM_SCALE", 5);
                t.addColumn("SQL_DATE_TYPE", 4);
                t.addColumn("SQL_DATETIME_SUB", 4);
                t.addColumn(META_NUM_PREC_RADIX, 4);
                t.createPrimaryKey();
                for (int h = 0; h < Column.typesArray.length; ++h) {
                    for (int i = 0; i < Column.typesArray[h].length; ++i) {
                        Object[] o = t.getNewRow();
                        int type = Column.typesArray[h][i];
                        o[0] = Column.getTypeString(type);
                        o[1] = new Integer(type);
                        o[2] = INTEGER_0;
                        o[6] = new Integer(1);
                        o[7] = new Boolean(true);
                        o[8] = new Integer(3);
                        o[9] = new Boolean(false);
                        o[10] = new Boolean(type == 2 || type == 3);
                        o[11] = new Boolean(type == 4);
                        o[12] = o[0];
                        o[13] = INTEGER_0;
                        o[14] = INTEGER_0;
                        o[17] = new Integer(10);
                        t.insert(o, null);
                    }
                }
                return t;
            }
            case 17: {
                t.addColumn("TABLE_CAT", 12);
                t.addColumn("TABLE_SCHEM", 12);
                t.addColumn("TABLE_NAME", 12);
                t.addColumn("NON_UNIQUE", -7);
                t.addColumn("INDEX_QUALIFIER", 12);
                t.addColumn("INDEX_NAME", 12);
                t.addColumn("TYPE", 5);
                t.addColumn(META_ORDINAL_POSITION, 5);
                t.addColumn("COLUMN_NAME", 12);
                t.addColumn(META_ASC_OR_DESC, 12);
                t.addColumn("CARDINALITY", 4);
                t.addColumn("PAGES", 4);
                t.addColumn("FILTER_CONDITION", 12);
                t.createPrimaryKey();
                int tSize = this.tTable.size();
                for (int i = 0; i < tSize; ++i) {
                    Table table = (Table)this.tTable.elementAt(i);
                    for (int j = 0; j < table.getIndexCount(); ++j) {
                        Index index = table.getIndex(j);
                        int[] cols = index.getColumns();
                        int len = index.getVisibleColumns();
                        if (len == 0) continue;
                        for (int k = 0; k < len; ++k) {
                            Object[] o = t.getNewRow();
                            o[1] = "";
                            o[0] = "";
                            o[2] = table.getName().name;
                            o[3] = new Boolean(!index.isUnique());
                            o[5] = index.getName().name;
                            o[6] = new Integer(3);
                            o[7] = new Integer(k + 1);
                            o[8] = table.getColumn((int)cols[k]).columnName.name;
                            o[9] = "A";
                            t.insert(o, null);
                        }
                    }
                }
                return t;
            }
            case 18: {
                t.addColumn("TYPE_CAT", 12);
                t.addColumn("TYPE_SCHEM", 12);
                t.addColumn("TYPE_NAME", 12);
                t.addColumn("CLASS_NAME", -7);
                t.addColumn("DATA_TYPE", 12);
                t.addColumn("REMARKS", 12);
                t.addColumn("BASE_TYPE ", 5);
                t.createPrimaryKey();
                return t;
            }
            case 19: {
                t.addColumn("KEY", 12);
                t.addColumn("VALUE", 12);
                t.createPrimaryKey();
                Object[] o = t.getNewRow();
                o[0] = "USER";
                o[1] = session.getUsername();
                t.insert(o, null);
                o = t.getNewRow();
                o[0] = "READONLY";
                o[1] = session.isReadOnly() ? "TRUE" : "FALSE";
                t.insert(o, null);
                o = t.getNewRow();
                o[0] = "MAXROWS";
                o[1] = String.valueOf(session.getMaxRows());
                t.insert(o, null);
                o = t.getNewRow();
                o[0] = "DATABASE";
                o[1] = session.getDatabase().getName();
                t.insert(o, null);
                o = t.getNewRow();
                o[0] = "IDENTITY";
                o[1] = String.valueOf(session.getLastIdentity());
                t.insert(o, null);
                return t;
            }
            case 20: {
                t.addColumn("USER", 12);
                t.addColumn("ADMIN", -7);
                t.createPrimaryKey();
                Vector v = this.aAccess.getUsers();
                int vSize = v.size();
                for (int i = 0; i < vSize; ++i) {
                    String user;
                    User u = (User)v.elementAt(i);
                    if (u == null || (user = u.getName()).equals("PUBLIC")) continue;
                    Object[] o = t.getNewRow();
                    o[0] = user;
                    o[1] = new Boolean(u.isAdmin());
                    t.insert(o, null);
                }
                return t;
            }
        }
        return null;
    }

    Table getCrossReference(HsqlName name, Session session) throws SQLException {
        Table t = this.createTable(name);
        t.addColumn("PKTABLE_CAT", 12);
        t.addColumn("PKTABLE_SCHEM", 12);
        t.addColumn("PKTABLE_NAME", 12);
        t.addColumn("PKCOLUMN_NAME", 12);
        t.addColumn("FKTABLE_CAT", 12);
        t.addColumn("FKTABLE_SCHEM", 12);
        t.addColumn("FKTABLE_NAME", 12);
        t.addColumn("FKCOLUMN_NAME", 12);
        t.addColumn("KEY_SEQ", 5);
        t.addColumn("UPDATE_RULE", 5);
        t.addColumn("DELETE_RULE", 5);
        t.addColumn("FK_NAME", 12);
        t.addColumn("PK_NAME", 12);
        t.addColumn("DEFERRABILITY", 5);
        t.createPrimaryKey();
        int tSize = this.tTable.size();
        for (int i = 0; i < tSize; ++i) {
            Table table = (Table)this.tTable.elementAt(i);
            Vector constVect = table.getConstraints();
            for (int j = 0; j < constVect.size(); ++j) {
                Constraint constraint = (Constraint)constVect.elementAt(j);
                if (constraint.getType() != 0) continue;
                String mainTableName = constraint.getMain().tableName.name;
                String refTableName = constraint.getRef().tableName.name;
                if (this.dDatabase.findUserTable(mainTableName) == null || this.dDatabase.findUserTable(refTableName) == null) continue;
                int[] pkcols = constraint.getMainColumns();
                int[] fkcols = constraint.getRefColumns();
                int len = pkcols.length;
                for (int k = 0; k < len; ++k) {
                    Object[] o = t.getNewRow();
                    o[1] = "";
                    o[0] = "";
                    o[2] = mainTableName;
                    o[3] = constraint.getMain().getColumn((int)pkcols[k]).columnName.name;
                    o[5] = "";
                    o[4] = "";
                    o[6] = refTableName;
                    o[7] = constraint.getRef().getColumn((int)fkcols[k]).columnName.name;
                    o[8] = new Short((short)(k + 1));
                    o[9] = importedKeyNoActionShort;
                    o[10] = constraint.isCascade() ? importedKeyCascadeShort : importedKeyNoActionShort;
                    o[11] = constraint.getFkName();
                    o[12] = constraint.getPkName();
                    o[13] = importedKeyNotDeferrableShort;
                    t.insert(o, null);
                }
            }
        }
        return t;
    }

    private Table createTable(HsqlName name) throws SQLException {
        return new Table(this.dDatabase, name, 0, null);
    }

    static {
        tableTypes = new String[]{"TABLE", "VIEW", "GLOBAL TEMPORARY"};
        sysTableNames = new Hashtable(37);
        String[] sysNames = new String[]{"SYSTEM_PROCEDURES", "SYSTEM_PROCEDURECOLUMNS", "SYSTEM_TABLES", "SYSTEM_SCHEMAS", "SYSTEM_CATALOGS", "SYSTEM_TABLETYPES", "SYSTEM_COLUMNS", "SYSTEM_COLUMNPRIVILEGES", "SYSTEM_TABLEPRIVILEGES", "SYSTEM_BESTROWIDENTIFIER", "SYSTEM_VERSIONCOLUMNS", "SYSTEM_PRIMARYKEYS", "SYSTEM_IMPORTEDKEYS", "SYSTEM_EXPORTEDKEYS", "SYSTEM_CROSSREFERENCE", "SYSTEM_TYPEINFO", "SYSTEM_INDEXINFO", "SYSTEM_UDTS", "SYSTEM_CONNECTIONINFO", "SYSTEM_USERS"};
        for (int i = 0; i < sysNames.length; ++i) {
            sysTableNames.put(sysNames[i], new Integer(i + 1));
        }
        importedKeyNoActionShort = new Short(3);
        importedKeyCascadeShort = new Short(0);
        importedKeyNotDeferrableShort = new Short(7);
    }
}

