/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

abstract class DatabaseRowInput
extends DataInputStream {
    static final int NO_POS = -1;
    protected int pos = -1;
    protected int nextPos = -1;
    protected int size;
    protected boolean makeSystemId = false;

    public DatabaseRowInput(InputStream in) {
        super(in);
    }

    public DatabaseRowInput(byte[] bin, int pos) throws IOException {
        this(new ByteArrayInputStream(bin));
        this.pos = pos;
        this.size = bin.length;
    }

    public int getPos() throws IOException {
        if (this.pos == -1) {
            throw new IOException("No position specified");
        }
        return this.pos;
    }

    public int getNextPos() throws IOException {
        if (this.nextPos == -1) {
            throw new IOException("No next position specified");
        }
        return this.nextPos;
    }

    public int getSize() {
        return this.size;
    }

    public abstract int readIntData() throws IOException;

    public abstract int readType() throws IOException;

    public abstract String readString() throws IOException;

    protected abstract boolean checkNull() throws IOException;

    protected abstract String readChar(int var1) throws IOException, SQLException;

    protected abstract Integer readSmallint() throws IOException, SQLException;

    protected abstract Integer readInteger() throws IOException, SQLException;

    protected abstract Long readBigint() throws IOException, SQLException;

    protected abstract Double readReal(int var1) throws IOException, SQLException;

    protected abstract BigDecimal readDecimal() throws IOException, SQLException;

    protected abstract Boolean readBit() throws IOException, SQLException;

    protected abstract Time readTime() throws IOException, SQLException;

    protected abstract Date readDate() throws IOException, SQLException;

    protected abstract Timestamp readTimestamp() throws IOException, SQLException;

    protected abstract Object readOther() throws IOException, SQLException;

    protected abstract byte[] readBinary(int var1) throws IOException, SQLException;

    public Object[] readData(int[] colTypes) throws IOException, SQLException {
        int l = colTypes.length;
        Object[] data = new Object[l];
        if (this.makeSystemId) {
            --l;
        }
        for (int i = 0; i < l; ++i) {
            if (this.checkNull()) continue;
            Object o = null;
            int type = colTypes[i];
            switch (type) {
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    o = this.readChar(type);
                    break;
                }
                case -6: 
                case 5: {
                    o = this.readSmallint();
                    break;
                }
                case 4: {
                    o = this.readInteger();
                    break;
                }
                case -5: {
                    o = this.readBigint();
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    o = this.readReal(type);
                    break;
                }
                case 2: 
                case 3: {
                    o = this.readDecimal();
                    break;
                }
                case 91: {
                    o = this.readDate();
                    break;
                }
                case 92: {
                    o = this.readTime();
                    break;
                }
                case 93: {
                    o = this.readTimestamp();
                    break;
                }
                case -7: {
                    o = this.readBit();
                    break;
                }
                case 1111: {
                    o = this.readOther();
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    o = this.readBinary(type);
                    break;
                }
                default: {
                    throw Trace.error(20, type);
                }
            }
            data[i] = o;
        }
        if (this.makeSystemId) {
            data[l] = new Integer(this.getPos());
        }
        return data;
    }
}

