/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Constraint;
import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Index;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.TriggerDef;
import com.kingdee.eas.cp.hsqldb.User;
import com.kingdee.eas.cp.hsqldb.UserManager;
import com.kingdee.eas.cp.hsqldb.View;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DatabaseScript {
    DatabaseScript() {
    }

    static Result getScript(Database dDatabase, boolean bDrop, boolean bInsert, boolean bCached, Session session) throws SQLException {
        int i;
        StringBuffer a;
        Table t;
        int i2;
        Vector tTable = dDatabase.getTables();
        Vector forwardFK = new Vector();
        Vector forwardFKSource = new Vector();
        session.checkAdmin();
        Result r = new Result(1);
        r.colType[0] = 12;
        r.sTable[0] = "SYSTEM_SCRIPT";
        r.sLabel[0] = "COMMAND";
        r.sName[0] = "COMMAND";
        int tSize = tTable.size();
        for (i2 = 0; i2 < tSize; ++i2) {
            String dataSource;
            t = (Table)tTable.elementAt(i2);
            if (t.isTemp() || t.isView()) continue;
            if (bDrop) {
                DatabaseScript.addRow(r, "DROP TABLE " + t.getName().statementName);
            }
            a = new StringBuffer(128);
            DatabaseScript.getTableDDL(dDatabase, t, i2, forwardFK, forwardFKSource, a);
            DatabaseScript.addRow(r, a.toString());
            for (int j = 1; j < t.getIndexCount(); ++j) {
                Index index = t.getIndex(j);
                if (HsqlName.isReservedName(index.getName().name)) continue;
                a = new StringBuffer(64);
                a.append("CREATE ");
                if (index.isUnique()) {
                    a.append("UNIQUE ");
                }
                a.append("INDEX ");
                a.append(index.getName().statementName);
                a.append(" ON ");
                a.append(t.getName().statementName);
                int[] col = index.getColumns();
                int len = index.getVisibleColumns();
                DatabaseScript.getColumnList(t, col, len, a);
                DatabaseScript.addRow(r, a.toString());
            }
            if (t.isText() && t.isDataReadOnly()) {
                a = new StringBuffer("SET TABLE ");
                a.append(t.getName().statementName);
                a.append(" READONLY TRUE");
                DatabaseScript.addRow(r, a.toString());
            }
            if ((dataSource = DatabaseScript.getDataSource(t)) != null) {
                DatabaseScript.addRow(r, dataSource);
            }
            int numTrigs = TriggerDef.numTrigs();
            for (int tv = 0; tv < numTrigs; ++tv) {
                Vector trigVec = t.vTrigs[tv];
                int trCount = trigVec.size();
                for (int k = 0; k < trCount; ++k) {
                    a = ((TriggerDef)trigVec.elementAt(k)).toBuf();
                    DatabaseScript.addRow(r, a.toString());
                }
            }
        }
        tSize = forwardFK.size();
        for (i2 = 0; i2 < tSize; ++i2) {
            Constraint c = (Constraint)forwardFK.elementAt(i2);
            a = new StringBuffer(128);
            a.append("ALTER TABLE ");
            a.append(c.getRef().getName().statementName);
            a.append(" ADD ");
            DatabaseScript.getFKStatement(c, a);
            DatabaseScript.addRow(r, a.toString());
        }
        tSize = tTable.size();
        for (i2 = 0; i2 < tSize; ++i2) {
            t = (Table)tTable.elementAt(i2);
            if (!bCached || !t.isCached()) continue;
            DatabaseScript.addRow(r, DatabaseScript.getIndexRootsDDL((Table)tTable.elementAt(i2)));
        }
        Vector uv = dDatabase.getUserManager().getUsers();
        int vSize = uv.size();
        for (int i3 = 0; i3 < vSize; ++i3) {
            Hashtable rights;
            User u = (User)uv.elementAt(i3);
            if (u == null) continue;
            String name = u.getName();
            if (!name.equals("PUBLIC")) {
                a = new StringBuffer(128);
                a.append("CREATE USER ");
                a.append(name);
                a.append(" PASSWORD ");
                a.append('\"');
                a.append(u.getPassword());
                a.append('\"');
                if (u.isAdmin()) {
                    a.append(" ADMIN");
                }
                DatabaseScript.addRow(r, a.toString());
            }
            if ((rights = u.getRights()) == null) continue;
            Enumeration e = rights.keys();
            while (e.hasMoreElements()) {
                String object = (String)e.nextElement();
                int right = (Integer)rights.get(object);
                if (right == 0) continue;
                a = new StringBuffer(64);
                a.append("GRANT ");
                a.append(UserManager.getRight(right));
                a.append(" ON ");
                a.append(object);
                a.append(" TO ");
                a.append(u.getName());
                DatabaseScript.addRow(r, a.toString());
            }
        }
        if (dDatabase.isIgnoreCase()) {
            DatabaseScript.addRow(r, "SET IGNORECASE TRUE");
        }
        Hashtable h = dDatabase.getAlias();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String alias = (String)e.nextElement();
            String java = (String)h.get(alias);
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("CREATE ALIAS ");
            buffer.append(alias);
            buffer.append(" FOR \"");
            buffer.append(java);
            buffer.append('\"');
            DatabaseScript.addRow(r, buffer.toString());
        }
        int tSize2 = tTable.size();
        for (i = 0; i < tSize2; ++i) {
            Table t2 = (Table)tTable.elementAt(i);
            if (!t2.isView()) continue;
            View v = (View)tTable.elementAt(i);
            if (bDrop) {
                DatabaseScript.addRow(r, "DROP VIEW " + v.getName().name);
            }
            a = new StringBuffer(128);
            a.append("CREATE ");
            a.append("VIEW ");
            a.append(v.getName().statementName);
            a.append(" AS ");
            a.append(v.getStatement());
            DatabaseScript.addRow(r, a.toString());
        }
        tSize2 = tTable.size();
        for (i = 0; i < tSize2; ++i) {
            Table t3 = (Table)tTable.elementAt(i);
            if (!bInsert || t3.isTemp() || t3.isView() || t3.isCached && !bCached || t3.isText() && t3.isDataReadOnly()) continue;
            Index primary = t3.getPrimaryIndex();
            Node x = primary.first();
            boolean integrity = true;
            if (x != null) {
                integrity = false;
            }
            while (x != null) {
                DatabaseScript.addRow(r, t3.getInsertStatement(x.getData()));
                x = primary.next(x);
            }
            if (!t3.isDataReadOnly()) continue;
            a = new StringBuffer("SET TABLE ");
            a.append(t3.getName().statementName);
            a.append(" READONLY TRUE");
            DatabaseScript.addRow(r, a.toString());
        }
        return r;
    }

    static String getIndexRootsDDL(Table t) throws SQLException {
        StringBuffer a = new StringBuffer(128);
        a.append("SET TABLE ");
        a.append(t.getName().statementName);
        a.append(" INDEX '");
        a.append(t.getIndexRoots());
        a.append('\'');
        return a.toString();
    }

    static void getTableDDL(Database dDatabase, Table t, int i, Vector forwardFK, Vector forwardFKSource, StringBuffer a) throws SQLException {
        a.append("CREATE ");
        if (t.isText()) {
            a.append("TEXT ");
        } else if (t.isCached()) {
            a.append("CACHED ");
        }
        a.append("TABLE ");
        a.append(t.getName().statementName);
        a.append('(');
        int columns = t.getColumnCount();
        Index pki = t.getIndex(0);
        int[] pk = pki.getColumns();
        for (int j = 0; j < columns; ++j) {
            Column column = t.getColumn(j);
            String colname = column.columnName.statementName;
            a.append(colname);
            a.append(' ');
            String sType = Column.getTypeString(column.getType());
            a.append(sType);
            if (column.getSize() > 0) {
                a.append('(');
                a.append(column.getSize());
                if (column.getScale() > 0) {
                    a.append(',');
                    a.append(column.getScale());
                }
                a.append(')');
            }
            if (column.getDefaultString() != null) {
                a.append(" DEFAULT ");
                a.append(Column.createSQLString(column.getDefaultString()));
            }
            if (!column.isNullable()) {
                a.append(" NOT NULL");
            }
            if (j == t.getIdentityColumn()) {
                a.append(" IDENTITY");
            }
            if (pk.length == 1 && j == pk[0]) {
                a.append(" PRIMARY KEY");
            }
            if (j >= columns - 1) continue;
            a.append(',');
        }
        if (pk.length > 1) {
            a.append(",CONSTRAINT ");
            a.append(pki.getName().statementName);
            a.append(" PRIMARY KEY");
            DatabaseScript.getColumnList(t, pk, pk.length, a);
        }
        Vector v = t.getConstraints();
        int vSize = v.size();
        for (int j = 0; j < vSize; ++j) {
            Constraint c = (Constraint)v.elementAt(j);
            if (c.getType() == 2) {
                a.append(",CONSTRAINT ");
                a.append(c.getName().statementName);
                a.append(" UNIQUE");
                int[] col = c.getMainColumns();
                DatabaseScript.getColumnList(c.getMain(), col, col.length, a);
                continue;
            }
            if (c.getType() != 0) continue;
            Table maintable = c.getMain();
            int maintableindex = dDatabase.getTableIndex(maintable);
            if (maintableindex > i) {
                if (i >= forwardFKSource.size()) {
                    forwardFKSource.setSize(i + 1);
                }
                forwardFKSource.setElementAt(c, i);
                forwardFK.addElement(c);
                continue;
            }
            a.append(',');
            DatabaseScript.getFKStatement(c, a);
        }
        a.append(')');
    }

    static String getDataSource(Table t) throws SQLException {
        String dataSource = t.getDataSource();
        if (dataSource == null) {
            return null;
        }
        boolean isDesc = t.isDescDataSource();
        StringBuffer a = new StringBuffer(128);
        a.append("SET TABLE ");
        a.append(t.getName().statementName);
        a.append(" SOURCE \"");
        a.append(dataSource);
        a.append('\"');
        if (isDesc) {
            a.append(" DESC");
        }
        return a.toString();
    }

    private static void getColumnList(Table t, int[] col, int len, StringBuffer a) {
        a.append('(');
        for (int i = 0; i < len; ++i) {
            a.append(t.getColumn((int)col[i]).columnName.statementName);
            if (i >= len - 1) continue;
            a.append(',');
        }
        a.append(')');
    }

    private static void getFKStatement(Constraint c, StringBuffer a) {
        a.append("CONSTRAINT ");
        a.append(c.getName().statementName);
        a.append(" FOREIGN KEY");
        int[] col = c.getRefColumns();
        DatabaseScript.getColumnList(c.getRef(), col, col.length, a);
        a.append(" REFERENCES ");
        a.append(c.getMain().getName().statementName);
        col = c.getMainColumns();
        DatabaseScript.getColumnList(c.getMain(), col, col.length, a);
        if (c.isCascade()) {
            a.append(" ON DELETE CASCADE");
        }
    }

    private static void addRow(Result r, String sql) {
        Object[] s = new String[]{sql};
        r.add(s);
    }
}

