/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Expression;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.TableFilter;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Hashtable;

class Function {
    private Session cSession;
    private String sFunction;
    private Method mMethod;
    private int iReturnType;
    private int iArgCount;
    private int[] iArgType;
    private boolean[] bArgNullable;
    private Object[] oArg;
    private Expression[] eArg;
    private boolean bConnection;
    private boolean isIdentityFunction;
    private static Hashtable methodCache = new Hashtable();

    Function(String function, Session session) throws SQLException {
        int i;
        this.cSession = session;
        this.sFunction = function;
        if (function.equals("org.hsqldb.Library.identity")) {
            this.isIdentityFunction = true;
        }
        Trace.check((i = function.lastIndexOf(46)) != -1, 11, function);
        String classname = function.substring(0, i);
        session.check("CLASS \"" + classname + "\"", 15);
        this.mMethod = (Method)methodCache.get(function);
        if (this.mMethod == null) {
            String methodname = function.substring(i + 1);
            Class<?> classinstance = null;
            try {
                classinstance = Class.forName(classname);
            }
            catch (Exception e) {
                throw Trace.error(42, classname + " " + e);
            }
            Method[] method = classinstance.getMethods();
            for (i = 0; i < method.length; ++i) {
                Method m = method[i];
                if (!m.getName().equals(methodname) || !Modifier.isStatic(m.getModifiers())) continue;
                this.mMethod = m;
                break;
            }
            Trace.check(this.mMethod != null, 13, methodname);
            methodCache.put(function, this.mMethod);
        }
        Class<?> returnclass = this.mMethod.getReturnType();
        this.iReturnType = Column.getTypeNr(returnclass.getName());
        Class<?>[] arg = this.mMethod.getParameterTypes();
        this.iArgCount = arg.length;
        this.iArgType = new int[this.iArgCount];
        this.bArgNullable = new boolean[this.iArgCount];
        for (i = 0; i < arg.length; ++i) {
            Class<?> a = arg[i];
            String type = a.getName();
            if (i == 0 && type.equals("java.sql.Connection")) {
                this.bConnection = true;
                continue;
            }
            this.iArgType[i] = Column.getTypeNr(type);
            this.bArgNullable[i] = !a.isPrimitive();
        }
        this.eArg = new Expression[this.iArgCount];
        this.oArg = new Object[this.iArgCount];
    }

    Object getValue() throws SQLException {
        int i = 0;
        if (this.isIdentityFunction) {
            return new Integer(this.cSession.getLastIdentity());
        }
        if (this.bConnection) {
            this.oArg[i] = this.cSession.getInternalConnection();
            ++i;
        }
        while (i < this.iArgCount) {
            Expression e = this.eArg[i];
            Object o = null;
            if (e != null) {
                o = e.getValue(this.iArgType[i]);
            }
            if (o == null && !this.bArgNullable[i]) {
                return null;
            }
            this.oArg[i] = o;
            ++i;
        }
        try {
            return this.mMethod.invoke(null, this.oArg);
        }
        catch (Exception e) {
            String s = this.sFunction + ": " + e.toString();
            throw Trace.getError(20, s);
        }
    }

    int getArgCount() {
        return this.iArgCount - (this.bConnection ? 1 : 0);
    }

    void resolve(TableFilter f) throws SQLException {
        for (int i = 0; i < this.iArgCount; ++i) {
            if (this.eArg[i] == null) continue;
            this.eArg[i].resolve(f);
        }
    }

    void checkResolved() throws SQLException {
        for (int i = 0; i < this.iArgCount; ++i) {
            if (this.eArg[i] == null) continue;
            this.eArg[i].checkResolved();
        }
    }

    int getArgType(int i) {
        return this.iArgType[i];
    }

    int getReturnType() {
        return this.iReturnType;
    }

    void setArgument(int i, Expression e) {
        if (this.bConnection) {
            ++i;
        }
        this.eArg[i] = e;
    }
}

