/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.HsqlProperties;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;

class HsqlDatabaseProperties
extends HsqlProperties {
    private FileInputStream propsFileStream;

    private HsqlDatabaseProperties() {
    }

    public HsqlDatabaseProperties(String name) {
        super(name);
        this.setProperty("sql.month", true);
        this.setProperty("sql.enforce_size", false);
        this.setProperty("sql.compare_in_locale", false);
        this.setProperty("sql.strict_fk", false);
        this.setProperty("sql.strong_fk", true);
        this.setProperty("hsqldb.compatible_version", "1.6.0");
        this.setProperty("hsqldb.original_version", "1.7.1");
        this.setProperty("hsqldb.cache_version", "1.6.0");
        this.setProperty("hsqldb.cache_scale", "14");
        this.setProperty("hsqldb.log_size", "200");
        this.setProperty("readonly", false);
        this.setProperty("modified", "no");
    }

    public void close() throws SQLException {
        try {
            if (this.propsFileStream != null) {
                if (Trace.TRACE) {
                    Trace.trace();
                }
                this.propsFileStream.close();
                this.propsFileStream = null;
            }
        }
        catch (Exception e) {
            throw Trace.error(29, this.fileName + ".properties " + e);
        }
    }

    @Override
    public void load() throws SQLException {
        this.close();
        if (Trace.TRACE) {
            Trace.trace();
        }
        try {
            File f = new File(this.fileName + ".properties");
            this.propsFileStream = new FileInputStream(f);
            this.stringProps.load(this.propsFileStream);
        }
        catch (Exception e) {
            throw Trace.error(29, this.fileName + ".properties " + e);
        }
    }

    @Override
    public void save() throws SQLException {
        this.close();
        if (Trace.TRACE) {
            Trace.trace();
        }
        try {
            super.save();
            this.load();
        }
        catch (Exception e) {
            throw Trace.error(29, this.fileName + ".properties " + e);
        }
    }

    protected boolean isFileOpen() throws SQLException {
        this.close();
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!new File(this.fileName + ".properties").delete()) {
            return true;
        }
        this.save();
        return false;
    }
}

