/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.sql.SQLException;

class Index {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    static final int POINTER_INDEX = 2;
    private HsqlName indexName;
    private Table table;
    private int iFields;
    private int[] iColumn;
    private int[] iType;
    private boolean bUnique;
    private int visibleColumns;
    private Node root;
    private int iColumn_0;
    private int iType_0;
    private static int iNeedCleanUp;
    private boolean cleanUp;

    Index(HsqlName name, Table table, int[] column, int[] type, boolean unique, int visibleColumns) {
        this.indexName = name;
        this.table = table;
        this.cleanUp = table.isCached();
        this.iFields = column.length;
        this.iColumn = column;
        this.iType = type;
        this.bUnique = unique;
        this.iColumn_0 = this.iColumn[0];
        this.iType_0 = this.iType[0];
        this.visibleColumns = visibleColumns;
    }

    Node getRoot() {
        return this.root;
    }

    void setRoot(Node r) {
        this.root = r;
    }

    HsqlName getName() {
        return this.indexName;
    }

    void setName(String name, boolean isquoted) {
        this.indexName.rename(name, isquoted);
    }

    int getVisibleColumns() {
        return this.visibleColumns;
    }

    boolean isUnique() {
        return this.bUnique;
    }

    int[] getColumns() {
        return this.iColumn;
    }

    boolean isEquivalent(Index index) {
        if (this.bUnique == index.bUnique && this.iColumn.length == index.iColumn.length) {
            for (int j = 0; j < this.iColumn.length; ++j) {
                if (this.iColumn[j] == index.iColumn[j]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void insert(Node i) throws SQLException {
        Node n;
        Object[] data = i.getData();
        Node x = n = this.root;
        boolean way = true;
        int compare = -1;
        while (true) {
            if (n == null) {
                if (x == null) {
                    this.root = i;
                    return;
                }
                this.set(x, way, i);
                break;
            }
            Object[] nData = n.getData();
            if (data == nData) {
                this.set(x, way, i);
                break;
            }
            compare = this.compareRow(data, nData);
            if (compare == 0) {
                throw Trace.error(9, this.indexName.name);
            }
            way = compare < 0;
            x = n;
            n = this.child(x, way);
        }
        this.balance(x, way);
    }

    Node insertUncached(Node i) throws SQLException {
        Node n;
        Object[] data = i.getData();
        Node x = n = this.root;
        boolean way = true;
        int compare = -1;
        while (true) {
            if (n == null) {
                if (x == null) {
                    this.root = i;
                    return i;
                }
                break;
            }
            x = n;
            compare = this.compareRow(data, x.getData());
            if (compare == 0) {
                return n;
            }
            way = compare < 0;
            n = way ? x.getLeft() : x.getRightPointer();
        }
        this.set(x, way, i);
        this.balance(x, way);
        return i;
    }

    private void balance(Node x, boolean way) throws SQLException {
        while (true) {
            int sign = way ? 1 : -1;
            switch (x.getBalance() * sign) {
                case 1: {
                    x.setBalance(0);
                    return;
                }
                case 0: {
                    x.setBalance(-sign);
                    break;
                }
                case -1: {
                    Node l = this.child(x, way);
                    if (l.getBalance() == -sign) {
                        this.replace(x, l);
                        this.set(x, way, this.child(l, !way));
                        this.set(l, !way, x);
                        x.setBalance(0);
                        l.setBalance(0);
                    } else {
                        Node r = this.child(l, !way);
                        this.replace(x, r);
                        this.set(l, !way, this.child(r, way));
                        this.set(r, way, l);
                        this.set(x, way, this.child(r, !way));
                        this.set(r, !way, x);
                        int rb = r.getBalance();
                        x.setBalance(rb == -sign ? sign : 0);
                        l.setBalance(rb == sign ? -sign : 0);
                        r.setBalance(0);
                    }
                    return;
                }
            }
            if (x.equals(this.root)) {
                return;
            }
            way = x.from();
            x = x.getParent();
        }
    }

    void delete(Object[] row, boolean datatoo) throws SQLException {
        Node n;
        Node x = this.search(row);
        if (x == null) {
            return;
        }
        if (x.getLeft() == null) {
            n = x.getRight();
        } else if (x.getRight() == null) {
            n = x.getLeft();
        } else {
            Node d = x;
            x = x.getLeft();
            while (x.getRight() != null) {
                x = x.getRight();
            }
            n = x.getLeft();
            int b = x.getBalance();
            x.setBalance(d.getBalance());
            d.setBalance(b);
            Node xp = x.getParent();
            Node dp = d.getParent();
            if (d == this.root) {
                this.root = x;
            }
            x.setParent(dp);
            if (dp != null) {
                if (dp.getRight().equals(d)) {
                    dp.setRight(x);
                } else {
                    dp.setLeft(x);
                }
            }
            if (xp == d) {
                d.setParent(x);
                if (d.getLeft().equals(x)) {
                    x.setLeft(d);
                    x.setRight(d.getRight());
                } else {
                    x.setRight(d);
                    x.setLeft(d.getLeft());
                }
            } else {
                d.setParent(xp);
                xp.setRight(d);
                x.setRight(d.getRight());
                x.setLeft(d.getLeft());
            }
            x.getRight().setParent(x);
            x.getLeft().setParent(x);
            d.setLeft(n);
            if (n != null) {
                n.setParent(d);
            }
            d.setRight(null);
            x = d;
        }
        boolean way = x.from();
        this.replace(x, n);
        n = x.getParent();
        if (datatoo) {
            x.getRow().delete();
        }
        x.delete();
        while (n != null) {
            x = n;
            int sign = way ? 1 : -1;
            switch (x.getBalance() * sign) {
                case -1: {
                    x.setBalance(0);
                    break;
                }
                case 0: {
                    x.setBalance(sign);
                    return;
                }
                case 1: {
                    Node r = this.child(x, !way);
                    int b = r.getBalance();
                    if (b * sign >= 0) {
                        this.replace(x, r);
                        this.set(x, !way, this.child(r, way));
                        this.set(r, way, x);
                        if (b == 0) {
                            x.setBalance(sign);
                            r.setBalance(-sign);
                            return;
                        }
                        x.setBalance(0);
                        r.setBalance(0);
                        x = r;
                        break;
                    }
                    Node l = this.child(r, way);
                    this.replace(x, l);
                    b = l.getBalance();
                    this.set(r, way, this.child(l, !way));
                    this.set(l, !way, r);
                    this.set(x, !way, this.child(l, way));
                    this.set(l, way, x);
                    x.setBalance(b == sign ? -sign : 0);
                    r.setBalance(b == -sign ? sign : 0);
                    l.setBalance(0);
                    x = l;
                }
            }
            way = x.from();
            n = x.getParent();
        }
    }

    Node findSimple(Object[] indexcoldata, boolean first) throws SQLException {
        Node x = this.root;
        Node result = null;
        if (indexcoldata[0] == null) {
            return null;
        }
        while (x != null) {
            Node n;
            int i = this.comparePartialRowNonUnique(indexcoldata, x.getData());
            if (i == 0) {
                if (!first) {
                    result = x;
                    break;
                }
                if (result == x) break;
                result = x;
                n = x.getLeft();
            } else {
                n = i > 0 ? x.getRight() : x.getLeft();
            }
            if (n == null) break;
            x = n;
        }
        return result;
    }

    Node find(Object[] data) throws SQLException {
        Node x = this.root;
        while (x != null) {
            int i = this.compareRowNonUnique(data, x.getData());
            if (i == 0) {
                return x;
            }
            Node n = i > 0 ? x.getRight() : x.getLeft();
            if (n == null) {
                return null;
            }
            x = n;
        }
        return null;
    }

    Node findFirst(Object value, int compare) throws SQLException {
        Trace.doAssert(compare == 23 || compare == 21 || compare == 22, "Index.findFirst");
        Node x = this.root;
        int iTest = 1;
        if (compare == 23) {
            iTest = 0;
        }
        while (x != null) {
            boolean t;
            boolean bl = t = this.compareValue(value, x.getData()[this.iColumn_0]) >= iTest;
            if (t) {
                Node r = x.getRight();
                if (r == null) break;
                x = r;
                continue;
            }
            Node l = x.getLeft();
            if (l == null) break;
            x = l;
        }
        while (x != null && this.compareValue(value, x.getData()[this.iColumn_0]) >= iTest) {
            x = this.next(x);
        }
        return x;
    }

    Node first() throws SQLException {
        Node x;
        Node l = x = this.root;
        while (l != null) {
            x = l;
            l = x.getLeft();
        }
        return x;
    }

    Node next(Node x) throws SQLException {
        Node r;
        if (x == null) {
            return null;
        }
        if (this.cleanUp && (++iNeedCleanUp & 0x7F) == 0) {
            this.table.cleanUp();
        }
        if ((r = x.getRight()) != null) {
            x = r;
            Node l = x.getLeft();
            while (l != null) {
                x = l;
                l = x.getLeft();
            }
            return x;
        }
        Node ch = x;
        for (x = x.getParent(); x != null && ch.equals(x.getRight()); x = x.getParent()) {
            ch = x;
        }
        return x;
    }

    private Node child(Node x, boolean w) throws SQLException {
        return w ? x.getLeft() : x.getRight();
    }

    private void replace(Node x, Node n) throws SQLException {
        if (x.equals(this.root)) {
            this.root = n;
            if (n != null) {
                n.setParent(null);
            }
        } else {
            this.set(x.getParent(), x.from(), n);
        }
    }

    private void set(Node x, boolean w, Node n) throws SQLException {
        if (w) {
            x.setLeft(n);
        } else {
            x.setRight(n);
        }
        if (n != null) {
            n.setParent(x);
        }
    }

    private Node search(Object[] d) throws SQLException {
        Node x = this.root;
        while (x != null) {
            int c = this.compareRow(d, x.getData());
            if (c == 0) {
                return x;
            }
            if (c < 0) {
                x = x.getLeft();
                continue;
            }
            x = x.getRight();
        }
        return null;
    }

    int comparePartialRowNonUnique(Object[] a, Object[] b) throws SQLException {
        int i = Column.compare(a[0], b[this.iColumn_0], this.iType_0);
        if (i != 0) {
            return i;
        }
        int fieldcount = this.visibleColumns;
        for (int j = 1; j < a.length && j < fieldcount; ++j) {
            Object o = a[j];
            if (o == null || (i = Column.compare(o, b[this.iColumn[j]], this.iType[j])) == 0) continue;
            return i;
        }
        return 0;
    }

    private int compareRowNonUnique(Object[] a, Object[] b) throws SQLException {
        int i = Column.compare(a[this.iColumn_0], b[this.iColumn_0], this.iType_0);
        if (i != 0) {
            return i;
        }
        int fieldcount = this.visibleColumns;
        for (int j = 1; j < fieldcount; ++j) {
            i = Column.compare(a[this.iColumn[j]], b[this.iColumn[j]], this.iType[j]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    private int compareRow(Object[] a, Object[] b) throws SQLException {
        int i = Column.compare(a[this.iColumn_0], b[this.iColumn_0], this.iType_0);
        if (i != 0) {
            return i;
        }
        for (int j = 1; j < this.iFields; ++j) {
            i = Column.compare(a[this.iColumn[j]], b[this.iColumn[j]], this.iType[j]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    private int compareValue(Object a, Object b) throws SQLException {
        return Column.compare(a, b, this.iType_0);
    }
}

