/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

class Like {
    private char[] cLike;
    private int[] iType;
    private int iLen;
    private boolean bIgnoreCase;

    Like(String s, char escape, boolean ignorecase) {
        if (ignorecase) {
            s = s.toUpperCase();
        }
        this.normalize(s, true, escape);
        this.bIgnoreCase = ignorecase;
    }

    String getStartsWith() {
        int i;
        StringBuffer s = new StringBuffer();
        for (i = 0; i < this.iLen && this.iType[i] == 0; ++i) {
            s.append(this.cLike[i]);
        }
        if (i == 0) {
            return null;
        }
        return s.toString();
    }

    boolean compare(Object o) {
        if (o == null) {
            return this.iLen == 0;
        }
        String s = o.toString();
        if (this.bIgnoreCase) {
            s = s.toUpperCase();
        }
        return this.compareAt(s, 0, 0, s.length());
    }

    private boolean compareAt(String s, int i, int j, int jLen) {
        while (i < this.iLen) {
            switch (this.iType[i]) {
                case 0: {
                    if (j < jLen && this.cLike[i] == s.charAt(j++)) break;
                    return false;
                }
                case 1: {
                    if (j++ < jLen) break;
                    return false;
                }
                case 2: {
                    if (++i >= this.iLen) {
                        return true;
                    }
                    while (j < jLen) {
                        if (this.cLike[i] == s.charAt(j) && this.compareAt(s, i, j, jLen)) {
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
            }
            ++i;
        }
        return j == jLen;
    }

    private void normalize(String s, boolean b, char e) {
        int i;
        this.iLen = 0;
        if (s == null) {
            return;
        }
        int l = s.length();
        this.cLike = new char[l];
        this.iType = new int[l];
        boolean bEscaping = false;
        boolean bPercent = false;
        for (i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (!bEscaping) {
                if (b && c == e) {
                    bEscaping = true;
                    continue;
                }
                if (c == '_') {
                    this.iType[this.iLen] = 1;
                } else if (c == '%') {
                    if (bPercent) continue;
                    bPercent = true;
                    this.iType[this.iLen] = 2;
                } else {
                    bPercent = false;
                }
            } else {
                bPercent = false;
                bEscaping = false;
            }
            this.cLike[this.iLen++] = c;
        }
        for (i = 0; i < this.iLen - 1; ++i) {
            if (this.iType[i] != 2 || this.iType[i + 1] != 1) continue;
            this.iType[i] = 1;
            this.iType[i + 1] = 2;
        }
    }
}

