/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Cache;
import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.HsqlDatabaseProperties;
import com.kingdee.eas.cp.hsqldb.Index;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.ReverseTextCache;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.StringConverter;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.TextCache;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

class Log
implements Runnable {
    private static final int COPY_BLOCK_SIZE = 65536;
    private HsqlDatabaseProperties pProperties;
    private String sName;
    private Database dDatabase;
    private Session sysSession;
    private Writer wScript;
    private File scriptChecker;
    private String sFileScript;
    private String sFileCache;
    private String sFileBackup;
    private boolean bRestoring;
    private boolean bReadOnly;
    private int iLogSize;
    private int iLogCount;
    private Thread tRunner;
    private volatile boolean bNeedFlush;
    private volatile boolean bWriteDelay;
    private int mLastId;
    private Cache cCache;
    private static final String lineSep = System.getProperty("line.separator", "\n");
    private Hashtable textCacheList = new Hashtable();

    Log(Database db, Session system, String name) throws SQLException {
        this.dDatabase = db;
        this.sysSession = system;
        this.sName = name;
        this.pProperties = db.getProperties();
        this.tRunner = new Thread(this);
        this.tRunner.start();
    }

    @Override
    public void run() {
        while (this.tRunner != null) {
            try {
                Thread.sleep(1000L);
                if (!this.bNeedFlush) continue;
                this.wScript.flush();
                this.bNeedFlush = false;
            }
            catch (Exception exception) {}
        }
    }

    void setWriteDelay(boolean delay) {
        this.bWriteDelay = delay;
    }

    boolean open() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!this.pProperties.checkFileExists()) {
            this.create();
            this.open();
            return true;
        }
        this.pProperties.load();
        this.sFileScript = this.sName + ".script";
        this.sFileCache = this.sName + ".data";
        this.sFileBackup = this.sName + ".backup";
        this.scriptChecker = new File(this.sFileScript);
        this.iLogSize = this.pProperties.getIntegerProperty("hsqldb.log_size", this.iLogSize);
        String version = this.pProperties.getProperty("hsqldb.compatible_version");
        int check = version.substring(0, 5).compareTo("1.7.1");
        Trace.check(check <= 0, 30);
        this.pProperties.setProperty("hsqldb.version", "1.7.1");
        if (this.pProperties.isPropertyTrue("readonly")) {
            this.bReadOnly = true;
            this.dDatabase.setReadOnly();
            if (this.cCache != null) {
                this.cCache.open(true);
            }
            this.reopenAllTextCaches();
            this.runScript();
            return false;
        }
        boolean needbackup = false;
        String state = this.pProperties.getProperty("modified");
        if (state.equals("yes-new-files")) {
            this.renameNewToCurrent(this.sFileScript);
            this.renameNewToCurrent(this.sFileBackup);
        } else if (state.equals("yes")) {
            if (this.isAlreadyOpen()) {
                throw Trace.error(1);
            }
            this.restoreBackup();
            needbackup = true;
        }
        this.pProperties.setProperty("modified", "yes");
        this.pProperties.save();
        if (this.cCache != null) {
            this.cCache.open(false);
        }
        this.reopenAllTextCaches();
        this.runScript();
        if (needbackup) {
            this.close(false);
            this.pProperties.setProperty("modified", "yes");
            this.pProperties.save();
            if (this.cCache != null) {
                this.cCache.open(false);
            }
            this.reopenAllTextCaches();
        }
        this.openScript();
        return false;
    }

    Cache getCache() throws SQLException {
        if (this.cCache == null) {
            this.cCache = new Cache(this.sFileCache, this.pProperties);
            this.cCache.open(this.bReadOnly);
        }
        return this.cCache;
    }

    void stop() {
        this.tRunner = null;
    }

    void close(boolean compact) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.bReadOnly) {
            return;
        }
        this.closeScript();
        this.writeScript(compact);
        if (this.cCache != null) {
            this.cCache.flush();
        }
        this.closeAllTextCaches(compact);
        this.backup();
        this.pProperties.setProperty("modified", "yes-new-files");
        this.pProperties.save();
        this.renameNewToCurrent(this.sFileScript);
        this.renameNewToCurrent(this.sFileBackup);
        this.pProperties.setProperty("modified", "no");
        this.pProperties.setProperty("version", "1.7.1");
        this.pProperties.setProperty("hsqldb.compatible_version", "1.7.0");
        this.pProperties.save();
        this.pProperties.close();
        if (compact) {
            this.stop();
            new File(this.sFileCache).delete();
            new File(this.sFileBackup).delete();
        }
    }

    void checkpoint() throws SQLException {
        this.close(false);
        this.pProperties.setProperty("modified", "yes");
        this.pProperties.save();
        if (this.cCache != null) {
            this.cCache.open(false);
        }
        this.reopenAllTextCaches();
        this.openScript();
    }

    void setLogSize(int mb) {
        this.iLogSize = mb;
        this.pProperties.setProperty("hsqldb.log_size", this.iLogSize);
    }

    void write(Session c, String s) throws SQLException {
        if (this.bRestoring || s == null || s.length() == 0) {
            return;
        }
        if (!this.bReadOnly) {
            int id = 0;
            if (c != null) {
                id = c.getId();
            }
            if (id != this.mLastId) {
                s = "/*C" + id + "*/" + s;
                this.mLastId = id;
            }
            try {
                Log.writeLine(this.wScript, s);
                if (this.bWriteDelay) {
                    this.bNeedFlush = true;
                } else {
                    this.wScript.flush();
                }
            }
            catch (IOException e) {
                throw Trace.error(29, this.sFileScript);
            }
            if (this.iLogSize > 0 && this.iLogCount++ > 100) {
                this.iLogCount = 0;
                if (this.scriptChecker.length() > (long)(this.iLogSize * 1024 * 1024)) {
                    this.checkpoint();
                }
            }
        }
    }

    void shutdown() throws SQLException {
        this.tRunner = null;
        if (this.cCache != null) {
            this.cCache.closeFile();
            this.cCache = null;
        }
        this.shutdownAllTextCaches();
        this.closeScript();
        this.pProperties.close();
    }

    static void scriptToFile(Database db, String file, boolean full, Session session) throws SQLException {
        if (new File(file).exists()) {
            throw Trace.error(29, file);
        }
        try {
            long time = 0L;
            if (Trace.TRACE) {
                time = System.currentTimeMillis();
            }
            Result r = full ? db.getScript(false, false, false, session) : db.getScript(false, false, true, session);
            Record n = r.rRoot;
            FileWriter w = new FileWriter(file);
            while (n != null) {
                Log.writeLine(w, (String)n.data[0]);
                n = n.next;
            }
            Vector tables = db.getTables();
            for (int i = 0; i < tables.size(); ++i) {
                Table t = (Table)tables.elementAt(i);
                if (!(!full && t.isCached() || t.isTemp() || t.isView() || t.isText() && t.isDataReadOnly())) {
                    Index primary = t.getPrimaryIndex();
                    Node x = primary.first();
                    while (x != null) {
                        Log.writeLine(w, t.getInsertStatement(x.getData()));
                        x = primary.next(x);
                    }
                }
                if (!t.isDataReadOnly() || t.isTemp() || t.isText()) continue;
                StringBuffer a = new StringBuffer("SET TABLE ");
                a.append(t.getName().statementName);
                a.append(" READONLY TRUE");
                Log.writeLine(w, a.toString());
            }
            w.close();
            if (Trace.TRACE) {
                Trace.trace(time - System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            throw Trace.error(29, file + " " + e);
        }
    }

    private void renameNewToCurrent(String file) {
        File newFile = new File(file + ".new");
        if (newFile.exists()) {
            File oldFile = new File(file);
            oldFile.delete();
            newFile.renameTo(oldFile);
        }
    }

    private void create() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(this.sName);
        }
        this.pProperties.setProperty("version", "1.7.1");
        this.pProperties.setProperty("sql.strict_fk", true);
        this.pProperties.save();
    }

    private boolean isAlreadyOpen() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        File f = new File(this.sName + ".lock");
        long l1 = f.lastModified();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = f.lastModified();
        if (l1 != l2) {
            return true;
        }
        return this.pProperties.isFileOpen();
    }

    private void backup() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!new File(this.sFileCache).exists()) {
            return;
        }
        try {
            int l;
            long time = 0L;
            if (Trace.TRACE) {
                time = System.currentTimeMillis();
            }
            DeflaterOutputStream f = new DeflaterOutputStream((OutputStream)new FileOutputStream(this.sFileBackup + ".new"), new Deflater(1), 65536);
            byte[] b = new byte[65536];
            FileInputStream in = new FileInputStream(this.sFileCache);
            while ((l = in.read(b, 0, 65536)) != -1) {
                f.write(b, 0, l);
            }
            f.close();
            in.close();
            if (Trace.TRACE) {
                Trace.trace(time - System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            throw Trace.error(29, this.sFileBackup);
        }
    }

    private void restoreBackup() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace("not closed last time!");
        }
        if (!new File(this.sFileBackup).exists()) {
            new File(this.sFileCache).delete();
            return;
        }
        try {
            int l;
            long time = 0L;
            if (Trace.TRACE) {
                time = System.currentTimeMillis();
            }
            InflaterInputStream f = new InflaterInputStream(new FileInputStream(this.sFileBackup), new Inflater());
            FileOutputStream cache = new FileOutputStream(this.sFileCache);
            byte[] b = new byte[65536];
            while ((l = f.read(b, 0, 65536)) != -1) {
                cache.write(b, 0, l);
            }
            cache.close();
            f.close();
            if (Trace.TRACE) {
                Trace.trace(time - System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            throw Trace.error(29, this.sFileBackup);
        }
    }

    private void openScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        try {
            this.wScript = new BufferedWriter(new FileWriter(this.sFileScript, true), 4096);
        }
        catch (Exception e) {
            throw Trace.error(29, this.sFileScript);
        }
    }

    private void closeScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        try {
            if (this.wScript != null) {
                this.wScript.close();
                this.wScript = null;
            }
        }
        catch (Exception e) {
            throw Trace.error(29, this.sFileScript);
        }
    }

    private void runScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!new File(this.sFileScript).exists()) {
            return;
        }
        this.bRestoring = true;
        this.dDatabase.setReferentialIntegrity(false);
        Vector<Session> session = new Vector<Session>();
        session.addElement(this.sysSession);
        Session current = this.sysSession;
        try {
            String s;
            long time = 0L;
            if (Trace.TRACE) {
                time = System.currentTimeMillis();
            }
            LineNumberReader r = new LineNumberReader(new FileReader(this.sFileScript));
            while ((s = Log.readLine(r)) != null) {
                Result result;
                int id;
                if (s.startsWith("/*C")) {
                    id = Integer.parseInt(s.substring(3, s.indexOf(42, 4)));
                    if (id >= session.size()) {
                        session.setSize(id + 1);
                    }
                    if ((current = (Session)session.elementAt(id)) == null) {
                        current = new Session(this.sysSession, id);
                        session.setElementAt(current, id);
                        this.dDatabase.registerSession(current);
                    }
                    s = s.substring(s.indexOf(47, 1) + 1);
                }
                if (s.length() != 0 && (result = this.dDatabase.execute(s, current)) != null && result.iMode == 1) {
                    throw Trace.getError(result.errorCode, result.sError);
                }
                if (!s.equals("DISCONNECT")) continue;
                id = current.getId();
                current = new Session(this.sysSession, id);
                session.setElementAt(current, id);
            }
            r.close();
            for (int i = 0; i < session.size(); ++i) {
                current = (Session)session.elementAt(i);
                if (current == null) continue;
                current.rollback();
            }
            if (Trace.TRACE) {
                Trace.trace(time - System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            throw Trace.error(29, this.sFileScript + " " + e);
        }
        this.dDatabase.setReferentialIntegrity(true);
        this.bRestoring = false;
    }

    private void writeScript(boolean full) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        new File(this.sFileScript + ".new").delete();
        Log.scriptToFile(this.dDatabase, this.sFileScript + ".new", full, this.sysSession);
    }

    private static int writeLine(Writer w, String s) throws IOException {
        String logLine = StringConverter.unicodeToAscii(s).append(lineSep).toString();
        w.write(logLine);
        return logLine.length();
    }

    private static String readLine(LineNumberReader r) throws IOException {
        String s = r.readLine();
        return StringConverter.asciiToUnicode(s);
    }

    HsqlDatabaseProperties getProperties() {
        return this.pProperties;
    }

    Cache openTextCache(String table, String source, boolean readOnlyData, boolean reversed) throws SQLException {
        this.closeTextCache(table);
        if (this.pProperties.getProperty("textdb.allow_full_path", "false").equals("false")) {
            if (source.indexOf("..") != -1) {
                throw Trace.error(33, source);
            }
            String path = new File(new File(this.sName).getAbsolutePath()).getParent();
            if (path != null) {
                source = path + File.separator + source;
            }
        }
        String prefix = "textdb." + table.toLowerCase() + ".";
        TextCache c = reversed ? new ReverseTextCache(source, prefix, this.pProperties) : new TextCache(source, prefix, this.pProperties);
        c.open(readOnlyData || this.bReadOnly);
        this.textCacheList.put(table, c);
        return c;
    }

    void closeTextCache(String table) throws SQLException {
        TextCache c = (TextCache)this.textCacheList.remove(table);
        if (c != null) {
            c.flush();
        }
    }

    void closeAllTextCaches(boolean compact) throws SQLException {
        Enumeration e = this.textCacheList.elements();
        while (e.hasMoreElements()) {
            if (compact) {
                ((TextCache)e.nextElement()).purge();
                continue;
            }
            ((TextCache)e.nextElement()).flush();
        }
    }

    void reopenAllTextCaches() throws SQLException {
        Enumeration e = this.textCacheList.elements();
        while (e.hasMoreElements()) {
            ((TextCache)e.nextElement()).reopen();
        }
    }

    void shutdownAllTextCaches() throws SQLException {
        Enumeration e = this.textCacheList.elements();
        while (e.hasMoreElements()) {
            ((TextCache)e.nextElement()).closeFile();
        }
        this.textCacheList = new Hashtable();
    }
}

