/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.DatabaseFile;
import java.io.FileNotFoundException;
import java.io.IOException;

class ReverseDatabaseFile
extends DatabaseFile {
    private int size;
    private long max;

    ReverseDatabaseFile(String name, String mode, int inSize) throws FileNotFoundException, IOException {
        super(name, mode, inSize);
        this.pos = this.max = this.length();
        this.size = inSize;
    }

    @Override
    public void readSeek(long newPos) throws IOException {
        if ((newPos = this.max - newPos) < 0L || this.in == null) {
            this.seek(newPos);
        } else if (newPos != this.pos) {
            this.index -= (int)(this.pos - newPos);
            this.pos = newPos;
            if (this.index < 0 || this.index > this.count) {
                this.count = 0;
                this.index = 0;
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return super.read();
        }
        if (this.index == 0) {
            long newPos = this.pos - (long)this.size;
            if (newPos < 0L) {
                this.realSeek(0L);
                this.count = (int)this.pos;
                this.readFully(this.in, 0, this.count);
            } else {
                this.realSeek(newPos);
                this.readFully(this.in);
                this.count = this.size;
            }
            this.index = this.count;
        }
        if (this.index == 0) {
            return -1;
        }
        --this.pos;
        return this.in[--this.index] & 0xFF;
    }

    @Override
    public int readInteger() throws IOException {
        this.seek(this.pos);
        return this.readInt();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.max - this.pos;
    }
}

