/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Expression;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.TableFilter;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.sql.SQLException;

class Select {
    boolean isPreProcess;
    boolean isDistinctSelect;
    private boolean isDistinctAggregate;
    private boolean isAggregated;
    private boolean isGrouped;
    private Object[] aggregateRow;
    private int aggregateCount;
    TableFilter[] tFilter;
    Expression eCondition;
    Expression havingCondition;
    Expression[] eColumn;
    int iResultLen;
    int iGroupLen;
    int iOrderLen;
    Select sUnion;
    HsqlName sIntoTable;
    int intoType = 2;
    boolean isIntoTableQuoted;
    int iUnionType;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    int limitStart = 0;
    int limitCount = 0;

    Select() {
    }

    void setPreProcess() {
        this.isPreProcess = true;
    }

    void resolve() throws SQLException {
        int len = this.tFilter.length;
        for (int i = 0; i < len; ++i) {
            this.resolve(this.tFilter[i], true);
        }
    }

    void resolve(TableFilter f, boolean ownfilter) throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.resolve(f);
            if (f != null && ownfilter) {
                f.setCondition(this.eCondition);
            }
        }
        int len = this.eColumn.length;
        for (int i = 0; i < len; ++i) {
            this.eColumn[i].resolve(f);
        }
    }

    void checkResolved() throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.checkResolved();
        }
        int len = this.eColumn.length;
        for (int i = 0; i < len; ++i) {
            this.eColumn[i].checkResolved();
        }
    }

    Object getValue(int type) throws SQLException {
        this.resolve();
        Result r = this.getResult(2);
        int size = r.getSize();
        int len = r.getColumnCount();
        Trace.check(size == 1 && len == 1, 17);
        Object o = r.rRoot.data[0];
        if (r.colType[0] == type) {
            return o;
        }
        return Column.convertObject(o, type);
    }

    Result getResult(int maxrows) throws SQLException {
        Expression e;
        this.resolve();
        this.checkResolved();
        if (this.sUnion != null && this.sUnion.iResultLen != this.iResultLen) {
            throw Trace.error(5);
        }
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
        }
        int len = this.eColumn.length;
        Result r = new Result(len);
        for (int i = 0; i < len; ++i) {
            Expression e2 = this.eColumn[i];
            r.colType[i] = e2.getDataType();
            r.colSize[i] = e2.getColumnSize();
            r.colScale[i] = e2.getColumnScale();
            if (!e2.isAggregate()) continue;
            this.isAggregated = true;
            if (this.isGrouped || !e2.isDistinctAggregate()) continue;
            this.isDistinctAggregate = true;
        }
        if (this.isAggregated) {
            this.aggregateRow = new Object[len];
        }
        if (maxrows == 0) {
            maxrows = this.limitCount;
        } else if (this.limitCount == 0) {
            this.limitCount = maxrows;
        } else {
            this.limitCount = maxrows > this.limitCount ? this.limitCount : maxrows;
            maxrows = this.limitCount;
        }
        boolean issimplemaxrows = false;
        if (!(maxrows == 0 || this.isDistinctSelect || this.isDistinctAggregate || this.isGrouped || this.sUnion != null || this.iOrderLen != 0)) {
            issimplemaxrows = true;
        }
        int limitcount = issimplemaxrows ? this.limitStart + maxrows : Integer.MAX_VALUE;
        this.buildResult(r, limitcount);
        if (this.isAggregated && !this.isGrouped && !this.isDistinctAggregate) {
            this.addAggregateRow(r, this.aggregateRow, len, this.aggregateCount);
        } else if (this.isGrouped) {
            this.groupResult(r);
        } else if (this.isDistinctAggregate) {
            r.removeDuplicates();
            this.buildDistinctAggregates(r);
            for (int i = 0; i < len; ++i) {
                e = this.eColumn[i];
                e.setDistinctAggregate(false);
                r.colType[i] = e.getDataType();
                r.colSize[i] = e.getColumnSize();
                r.colScale[i] = e.getColumnScale();
            }
        }
        if (this.isDistinctSelect) {
            int fullColumnCount = r.getColumnCount();
            r.setColumnCount(this.iResultLen);
            r.removeDuplicates();
            r.setColumnCount(fullColumnCount);
        }
        if (this.iOrderLen != 0) {
            int[] order = new int[this.iOrderLen];
            int[] way = new int[this.iOrderLen];
            int i = this.iResultLen + (this.isGrouped ? this.iGroupLen : 0);
            for (int j = 0; j < this.iOrderLen; ++j) {
                order[j] = i;
                way[j] = this.eColumn[i].isDescending() ? -1 : 1;
                ++i;
            }
            r.sortResult(order, way);
        }
        r.setColumnCount(this.iResultLen);
        for (int i = 0; i < this.iResultLen; ++i) {
            e = this.eColumn[i];
            r.sLabel[i] = e.getAlias();
            r.isLabelQuoted[i] = e.isAliasQuoted();
            r.sTable[i] = e.getTableName();
            r.sName[i] = e.getColumnName();
        }
        r.trimResult(this.limitStart, this.limitCount);
        if (this.sUnion != null) {
            Result x = this.sUnion.getResult(0);
            if (this.iUnionType == 1) {
                r.append(x);
                r.removeDuplicates();
            } else if (this.iUnionType == 2) {
                r.append(x);
            } else if (this.iUnionType == 3) {
                r.removeDifferent(x);
            } else if (this.iUnionType == 4) {
                r.removeSecond(x);
            }
        }
        return r;
    }

    private void updateAggregateRow(Object[] row, Object[] n, int len) throws SQLException {
        block6: for (int i = 0; i < len; ++i) {
            int type = this.eColumn[i].getDataType();
            switch (this.eColumn[i].getType()) {
                case 45: {
                    Integer increment = n[i] == null ? Expression.INTEGER_0 : Expression.INTEGER_1;
                    row[i] = Column.sum(row[i], increment, 4);
                    continue block6;
                }
                case 40: 
                case 41: 
                case 44: {
                    row[i] = Column.sum(row[i], n[i], type);
                    continue block6;
                }
                case 42: {
                    row[i] = Column.min(row[i], n[i], type);
                    continue block6;
                }
                case 43: {
                    row[i] = Column.max(row[i], n[i], type);
                    continue block6;
                }
                default: {
                    row[i] = n[i];
                }
            }
        }
    }

    private void addAggregateRow(Result x, Object[] row, int len, int count) throws SQLException {
        for (int i = 0; i < len; ++i) {
            int t = this.eColumn[i].getType();
            if (t == 44) {
                row[i] = Column.avg(row[i], this.eColumn[i].getDataType(), count);
                continue;
            }
            if (t != 40 || row[i] != null) continue;
            row[i] = Expression.INTEGER_0;
        }
        x.add(row);
    }

    private void buildResult(Result r, int limitcount) throws SQLException {
        boolean addtoaggregate;
        int len = this.eColumn.length;
        int count = 0;
        int filter = this.tFilter.length;
        boolean[] first = new boolean[filter];
        int level = 0;
        boolean bl = addtoaggregate = this.isAggregated && !this.isGrouped && !this.isDistinctAggregate;
        while (level >= 0 && !this.isPreProcess) {
            boolean found;
            TableFilter t = this.tFilter[level];
            first[level] = !first[level] ? (found = t.findFirst()) : (found = t.next());
            if (!found) {
                --level;
                continue;
            }
            if (level < filter - 1) {
                ++level;
                continue;
            }
            if (this.eCondition != null && !this.eCondition.test()) continue;
            Object[] row = new Object[len];
            for (int i = 0; i < len; ++i) {
                row[i] = this.eColumn[i].getValue();
            }
            ++count;
            if (addtoaggregate) {
                this.updateAggregateRow(this.aggregateRow, row, len);
                continue;
            }
            r.add(row);
            if (count < limitcount) continue;
            break;
        }
        if (addtoaggregate) {
            this.aggregateCount = count;
        }
    }

    private void groupResult(Result r) throws SQLException {
        int len = this.eColumn.length;
        int count = 0;
        int[] order = new int[this.iGroupLen];
        int[] way = new int[this.iGroupLen];
        int i = this.iResultLen;
        for (int j = 0; j < this.iGroupLen; ++j) {
            order[j] = i++;
            way[j] = 1;
        }
        r.sortResult(order, way);
        Record n = r.rRoot;
        Result x = new Result(len);
        do {
            Object[] row = new Object[len];
            count = 0;
            boolean newgroup = false;
            while (n != null && !newgroup) {
                ++count;
                for (int i2 = this.iResultLen; i2 < this.iResultLen + this.iGroupLen; ++i2) {
                    if (n.next == null) {
                        newgroup = true;
                        continue;
                    }
                    if (Column.compare(n.data[i2], n.next.data[i2], r.colType[i2]) == 0) continue;
                    newgroup = true;
                }
                this.updateAggregateRow(row, n.data, len);
                n = n.next;
            }
            if (!this.isAggregated && count <= 0) continue;
            this.addAggregateRow(x, row, len, count);
        } while (n != null);
        r.setRows(x);
    }

    private void buildDistinctAggregates(Result r) throws SQLException {
        int len = this.eColumn.length;
        int count = 0;
        Record n = r.rRoot;
        Result x = new Result(len);
        Object[] row = new Object[len];
        count = 0;
        while (n != null) {
            ++count;
            this.updateAggregateRow(row, n.data, len);
            n = n.next;
        }
        if (this.isAggregated || count > 0) {
            this.addAggregateRow(x, row, len, count);
        }
        r.setRows(x);
    }
}

