/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.HsqlProperties;
import com.kingdee.eas.cp.hsqldb.ServerConnection;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.jdbcSystem;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;

public class Server {
    static final int CONNECTION_CLOSED = 0;
    Vector serverConnList = new Vector(16);
    Database mDatabase;
    HsqlProperties serverProperties;
    protected ServerSocket socket;
    protected Thread thread;
    protected boolean traceMessages;
    private boolean restartOnShutdown;
    private boolean noSystemExit;

    public static void main(String[] arg) {
        String p;
        if (arg.length > 0 && (p = arg[0]) != null && p.startsWith("-?")) {
            Server.printHelp();
            return;
        }
        HsqlProperties props = HsqlProperties.argArrayToProps(arg, "server");
        Server server = new Server();
        server.setProperties(props);
        server.run();
    }

    void setProperties(HsqlProperties props) {
        this.serverProperties = new HsqlProperties("server");
        try {
            this.serverProperties.load();
        }
        catch (Exception e) {
            Trace.printSystemOut("server.properties not found, using command line or default properties");
        }
        this.serverProperties.addProperties(props);
        this.serverProperties.setPropertyIfNotExists("server.database", "test");
        this.serverProperties.setPropertyIfNotExists("server.port", String.valueOf(9001));
        if (this.serverProperties.isPropertyTrue("server.trace")) {
            jdbcSystem.setLogToSystem(true);
        }
        this.traceMessages = !this.serverProperties.isPropertyTrue("server.silent", true);
        this.noSystemExit = this.serverProperties.isPropertyTrue("server.no_system_exit");
        this.restartOnShutdown = this.serverProperties.isPropertyTrue("server.restart_on_shutdown");
    }

    void openDB() throws SQLException {
        String database = this.serverProperties.getProperty("server.database");
        this.mDatabase = new Database(database);
    }

    private void run() {
        try {
            int port = this.serverProperties.getIntegerProperty("server.port", 9001);
            String database = this.serverProperties.getProperty("server.database");
            Trace.printSystemOut("Opening database: " + database);
            this.printTraceMessages();
            this.openDB();
            this.socket = new ServerSocket(port);
            Trace.printSystemOut(new Date(System.currentTimeMillis()) + " Listening for connections ...");
        }
        catch (Exception e) {
            this.traceError("Server.run/init: " + e);
            e.printStackTrace();
            return;
        }
        try {
            while (true) {
                Socket s = this.socket.accept();
                ServerConnection c = new ServerConnection(s, this);
                this.thread = new Thread(c);
                this.thread.start();
            }
        }
        catch (IOException e) {
            if (this.mDatabase != null) {
                this.traceError("Server.run/loop: " + e.getMessage());
                e.printStackTrace();
            } else {
                this.trace("");
            }
            return;
        }
    }

    static void printHelp() {
        Trace.printSystemOut("Usage: java Server [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display JDBC trace messages\n    -no_system_exit <true/false>  do not issue System.exit()\nThe command line arguments override the values in the server.properties file.");
    }

    void printTraceMessages() {
        this.trace("server.port    =" + this.serverProperties.getProperty("server.port"));
        this.trace("server.database=" + this.serverProperties.getProperty("server.database"));
        this.trace("server.silent  =" + this.serverProperties.getProperty("server.silent"));
        Trace.printSystemOut("HSQLDB server 1.7.1 is running");
        Trace.printSystemOut("Use SHUTDOWN to close normally. Use [Ctrl]+[C] to abort abruptly");
    }

    void trace(String s) {
        if (this.traceMessages) {
            Trace.printSystemOut(s);
        }
    }

    void traceError(String s) {
        Trace.printSystemOut(s);
    }

    void closeAllServerConnections() {
        for (int i = this.serverConnList.size() - 1; i >= 0; --i) {
            ServerConnection sc = (ServerConnection)this.serverConnList.elementAt(i);
            sc.close();
        }
        this.serverConnList.removeAllElements();
    }

    void notify(int action) {
        if (this.mDatabase == null) {
            return;
        }
        if (!this.mDatabase.isShutdown()) {
            return;
        }
        this.mDatabase = null;
        this.closeAllServerConnections();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.traceError("Exception when closing the main socket");
        }
        this.serverProperties = null;
        this.socket = null;
        this.thread = null;
        if (!this.noSystemExit) {
            Trace.printSystemOut(new Date(System.currentTimeMillis()) + " SHUTDOWN : System.exit() is called next");
            System.exit(0);
        }
        Trace.printSystemOut(new Date(System.currentTimeMillis()) + " SHUTDOWN : System.exit() was not called");
    }
}

