/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.StringConverter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Servlet
extends HttpServlet {
    private String sError;
    private Database dDatabase;
    private String sDatabase;
    private static long lModified = 0L;
    private static int iQueries;

    public void init(ServletConfig config) {
        try {
            super.init(config);
        }
        catch (ServletException exp) {
            this.log(exp.getMessage());
        }
        this.sDatabase = this.getInitParameter("hsqldb.server.database");
        if (this.sDatabase == null) {
            this.sDatabase = ".";
        }
        this.log("Database filename = " + this.sDatabase);
        try {
            this.dDatabase = new Database(this.sDatabase);
        }
        catch (SQLException e) {
            this.sError = e.getMessage();
            this.log(this.sError);
        }
        this.log("Initialization completed.");
    }

    protected long getLastModified(HttpServletRequest req) {
        return lModified++;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String query = request.getQueryString();
        if (query == null || query.length() == 0) {
            response.setContentType("text/html");
            response.setHeader("Pragma", "no-cache");
            PrintWriter out = response.getWriter();
            out.println("<html><head><title>HSQL Database Engine Servlet</title>");
            out.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
            out.println("The servlet is running.<P>");
            if (this.dDatabase != null) {
                out.println("The database is also running.<P>");
                out.println("Database name: " + this.sDatabase + "<P>");
                out.println("Queries processed: " + iQueries + "<P>");
            } else {
                out.println("<h2>The database is not running!</h2>");
                out.println("The error message is:<P>");
                out.println(this.sError);
            }
            out.println("</body></html>");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletInputStream input = request.getInputStream();
        int len = request.getContentLength();
        byte[] b = new byte[len];
        input.read(b, 0, len);
        String s = new String(b);
        int p = s.indexOf(43);
        int q = s.indexOf(43, p + 1);
        if (p == -1 || q == -1) {
            this.doGet(request, response);
        }
        String user = s.substring(0, p);
        String password = s.substring(p + 1, q);
        s = s.substring(q + 1);
        try {
            user = StringConverter.hexStringToUnicode(user);
            password = StringConverter.hexStringToUnicode(password);
            s = StringConverter.hexStringToUnicode(s);
        }
        catch (SQLException e) {
            throw new ServletException();
        }
        response.setContentType("application/octet-stream");
        ServletOutputStream out = response.getOutputStream();
        byte[] result = this.dDatabase.execute(user, password, s);
        response.setContentLength(result.length);
        out.write(result);
        out.flush();
        out.close();
        ++iQueries;
    }
}

