/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.Transaction;
import com.kingdee.eas.cp.hsqldb.User;
import com.kingdee.eas.cp.hsqldb.jdbcConnection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

class Session {
    private Database dDatabase;
    private User uUser;
    private Vector tTransaction;
    private boolean bAutoCommit;
    private boolean bNestedTransaction;
    private boolean bNestedOldAutoCommit;
    private int iNestedOldTransIndex;
    private boolean bReadOnly;
    private int iMaxRows;
    private int iLastIdentity;
    private boolean bClosed;
    private int iId;
    private Hashtable hSavepoints;
    private boolean script;
    private jdbcConnection intConnection;

    public void finalize() throws SQLException {
        this.disconnect();
    }

    Session(Session c, int id) {
        this(c.dDatabase, c.uUser, true, c.bReadOnly, id);
    }

    Session(Database db, User user, boolean autocommit, boolean readonly, int id) {
        this.iId = id;
        this.dDatabase = db;
        this.uUser = user;
        this.tTransaction = new Vector();
        this.bAutoCommit = autocommit;
        this.bReadOnly = db.bReadOnly || readonly;
        this.hSavepoints = new Hashtable();
    }

    int getId() {
        return this.iId;
    }

    void disconnect() throws SQLException {
        if (this.bClosed) {
            return;
        }
        this.rollback();
        this.dDatabase.dropTempTables(this);
        this.dDatabase = null;
        this.uUser = null;
        this.tTransaction = null;
        this.hSavepoints = null;
        this.intConnection = null;
        this.bClosed = true;
    }

    boolean isClosed() {
        return this.bClosed;
    }

    void setLastIdentity(int i) {
        this.iLastIdentity = i;
    }

    int getLastIdentity() {
        return this.iLastIdentity;
    }

    Database getDatabase() {
        return this.dDatabase;
    }

    String getUsername() {
        return this.uUser.getName();
    }

    void setUser(User user) {
        this.uUser = user;
    }

    void checkAdmin() throws SQLException {
        this.uUser.checkAdmin();
    }

    void check(String object, int right) throws SQLException {
        this.uUser.check(object, right);
    }

    void checkReadWrite() throws SQLException {
        Trace.check(!this.bReadOnly, 31);
    }

    void setPassword(String s) {
        this.uUser.setPassword(s);
    }

    void addTransactionDelete(Table table, Object[] row) throws SQLException {
        if (!this.bAutoCommit) {
            Transaction t = new Transaction(true, table, row);
            this.tTransaction.addElement(t);
        }
    }

    void addTransactionInsert(Table table, Object[] row) throws SQLException {
        if (!this.bAutoCommit) {
            Transaction t = new Transaction(false, table, row);
            this.tTransaction.addElement(t);
        }
    }

    void setAutoCommit(boolean autocommit) throws SQLException {
        this.commit();
        this.bAutoCommit = autocommit;
    }

    void commit() throws SQLException {
        this.tTransaction.removeAllElements();
        this.hSavepoints.clear();
    }

    void rollback() throws SQLException {
        for (int i = this.tTransaction.size() - 1; i >= 0; --i) {
            Transaction t = (Transaction)this.tTransaction.elementAt(i);
            t.rollback();
        }
        this.tTransaction.removeAllElements();
        this.hSavepoints.clear();
    }

    void savepoint(String name) throws SQLException {
        this.hSavepoints.put(name, new Integer(this.tTransaction.size()));
    }

    void rollbackToSavepoint(String name) throws SQLException {
        Integer idx = (Integer)this.hSavepoints.get(name);
        Trace.check(idx != null, 44, name);
        for (int i = this.tTransaction.size() - 1; i >= idx; --i) {
            Transaction t = (Transaction)this.tTransaction.elementAt(i);
            t.rollback();
            this.tTransaction.removeElementAt(i);
        }
        this.hSavepoints.remove(name);
    }

    void beginNestedTransaction() throws SQLException {
        Trace.doAssert(!this.bNestedTransaction, "beginNestedTransaction");
        this.bNestedOldAutoCommit = this.bAutoCommit;
        this.bAutoCommit = false;
        this.iNestedOldTransIndex = this.tTransaction.size();
        this.bNestedTransaction = true;
    }

    void endNestedTransaction(boolean rollback) throws SQLException {
        Trace.doAssert(this.bNestedTransaction, "endNestedTransaction");
        if (rollback) {
            for (int i = this.tTransaction.size() - 1; i >= this.iNestedOldTransIndex; --i) {
                Transaction t = (Transaction)this.tTransaction.elementAt(i);
                t.rollback();
            }
        }
        this.bNestedTransaction = false;
        this.bAutoCommit = this.bNestedOldAutoCommit;
        if (this.bAutoCommit) {
            this.tTransaction.setSize(this.iNestedOldTransIndex);
        }
    }

    void setReadOnly(boolean readonly) {
        this.bReadOnly = readonly;
    }

    boolean isReadOnly() {
        return this.bReadOnly || this.dDatabase.bReadOnly;
    }

    void setMaxRows(int max) {
        this.iMaxRows = max;
    }

    int getMaxRows() {
        return this.iMaxRows;
    }

    boolean isNestedTransaction() {
        return this.bNestedTransaction;
    }

    boolean getAutoCommit() {
        return this.bAutoCommit;
    }

    void setScripting(boolean script) {
        this.script = script;
    }

    boolean getScripting() {
        return this.script;
    }

    jdbcConnection getInternalConnection() throws SQLException {
        if (this.intConnection == null) {
            this.intConnection = new jdbcConnection(this);
        }
        return this.intConnection;
    }
}

