/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.SQLException;

class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    StringConverter() {
    }

    static byte[] hexToByte(String s) throws SQLException {
        int l = s.length() / 2;
        byte[] data = new byte[l];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            char c;
            int n;
            if ((n = HEXINDEX.indexOf(c = s.charAt(j++))) == -1) {
                throw Trace.error(7, "hexadecimal string contains non hex character");
            }
            int b = (n & 0xF) << 4;
            c = s.charAt(j++);
            n = HEXINDEX.indexOf(c);
            data[i] = (byte)(b += n & 0xF);
        }
        return data;
    }

    static String byteToHex(byte[] b) {
        int len = b.length;
        StringBuffer s = new StringBuffer(len * 2);
        for (int i = 0; i < len; ++i) {
            int c = b[i] & 0xFF;
            s.append(HEXCHAR[c >> 4 & 0xF]);
            s.append(HEXCHAR[c & 0xF]);
        }
        return s.toString();
    }

    static String unicodeToHexString(String s) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            out.writeUTF(s);
            out.close();
            bout.close();
        }
        catch (IOException e) {
            return null;
        }
        return StringConverter.byteToHex(bout.toByteArray());
    }

    public static String hexStringToUnicode(String s) throws SQLException {
        byte[] b = StringConverter.hexToByte(s);
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        DataInputStream in = new DataInputStream(bin);
        try {
            return in.readUTF();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static StringBuffer unicodeToAscii(String s) {
        if (s == null || s.length() == 0) {
            return new StringBuffer();
        }
        int len = s.length();
        StringBuffer b = new StringBuffer(len + 16);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (i < len - 1 && s.charAt(i + 1) == 'u') {
                    b.append(c);
                    b.append("u005c");
                    continue;
                }
                b.append(c);
                continue;
            }
            if (c >= ' ' && c <= '\u007f') {
                b.append(c);
                continue;
            }
            b.append("\\u");
            b.append(HEXCHAR[c >> 12 & 0xF]);
            b.append(HEXCHAR[c >> 8 & 0xF]);
            b.append(HEXCHAR[c >> 4 & 0xF]);
            b.append(HEXCHAR[c & 0xF]);
        }
        return b;
    }

    public static String asciiToUnicode(String s) {
        if (s == null || s.indexOf("\\u") == -1) {
            return s;
        }
        int len = s.length();
        char[] b = new char[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < len - 5) {
                char c1 = s.charAt(i + 1);
                if (c1 == 'u') {
                    ++i;
                    int k = HEXINDEX.indexOf(s.charAt(++i)) << 12;
                    k += HEXINDEX.indexOf(s.charAt(++i)) << 8;
                    k += HEXINDEX.indexOf(s.charAt(++i)) << 4;
                    b[j++] = (char)(k += HEXINDEX.indexOf(s.charAt(++i)));
                    continue;
                }
                b[j++] = c;
                continue;
            }
            b[j++] = c;
        }
        return new String(b, 0, j);
    }

    public static String inputStreamToString(InputStream x) throws SQLException {
        InputStreamReader in = new InputStreamReader(x);
        StringWriter write = new StringWriter();
        int blocksize = 8192;
        char[] buffer = new char[blocksize];
        try {
            int l;
            while ((l = in.read(buffer, 0, blocksize)) != -1) {
                write.write(buffer, 0, l);
            }
            write.close();
            x.close();
        }
        catch (IOException e) {
            throw Trace.error(34, e.getMessage());
        }
        return write.toString();
    }

    static String toQuotedString(String s, char quotechar, boolean doublequote) {
        if (s == null) {
            return "NULL";
        }
        int l = s.length();
        StringBuffer b = new StringBuffer(l + 16).append(quotechar);
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (doublequote && c == quotechar) {
                b.append(c);
            }
            b.append(c);
        }
        return b.append(quotechar).toString();
    }
}

