/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Constraint;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Index;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

class TableWorks {
    private Table table;

    TableWorks(Table table) {
        this.table = table;
    }

    Table getTable() {
        return this.table;
    }

    void createForeignKey(int[] fkcol, int[] expcol, HsqlName fkname, Table expTable, boolean cascade) throws SQLException {
        Index fkindex;
        if (this.table.getConstraint(fkname.name) != null) {
            throw Trace.error(60);
        }
        int interval = this.table.dDatabase.getTableIndex(this.table) - this.table.dDatabase.getTableIndex(expTable);
        Index exportindex = interval == 0 ? expTable.getConstraintIndexForColumns(expcol, true) : expTable.getIndexForColumns(expcol, true);
        boolean strict = this.table.dDatabase.getProperties().isPropertyTrue("sql.strict_fk");
        boolean bl = strict = strict || !expTable.isTemp() && this.table.isTemp();
        if (expTable.isTemp() && !this.table.isTemp()) {
            throw Trace.error(47, "referenced table cannot be TEMPORARY");
        }
        if (strict && (exportindex == null || !exportindex.isUnique())) {
            throw Trace.error(26, "needs unique index on referenced columns of " + expTable.getName().statementName);
        }
        Index index = fkindex = interval >= 0 ? this.table.getConstraintIndexForColumns(fkcol, false) : this.table.getIndexForColumns(fkcol, false);
        if (fkindex == null) {
            HsqlName iname = HsqlName.makeAutoName("IDX");
            fkindex = this.createIndex(fkcol, iname, false);
        }
        boolean strong = this.table.dDatabase.getProperties().isPropertyTrue("sql.strong_fk");
        if (exportindex == null || strong && !exportindex.isUnique()) {
            HsqlName iname = HsqlName.makeAutoName("FK");
            TableWorks tw = new TableWorks(expTable);
            exportindex = tw.createIndex(expcol, iname, strong);
            expTable = tw.getTable();
        }
        HsqlName pkname = HsqlName.makeAutoName("REF", fkname.name);
        Constraint c = new Constraint(pkname, fkname, expTable, this.table, expcol, fkcol, exportindex, fkindex, cascade);
        this.table.addConstraint(c);
        expTable.addConstraint(new Constraint(pkname, c));
    }

    Index createIndex(int[] col, HsqlName name, boolean unique) throws SQLException {
        if (this.table.isEmpty()) {
            return this.table.createIndexPrivate(col, name, unique);
        }
        Table tn = this.table.moveDefinition(null, null, this.table.getColumnCount(), 0);
        Index newindex = tn.createIndexPrivate(col, name, unique);
        tn.moveData(this.table, this.table.getColumnCount(), 0);
        tn.updateConstraints(this.table, this.table.getColumnCount(), 0);
        int index = this.table.dDatabase.getTableIndex(this.table);
        this.table.dDatabase.getTables().setElementAt(tn, index);
        this.table = tn;
        return newindex;
    }

    void createUniqueConstraint(int[] col, HsqlName name) throws SQLException {
        Vector constraints = this.table.getConstraints();
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint c = (Constraint)constraints.elementAt(i);
            if (!c.isEquivalent(col, 2) && !c.getName().name.equals(name.name)) continue;
            throw Trace.error(60);
        }
        HsqlName indexname = HsqlName.makeAutoName("IDX");
        Index index = this.createIndex(col, indexname, true);
        Constraint newconstraint = new Constraint(name, this.table, index);
        this.table.addConstraint(newconstraint);
    }

    void dropIndex(String indexname) throws SQLException {
        Table tn = this.table.moveDefinition(indexname, null, this.table.getColumnCount(), 0);
        tn.moveData(this.table, this.table.getColumnCount(), 0);
        tn.updateConstraints(this.table, this.table.getColumnCount(), 0);
        int i = this.table.dDatabase.getTableIndex(this.table);
        this.table.dDatabase.getTables().setElementAt(tn, i);
        this.table = tn;
    }

    void addOrDropColumn(Column column, int colindex, int adjust) throws SQLException {
        Table tn = this.table.moveDefinition(null, column, colindex, adjust);
        tn.moveData(this.table, colindex, adjust);
        tn.updateConstraints(this.table, colindex, adjust);
        int i = this.table.dDatabase.getTableIndex(this.table);
        this.table.dDatabase.getTables().setElementAt(tn, i);
        this.table = tn;
    }

    void dropConstraint(String name) throws SQLException {
        int j = this.table.getConstraintIndex(name);
        Constraint c = this.table.getConstraint(name);
        Hashtable<Constraint, Constraint> cmap = new Hashtable<Constraint, Constraint>();
        cmap.put(c, c);
        if (c == null) {
            throw Trace.error(61, name + " in table: " + this.table.getName().name);
        }
        if (c.getType() == 1) {
            throw Trace.error(59);
        }
        if (c.getType() == 0) {
            Index refIndex;
            int k;
            Table mainTable;
            block12: {
                mainTable = c.getMain();
                Constraint mainConstraint = mainTable.getConstraint(c.getPkName());
                cmap.put(mainConstraint, mainConstraint);
                k = mainTable.getConstraintIndex(c.getPkName());
                Index mainIndex = mainConstraint.getMainIndex();
                if (mainIndex.getName().isReservedName()) {
                    boolean candrop = false;
                    try {
                        mainTable.checkDropIndex(mainIndex.getName().name, cmap);
                        candrop = true;
                        TableWorks tw = new TableWorks(mainTable);
                        tw.dropIndex(mainIndex.getName().name);
                        if (mainTable == this.table) {
                            this.table = tw.getTable();
                        }
                    }
                    catch (SQLException e) {
                        if (!candrop) break block12;
                        throw e;
                    }
                }
            }
            if ((refIndex = c.getRefIndex()).getName().isReservedName()) {
                try {
                    this.table.checkDropIndex(refIndex.getName().name, cmap);
                    this.dropIndex(refIndex.getName().name);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            mainTable.vConstraint.removeElementAt(k);
            this.table.vConstraint.removeElementAt(j);
        } else if (c.getType() == 2) {
            this.table.checkDropIndex(c.getMainIndex().getName().name, cmap);
            this.dropIndex(c.getMainIndex().getName().name);
            this.table.vConstraint.removeElementAt(j);
        }
    }
}

