/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Cache;
import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.DatabaseFile;
import com.kingdee.eas.cp.hsqldb.DatabaseRowOutputInterface;
import com.kingdee.eas.cp.hsqldb.HsqlDatabaseProperties;
import com.kingdee.eas.cp.hsqldb.QuotedTextDatabaseRowInput;
import com.kingdee.eas.cp.hsqldb.QuotedTextDatabaseRowOutput;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.TextDatabaseRowInput;
import com.kingdee.eas.cp.hsqldb.TextDatabaseRowOutput;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

class TextCache
extends Cache {
    public static final String NL = System.getProperty("line.separator");
    private String fs;
    private String vs;
    private String lvs;
    private DatabaseRowOutputInterface out;
    protected boolean readOnly;
    protected TextDatabaseRowInput in;
    protected boolean ignoreFirst;
    protected String ignoredFirst = NL;

    TextCache(String name, String propPrefix, HsqlDatabaseProperties props) throws SQLException {
        super("", props);
        String emptyIsNull;
        String skipFirst;
        String lvs;
        TextSource textSource = new TextSource(name);
        this.fs = this.translateSep(textSource.getAttr("fs", null));
        this.vs = textSource.getAttr("vs", this.fs);
        if (this.vs != this.fs) {
            this.vs = this.translateSep(this.vs);
        }
        if ((lvs = textSource.getAttr("lvs", this.fs)) != this.fs) {
            lvs = this.translateSep(lvs);
        }
        if (this.fs == null) {
            this.fs = this.translateSep(props.getProperty(propPrefix + "fs"), true);
            if (this.fs == null) {
                this.fs = ",";
            }
        }
        if (this.vs == null) {
            this.vs = props.getProperty(propPrefix + "vs", this.fs);
            if (this.vs != this.fs) {
                this.vs = this.translateSep(this.vs, true);
            }
        }
        if (lvs == null && (lvs = props.getProperty(propPrefix + "lvs", this.fs)) != this.fs) {
            lvs = this.translateSep(lvs, true);
        }
        if ((skipFirst = textSource.getAttr("ignore_first", null)) == null) {
            skipFirst = props.getProperty(propPrefix + "ignore_first", "false");
        }
        this.ignoreFirst = skipFirst.equals("true");
        String quoted = textSource.getAttr("quoted", null);
        if (quoted == null) {
            quoted = props.getProperty(propPrefix + "quoted", "true");
        }
        if ((emptyIsNull = textSource.getAttr("empty_is_null", null)) == null) {
            emptyIsNull = props.getProperty(propPrefix + "empty_is_null", "true");
        }
        this.sName = textSource.source;
        if (this.sName.endsWith(";")) {
            this.sName = this.sName.substring(0, this.sName.length() - 1);
        }
        try {
            if (quoted.equals("true")) {
                this.in = new QuotedTextDatabaseRowInput(this.fs, this.vs, lvs, emptyIsNull.equals("true"));
                this.out = new QuotedTextDatabaseRowOutput(this.fs, this.vs, lvs);
            } else {
                this.in = new TextDatabaseRowInput(this.fs, this.vs, lvs, emptyIsNull.equals("true"));
                this.out = new TextDatabaseRowOutput(this.fs, this.vs, lvs);
            }
        }
        catch (IOException e) {
            throw Trace.error(29, "invalid separator(s):" + e);
        }
    }

    private String translateSep(String sep) {
        return this.translateSep(sep, false);
    }

    private String translateSep(String sep, boolean isProperty) {
        if (sep == null) {
            return null;
        }
        int next = 0;
        next = sep.indexOf(92);
        if (next != -1) {
            int start = 0;
            char[] sepArray = sep.toCharArray();
            int ch = 0;
            int len = sep.length();
            StringBuffer realSep = new StringBuffer(len);
            do {
                realSep.append(sepArray, start, next - start);
                start = ++next;
                if (next >= len) {
                    realSep.append('\\');
                    break;
                }
                if (!isProperty) {
                    ch = sepArray[next];
                }
                if (ch == 110) {
                    realSep.append('\n');
                    ++start;
                    continue;
                }
                if (ch == 114) {
                    realSep.append('\r');
                    ++start;
                    continue;
                }
                if (ch == 116) {
                    realSep.append('\t');
                    ++start;
                    continue;
                }
                if (ch == 92) {
                    realSep.append('\\');
                    ++start;
                    continue;
                }
                if (ch == 117) {
                    realSep.append((char)Integer.parseInt(sep.substring(++start, start + 4), 16));
                    start += 4;
                    continue;
                }
                if (sep.startsWith("semi", next)) {
                    realSep.append(';');
                    start += 4;
                    continue;
                }
                if (sep.startsWith("space", next)) {
                    realSep.append(' ');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("quote", next)) {
                    realSep.append('\"');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("apos", next)) {
                    realSep.append('\'');
                    start += 4;
                    continue;
                }
                realSep.append('\\');
                realSep.append(sepArray[next]);
                ++start;
            } while ((next = sep.indexOf(92, start)) != -1);
            realSep.append(sepArray, start, len - start);
            sep = realSep.toString();
        }
        return sep;
    }

    @Override
    void open(boolean readonly) throws SQLException {
        try {
            this.rFile = new DatabaseFile(this.sName, readonly ? "r" : "rw", 4096);
            this.iFreePos = (int)this.rFile.length();
            if (this.iFreePos == 0 && this.ignoreFirst) {
                this.rFile.write(this.ignoredFirst.getBytes());
                this.iFreePos = this.ignoredFirst.length();
            }
        }
        catch (Exception e) {
            throw Trace.error(29, "error " + e + " opening " + this.sName);
        }
        this.readOnly = readonly;
    }

    void reopen() throws SQLException {
        this.open(this.readOnly);
        this.in.reset();
    }

    @Override
    void flush() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.seek(0L);
            this.saveAll();
            boolean empty = this.rFile.length() <= (long)NL.length();
            this.rFile.close();
            this.rFile = null;
            if (empty && !this.readOnly) {
                new File(this.sName).delete();
            }
        }
        catch (Exception e) {
            throw Trace.error(29, "error " + e + " closing " + this.sName);
        }
    }

    void purge() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            if (this.readOnly) {
                this.flush();
            } else {
                this.rFile.close();
                this.rFile = null;
                new File(this.sName).delete();
            }
        }
        catch (Exception e) {
            throw Trace.error(29, "error " + e + " purging " + this.sName);
        }
    }

    @Override
    void free(CachedRow r) throws SQLException {
        int pos = r.iPos;
        int length = r.storageSize;
        StringBuffer blank = new StringBuffer(length);
        length -= NL.length();
        for (int i = 0; i < length; ++i) {
            blank.append(' ');
        }
        blank.append(NL);
        try {
            this.rFile.seek(pos);
            this.rFile.writeBytes(blank.toString());
        }
        catch (IOException e) {
            throw Trace.error(29, e + "");
        }
        this.remove(r);
    }

    @Override
    protected void setStorageSize(CachedRow r) throws SQLException {
        int size;
        try {
            this.out.writeData(r.getData(), r.getTable());
            size = this.out.toByteArray().length;
        }
        catch (IOException e) {
            throw Trace.error(29, e + "");
        }
        r.storageSize = size;
    }

    @Override
    protected CachedRow makeRow(int pos, Table t) throws SQLException {
        CachedRow r = null;
        try {
            StringBuffer buffer = new StringBuffer(80);
            boolean blank = true;
            boolean complete = false;
            try {
                int next;
                this.rFile.readSeek(pos);
                while ((next = this.rFile.read()) != -1) {
                    char c = (char)(next & 0xFF);
                    if (c == '\n') {
                        buffer.append('\n');
                        if (this.ignoreFirst && pos == 0) {
                            this.ignoredFirst = buffer.toString();
                            blank = true;
                        }
                        if (!blank) {
                            complete = true;
                            break;
                        }
                        pos += buffer.length();
                        buffer.setLength(0);
                        blank = true;
                        this.in.skippedLine();
                        continue;
                    }
                    if (c == '\r') {
                        try {
                            next = this.rFile.read();
                            if (next == -1) break;
                            c = (char)(next & 0xFF);
                            if (c == '\n') {
                                buffer.append('\n');
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        buffer.append('\n');
                        if (this.ignoreFirst && pos == 0) {
                            this.ignoredFirst = buffer.toString();
                            blank = true;
                        }
                        if (!blank) {
                            complete = true;
                            break;
                        }
                        pos += buffer.length();
                        buffer.setLength(0);
                        blank = true;
                        this.in.skippedLine();
                        continue;
                    }
                    if (c != ' ') {
                        blank = false;
                    }
                    buffer.append(c);
                }
            }
            catch (Exception e) {
                complete = false;
            }
            if (complete) {
                this.in.setSource(buffer.toString(), pos);
                r = new CachedRow(t, this.in);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw Trace.error(29, "reading: " + e);
        }
        return r;
    }

    @Override
    protected void saveRow(CachedRow r) throws IOException, SQLException {
        this.rFile.seek(r.iPos);
        r.write(this.out);
        this.rFile.write(this.out.toByteArray());
    }

    private class TextSource {
        private String source;

        TextSource(String s) {
            this.source = s;
        }

        String getAttr(String id, String ret) {
            id = ";" + id + "=";
            int len = id.length();
            int start = this.source.indexOf(id);
            if (start != -1) {
                int end = this.source.indexOf(";", start += len);
                if (end == -1) {
                    end = this.source.length();
                }
                ret = this.source.substring(start, end);
                this.source = this.source.substring(0, start - len) + this.source.substring(end);
            }
            return ret;
        }
    }
}

