/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.ByteArray;
import com.kingdee.eas.cp.hsqldb.DatabaseRowOutput;
import com.kingdee.eas.cp.hsqldb.TextCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class TextDatabaseRowOutput
extends DatabaseRowOutput {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    private ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.out;

    public TextDatabaseRowOutput(String fieldSep, String varSep, String longvarSep) throws IOException {
        super(new ByteArrayOutputStream());
        this.skipSystemId = true;
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
    }

    @Override
    public void writePos(int pos) throws IOException {
    }

    @Override
    public void writeSize(int size) throws IOException {
    }

    @Override
    public void writeType(int type) throws IOException {
    }

    private void writeNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    private void writeVarNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    private void writeLongVarNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    @Override
    public void writeString(String s) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(s);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String s) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(s);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String s) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(s);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected void writeByteArray(byte[] b) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(b, 0, b.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarByteArray(byte[] b) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(b, 0, b.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarByteArray(byte[] b) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(b, 0, b.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    @Override
    public void writeIntData(int i) throws IOException {
        this.writeBytes(this.nextSep + i);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    @Override
    protected void writeFieldType(int type) throws IOException {
    }

    @Override
    protected void writeNull(int type) throws IOException {
        switch (type) {
            case -3: 
            case 12: 
            case 100: {
                this.writeVarNull();
                break;
            }
            case -4: 
            case -1: {
                this.writeLongVarNull();
                break;
            }
            default: {
                this.writeNull();
            }
        }
    }

    @Override
    protected void writeChar(String s, int t) throws IOException {
        switch (t) {
            case 1: {
                this.writeString(s);
                return;
            }
            case 12: 
            case 100: {
                this.writeVarString(s);
                return;
            }
        }
        this.writeLongVarString(s);
    }

    @Override
    protected void writeSmallint(Number o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeInteger(Number o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeBigint(Number o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeReal(Double o, int type) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeDecimal(BigDecimal o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeBit(Boolean o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeDate(Date o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeTime(Time o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeTimestamp(Timestamp o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeOther(Object o) throws IOException, SQLException {
        byte[] ba = ByteArray.serialize(o);
        this.writeByteArray(ba);
    }

    @Override
    protected void writeBinary(byte[] o, int t) throws IOException, SQLException {
        switch (t) {
            default: 
        }
        this.writeByteArray(o);
    }

    @Override
    public byte[] toByteArray() throws IOException {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.nextSep = "";
        this.nextSepEnd = false;
        this.writeBytes(TextCache.NL);
        byte[] ret = this.byteOut.toByteArray();
        this.byteOut.reset();
        return ret;
    }
}

