/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.User;
import java.sql.SQLException;
import java.util.Vector;

class UserManager {
    static final int SELECT = 1;
    static final int DELETE = 2;
    static final int INSERT = 4;
    static final int UPDATE = 8;
    static final int ALL = 15;
    private Vector uUser = new Vector();
    private User uPublic = this.createUser("PUBLIC", null, false);

    UserManager() throws SQLException {
    }

    static int getRight(String right) throws SQLException {
        if (right.equals("ALL")) {
            return 15;
        }
        if (right.equals("SELECT")) {
            return 1;
        }
        if (right.equals("UPDATE")) {
            return 8;
        }
        if (right.equals("DELETE")) {
            return 2;
        }
        if (right.equals("INSERT")) {
            return 4;
        }
        throw Trace.error(11, right);
    }

    static String getRight(int right) {
        if (right == 15) {
            return "ALL";
        }
        if (right == 0) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        if ((right & 1) != 0) {
            b.append("SELECT,");
        }
        if ((right & 8) != 0) {
            b.append("UPDATE,");
        }
        if ((right & 2) != 0) {
            b.append("DELETE,");
        }
        if ((right & 4) != 0) {
            b.append("INSERT,");
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    User createUser(String name, String password, boolean admin) throws SQLException {
        int uSize = this.uUser.size();
        for (int i = 0; i < uSize; ++i) {
            User u = (User)this.uUser.elementAt(i);
            if (u == null || !u.getName().equals(name)) continue;
            throw Trace.error(36, name);
        }
        User u = new User(name, password, admin, this.uPublic);
        this.uUser.addElement(u);
        return u;
    }

    void dropUser(String name) throws SQLException {
        Trace.check(!name.equals("PUBLIC"), 33);
        int uSize = this.uUser.size();
        for (int i = 0; i < uSize; ++i) {
            User u = (User)this.uUser.elementAt(i);
            if (u == null || !u.getName().equals(name)) continue;
            this.uUser.setElementAt(null, i);
            u.revokeAll();
            return;
        }
        throw Trace.error(37, name);
    }

    User getUser(String name, String password) throws SQLException {
        Trace.check(!name.equals("PUBLIC"), 33);
        if (name == null) {
            name = "";
        }
        if (password == null) {
            password = "";
        }
        User u = this.get(name);
        u.checkPassword(password);
        return u;
    }

    Vector getUsers() {
        return this.uUser;
    }

    void grant(String name, String object, int right) throws SQLException {
        this.get(name).grant(object, right);
    }

    void revoke(String name, String object, int right) throws SQLException {
        this.get(name).revoke(object, right);
    }

    private User get(String name) throws SQLException {
        int uSize = this.uUser.size();
        for (int i = 0; i < uSize; ++i) {
            User u = (User)this.uUser.elementAt(i);
            if (u == null || !u.getName().equals(name)) continue;
            return u;
        }
        throw Trace.error(37, name);
    }
}

