/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.HsqlProperties;
import com.kingdee.eas.cp.hsqldb.Server;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.WebServerConnection;
import com.kingdee.eas.cp.hsqldb.jdbcSystem;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class WebServer
extends Server {
    static final String mServerName = "HSQLDB/1.7.1";
    String mRoot;
    String mDefaultFile;
    char mPathSeparatorChar;

    public static void main(String[] arg) {
        String p;
        if (arg.length > 0 && (p = arg[0]) != null && p.startsWith("-?")) {
            WebServer.printHelp();
            return;
        }
        WebServer server = new WebServer();
        HsqlProperties props = HsqlProperties.argArrayToProps(arg, "server");
        server.setProperties(props);
        server.run();
    }

    @Override
    void setProperties(HsqlProperties props) {
        this.serverProperties = new HsqlProperties("webserver");
        try {
            this.serverProperties.load();
        }
        catch (Exception e) {
            Trace.printSystemOut("webserver.properties not found, using command line or default properties");
        }
        this.serverProperties.addProperties(props);
        this.serverProperties.setPropertyIfNotExists("server.database", "test");
        this.serverProperties.setPropertyIfNotExists("server.port", "80");
        this.mRoot = this.serverProperties.setPropertyIfNotExists("server.root", "./");
        this.mDefaultFile = this.serverProperties.setPropertyIfNotExists("server.default_page", "index.html");
        if (this.serverProperties.isPropertyTrue("server.trace")) {
            jdbcSystem.setLogToSystem(true);
        }
        this.traceMessages = !this.serverProperties.isPropertyTrue("server.silent", true);
    }

    private void run() {
        this.socket = null;
        try {
            int port = this.serverProperties.getIntegerProperty("server.port", 80);
            String database = this.serverProperties.getProperty("server.database");
            Trace.printSystemOut("Opening database: " + database);
            this.printTraceMessages();
            this.mPathSeparatorChar = File.separatorChar;
            this.mDatabase = new Database(database);
            this.socket = new ServerSocket(port);
        }
        catch (Exception e) {
            this.traceError("WebServer.run/init: " + e);
            return;
        }
        try {
            while (true) {
                Socket s = this.socket.accept();
                WebServerConnection c = new WebServerConnection(s, this);
                this.thread = new Thread(c);
                this.thread.start();
            }
        }
        catch (IOException e) {
            this.traceError("WebServer.run/loop: " + e.getMessage());
            return;
        }
    }

    static void printHelp() {
        Trace.printSystemOut("Usage: java WebServer [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -root <path>          root path for sending files\n    -default_page <file>  default page when page name is missing\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display JDBC trace messages\nThe command line arguments override the values in the webserver.properties file.");
    }

    @Override
    void printTraceMessages() {
        this.trace("server.port        =" + this.serverProperties.getProperty("server.port"));
        this.trace("server.database    =" + this.serverProperties.getProperty("server.database"));
        this.trace("server.root        =" + this.serverProperties.getProperty("server.root"));
        this.trace("server.default_page=" + this.serverProperties.getProperty("server.default_page"));
        this.trace("server.silent      =" + this.serverProperties.getProperty("server.silent"));
        Trace.printSystemOut("HSQLDB web server 1.7.1 is running");
        Trace.printSystemOut("Use SHUTDOWN to close normally. Use [Ctrl]+[C] to abort abruptly");
    }
}

