/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.jdbcConnection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class jdbcDataSource
implements Serializable,
Referenceable,
DataSource {
    private int loginTimeout = 0;
    private transient PrintWriter logWriter;
    private String password = "";
    private String user = "";
    private static final String sStartURL = "jdbc:hsqldb:";
    private String database = "";

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        if (user != null) {
            props.put("user", user);
        }
        if (password != null) {
            props.put("password", password);
        }
        return new jdbcConnection(this.database, props);
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        String cname = "org.hsqldb.jdbcDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), cname, null);
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        return ref;
    }

    public String getUser() {
        return this.user;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public void setLoginTimeout(int ignore) throws SQLException {
        this.loginTimeout = ignore;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

