/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.HsqlProperties;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.lib.AsciiStringInputStream;
import com.kingdee.eas.cp.hsqldb.lib.StringInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class jdbcResultSet
implements ResultSet,
ResultSetMetaData {
    private Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    private int iColumnCount;
    private boolean bWasNull;
    private boolean getColumnName = true;
    private boolean strictMetaData = false;
    private HsqlProperties connProperties;
    Statement sqlStatement;
    int rsType = 1003;

    @Override
    public boolean next() throws SQLException {
        this.bWasNull = false;
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            if (this.nCurrent == null) {
                return false;
            }
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = 0;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.iUpdateCount = -1;
        this.rResult = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.bWasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object o;
        this.checkAvailable();
        try {
            o = this.nCurrent.data[--columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw Trace.error(28, ++columnIndex);
        }
        this.checkNull(o);
        return o == null ? null : o.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, -7);
        return o == null ? false : (Boolean)o;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 5);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 5);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 4);
        return o == null ? 0 : ((Number)o).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, -5);
        return o == null ? 0L : ((Number)o).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 7);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 8);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bd = (BigDecimal)this.getColumnInType(columnIndex, 3);
        if (scale < 0) {
            throw Trace.error(62);
        }
        if (bd != null) {
            bd.setScale(scale, 5);
        }
        return bd;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object x = this.getObject(columnIndex);
        if (x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof String) {
            return ((String)x).getBytes();
        }
        x = this.getColumnInType(--columnIndex, -2);
        return (byte[])x;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getColumnInType(columnIndex, 91);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getColumnInType(columnIndex, 92);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getColumnInType(columnIndex, 93);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new AsciiStringInputStream(s);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringInputStream(s);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] b = this.getBytes(columnIndex);
        return this.wasNull() ? null : new ByteArrayInputStream(b);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object o;
        this.checkAvailable();
        try {
            o = this.nCurrent.data[--columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw Trace.error(28, ++columnIndex);
        }
        this.checkNull(o);
        return o;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(columnName);
        }
        for (int i = 0; i < this.iColumnCount; ++i) {
            if (!columnName.equalsIgnoreCase(this.rResult.sLabel[i])) continue;
            return i + 1;
        }
        throw Trace.error(28);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringReader(s);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.getColumnInType(columnIndex, 3);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return !this.bInit;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!this.bInit) {
            return false;
        }
        return this.nCurrent == null;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.iCurrentRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!this.bInit || this.nCurrent == null) {
            return false;
        }
        return this.nCurrent.next == null;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        this.bInit = false;
        this.nCurrent = null;
        this.iCurrentRow = 0;
    }

    @Override
    public void afterLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult != null && this.rResult.rRoot != null) {
            this.bInit = true;
            this.iCurrentRow = 0;
            this.nCurrent = null;
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        this.bInit = false;
        if (this.rResult.rRoot != null) {
            this.bInit = true;
            this.nCurrent = this.rResult.rRoot;
            this.iCurrentRow = 1;
        }
        return this.bInit;
    }

    @Override
    public boolean last() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (!this.bInit | this.nCurrent == null) {
            this.first();
        }
        while (this.nCurrent.next != null) {
            ++this.iCurrentRow;
            this.nCurrent = this.nCurrent.next;
        }
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.iCurrentRow;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || row == 0) {
            return false;
        }
        switch (row) {
            case 1: {
                return this.first();
            }
            case -1: {
                return this.last();
            }
        }
        if (row < 0) {
            this.last();
            row = this.iCurrentRow + row + 1;
            if (row <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (row < this.iCurrentRow || this.iCurrentRow == 0) {
            this.beforeFirst();
        }
        while (row > this.iCurrentRow) {
            this.next();
            if (this.nCurrent != null) continue;
        }
        return this.nCurrent != null;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || this.bInit && this.iCurrentRow == 0) {
            return false;
        }
        if (rows < 0) {
            rows = this.iCurrentRow + rows;
            this.beforeFirst();
            if (rows <= 0) {
                return false;
            }
        }
        while (rows-- > 0) {
            this.next();
            if (this.nCurrent != null) continue;
        }
        return this.nCurrent != null;
    }

    @Override
    public boolean previous() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || this.iCurrentRow == 0) {
            return false;
        }
        if (this.bInit && this.nCurrent == null) {
            return this.last();
        }
        int targetRow = this.iCurrentRow - 1;
        if (targetRow == 0) {
            this.beforeFirst();
            return false;
        }
        this.first();
        while (targetRow != this.iCurrentRow) {
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        return this.nCurrent != null;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(direction);
        }
        if (this.rsType == 1003 && direction != 1000) {
            throw this.getNotSupported();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(rows);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 1;
    }

    @Override
    public int getType() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.rsType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(columnIndex);
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void insertRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void updateRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void deleteRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void refreshRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.sqlStatement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.iColumnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            return 2;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        int type = this.rResult.colType[column - 1];
        for (int i = 0; i < Column.numericTypes.length; ++i) {
            if (type != Column.numericTypes[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return this.rResult.sLabel[--column];
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        if (this.getColumnName) {
            return this.rResult.sName[--column];
        }
        return this.rResult.sLabel[--column];
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return this.rResult.sTable[--column];
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return this.rResult.colType[--column];
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(column);
        return Column.getTypeString(this.rResult.colType[--column]);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    private SQLException getNotSupported() {
        return Trace.error(20);
    }

    private SQLException getNotSupportedJDBC3() {
        return Trace.error(20, "JDBC3");
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            throw Trace.error(35);
        }
    }

    private void checkColumn(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.iColumnCount) {
            throw Trace.error(28, columnIndex);
        }
    }

    private void checkNull(Object o) {
        this.bWasNull = o == null;
    }

    private Object getColumnInType(int columnIndex, int type) throws SQLException {
        Object o;
        int t;
        this.checkAvailable();
        try {
            t = this.rResult.colType[--columnIndex];
            o = this.nCurrent.data[columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw Trace.error(28, ++columnIndex);
        }
        this.checkNull(o);
        if (type == t) {
            return o;
        }
        try {
            return Column.convertObject(o, type);
        }
        catch (Exception e) {
            String s = "type: " + Column.getTypeString(t) + " (" + t + ") expected: " + Column.getTypeString(type) + " value: " + o.toString();
            throw Trace.error(16, s);
        }
    }

    jdbcResultSet(Result r, HsqlProperties props) throws SQLException {
        this.connProperties = props;
        if (props != null) {
            this.getColumnName = props.isPropertyTrue("jdbc.get_column_name", true);
            this.strictMetaData = props.isPropertyTrue("jdbc.strict_md", false);
        }
        if (r.iMode == 0) {
            this.iUpdateCount = r.iUpdateCount;
        } else {
            if (r.iMode == 1) {
                throw Trace.getError(r.sError, r.errorCode);
            }
            this.iUpdateCount = -1;
            this.rResult = r;
            this.iColumnCount = r.getColumnCount();
        }
        this.bWasNull = false;
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    boolean isResult() {
        return this.rResult != null;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return null;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }
}

