/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.lib;

import com.kingdee.eas.cp.hsqldb.Trace;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class HsqlDateTime {
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    private static SimpleDateFormat sdfts;

    public static Timestamp timestampValue(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null string");
        }
        if (s.toUpperCase().equals("NOW") || s.toUpperCase().equals("CURRENT_TIMESTAMP")) {
            return new Timestamp(System.currentTimeMillis());
        }
        String zerodatetime = "1970-01-01 00:00:00.000000000";
        s = s + "1970-01-01 00:00:00.000000000".substring(s.length());
        return Timestamp.valueOf(s);
    }

    public static Timestamp timestampValue(long time, int nano) {
        Timestamp ts = new Timestamp(time);
        ts.setNanos(nano);
        return ts;
    }

    public static java.sql.Date dateValue(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null string");
        }
        if ((s = s.toUpperCase()).equals("TODAY") || s.equals("NOW") || s.equals("CURRENT_DATE") || s.equals("SYSDATE")) {
            return new java.sql.Date(System.currentTimeMillis());
        }
        return java.sql.Date.valueOf(s.substring(0, sdfdPattern.length()));
    }

    public static Time timeValue(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null string");
        }
        if (s.toUpperCase().equals("NOW") || s.toUpperCase().equals("CURRENT_TIME")) {
            return new Time(System.currentTimeMillis());
        }
        return Time.valueOf(s);
    }

    public static java.sql.Date getDate(String dateString, Calendar cal) throws SQLException {
        SimpleDateFormat sdfd = new SimpleDateFormat(sdfdPattern);
        sdfd.setCalendar(cal);
        try {
            Date d = sdfd.parse(dateString);
            return new java.sql.Date(d.getTime());
        }
        catch (ParseException e) {
            throw HsqlDateTime.invalidValue();
        }
    }

    public static Time getTime(String timeString, Calendar cal) throws SQLException {
        SimpleDateFormat sdft = new SimpleDateFormat(sdftPattern);
        sdft.setCalendar(cal);
        try {
            Date d = sdft.parse(timeString);
            return new Time(d.getTime());
        }
        catch (ParseException e) {
            throw HsqlDateTime.invalidValue();
        }
    }

    public static Timestamp getTimestamp(String dateString, Calendar cal) throws SQLException {
        SimpleDateFormat sdfts = new SimpleDateFormat(sdftsPattern);
        sdfts.setCalendar(cal);
        try {
            Date d = sdfts.parse(dateString.substring(0, sdftsPattern.length()));
            String nanostring = dateString.substring(sdftsPattern.length(), dateString.length());
            Timestamp ts = new Timestamp(d.getTime());
            ts.setNanos(Integer.parseInt(nanostring));
            return ts;
        }
        catch (ParseException e) {
            throw HsqlDateTime.invalidValue();
        }
    }

    public static String getTimestampString(Timestamp x, Calendar cal) throws SQLException {
        SimpleDateFormat sdfts = new SimpleDateFormat(sdftsPattern);
        sdfts.setCalendar(cal);
        return sdfts.format(new Date(x.getTime() + (long)(x.getNanos() / 1000000)));
    }

    public static String getTimeString(Time x, Calendar cal) throws SQLException {
        SimpleDateFormat sdft = new SimpleDateFormat(sdftPattern);
        sdft.setCalendar(cal);
        return sdft.format(new Date(x.getTime()));
    }

    public static String getDateString(java.sql.Date x, Calendar cal) throws SQLException {
        SimpleDateFormat sdfd = new SimpleDateFormat(sdfdPattern);
        sdfd.setCalendar(cal);
        return sdfd.format(new Date(x.getTime()));
    }

    private static SQLException invalidValue() {
        return Trace.error(11);
    }
}

