/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.test;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class TestSql
extends TestCase {
    String url = "jdbc:hsqldb:test3";
    String user;
    String password;
    Statement stmnt;
    Connection cConnection;
    String getColumnName;

    public TestSql(String name) {
        super(name);
    }

    protected void setUp() {
        this.user = "sa";
        this.password = "";
        this.stmnt = null;
        this.cConnection = null;
        this.getColumnName = "false";
        Properties props = new Properties();
        props.put("user", this.user);
        props.put("password", this.password);
        props.put("jdbc.strict_md", "false");
        props.put("jdbc.get_column_name", this.getColumnName);
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.cConnection = DriverManager.getConnection(this.url, props);
            this.stmnt = this.cConnection.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("TestSql.setUp() error: " + e.getMessage());
        }
    }

    public void testMetaData() {
        String ddl1 = "CREATE TABLE USER(USER_ID INTEGER NOT NULL PRIMARY KEY,LOGIN_ID VARCHAR(128) NOT NULL,USER_NAME VARCHAR(254) DEFAULT ' ' NOT NULL,CREATE_DATE TIMESTAMP DEFAULT 'CURRENT_TIMESTAMP' NOT NULL,UPDATE_DATE TIMESTAMP DEFAULT 'CURRENT_TIMESTAMP' NOT NULL,LAST_ACCESS_DATE TIMESTAMP,CONSTRAINT IXUQ_LOGIN_ID0 UNIQUE(LOGIN_ID))";
        String ddl2 = "CREATE TABLE ADDRESSBOOK_CATEGORY(USER_ID INTEGER NOT NULL,CATEGORY_ID INTEGER DEFAULT 0 NOT NULL,CATEGORY_NAME VARCHAR(60) DEFAULT '' NOT NULL,CONSTRAINT SYS_PK_ADDRESSBOOK_CATEGORY PRIMARY KEY(USER_ID,CATEGORY_ID),CONSTRAINT FK_ADRBKCAT1 FOREIGN KEY(USER_ID) REFERENCES USER(USER_ID) ON DELETE CASCADE)";
        String ddl3 = "CREATE TABLE ADDRESSBOOK(USER_ID INTEGER NOT NULL,ADDRESSBOOK_ID INTEGER NOT NULL,CATEGORY_ID INTEGER DEFAULT 0 NOT NULL,FIRST VARCHAR(64) DEFAULT '' NOT NULL,LAST VARCHAR(64) DEFAULT '' NOT NULL,NOTE VARCHAR(128) DEFAULT '' NOT NULL,CONSTRAINT SYS_PK_ADDRESSBOOK PRIMARY KEY(USER_ID,ADDRESSBOOK_ID),CONSTRAINT FK_ADRBOOK1 FOREIGN KEY(USER_ID,CATEGORY_ID) REFERENCES ADDRESSBOOK_CATEGORY(USER_ID,CATEGORY_ID) ON DELETE CASCADE)";
        String result1 = "1";
        String result2 = "2";
        String result3 = "3";
        String result4 = "4";
        String result5 = "5";
        try {
            int i;
            this.stmnt.execute(ddl1);
            this.stmnt.execute(ddl2);
            this.stmnt.execute(ddl3);
            DatabaseMetaData md = this.cConnection.getMetaData();
            ResultSet rs = md.getPrimaryKeys(null, null, "USER");
            ResultSetMetaData rsmd = rs.getMetaData();
            String result0 = "";
            while (rs.next()) {
                for (i = 0; i < rsmd.getColumnCount(); ++i) {
                    result0 = result0 + rs.getString(i + 1) + ":";
                }
                result0 = result0 + "\n";
            }
            rs.close();
            System.out.println(result0);
            rs = md.getBestRowIdentifier(null, null, "USER", 0, true);
            rsmd = rs.getMetaData();
            result0 = "";
            while (rs.next()) {
                for (i = 0; i < rsmd.getColumnCount(); ++i) {
                    result0 = result0 + rs.getString(i + 1) + ":";
                }
                result0 = result0 + "\n";
            }
            rs.close();
            System.out.println(result0);
            rs = md.getImportedKeys(null, null, "ADDRESSBOOK");
            rsmd = rs.getMetaData();
            result1 = "";
            while (rs.next()) {
                for (int i2 = 0; i2 < rsmd.getColumnCount(); ++i2) {
                    result1 = result1 + rs.getString(i2 + 1) + ":";
                }
                result1 = result1 + "\n";
            }
            rs.close();
            System.out.println(result1);
            rs = md.getCrossReference(null, null, "ADDRESSBOOK_CATEGORY", null, null, "ADDRESSBOOK");
            rsmd = rs.getMetaData();
            result2 = "";
            while (rs.next()) {
                for (int i3 = 0; i3 < rsmd.getColumnCount(); ++i3) {
                    result2 = result2 + rs.getString(i3 + 1) + ":";
                }
                result2 = result2 + "\n";
            }
            rs.close();
            System.out.println(result2);
            rs = md.getExportedKeys(null, null, "USER");
            rsmd = rs.getMetaData();
            result3 = "";
            while (rs.next()) {
                for (int i4 = 0; i4 < rsmd.getColumnCount(); ++i4) {
                    result3 = result3 + rs.getString(i4 + 1) + ":";
                }
                result3 = result3 + "\n";
            }
            rs.close();
            System.out.println(result3);
            rs = md.getCrossReference(null, null, "USER", null, null, "ADDRESSBOOK_CATEGORY");
            rsmd = rs.getMetaData();
            result4 = "";
            while (rs.next()) {
                for (int i5 = 0; i5 < rsmd.getColumnCount(); ++i5) {
                    result4 = result4 + rs.getString(i5 + 1) + ":";
                }
                result4 = result4 + "\n";
            }
            rs.close();
            System.out.println(result4);
            this.stmnt.executeQuery("CREATE TABLE T (A CHAR, B CHAR);");
            this.stmnt.executeQuery("INSERT INTO T VALUES ('get_column_name', '" + this.getColumnName + "');");
            rs = this.stmnt.executeQuery("SELECT A, B, A \"aliasA\", B \"aliasB\" FROM T;");
            rsmd = rs.getMetaData();
            result5 = "";
            while (rs.next()) {
                for (int i6 = 0; i6 < rsmd.getColumnCount(); ++i6) {
                    result5 = result5 + rsmd.getColumnName(i6 + 1) + ":" + rs.getString(i6 + 1) + ":";
                }
                result5 = result5 + "\n";
            }
            rs.close();
            rs = this.stmnt.executeQuery("SELECT A, B, A \"aliasA\", B \"aliasB\" FROM T;");
            rsmd = rs.getMetaData();
            while (rs.next()) {
                for (int i7 = 0; i7 < rsmd.getColumnCount(); ++i7) {
                    result5 = result5 + rsmd.getColumnLabel(i7 + 1) + ":" + rs.getString(i7 + 1) + ":";
                }
                result5 = result5 + "\n";
            }
            rsmd.isAutoIncrement(1);
            rsmd.isCaseSensitive(1);
            rsmd.isCurrency(1);
            rsmd.isDefinitelyWritable(1);
            rsmd.isNullable(1);
            rsmd.isReadOnly(1);
            rsmd.isSearchable(1);
            rsmd.isSigned(1);
            rsmd.isWritable(1);
            rs.close();
            System.out.println(result5);
        }
        catch (SQLException e) {
            TestSql.fail((String)e.getMessage());
        }
        TestSql.assertEquals((String)result1, (String)result2);
        TestSql.assertEquals((String)result3, (String)result4);
    }

    public void testDoubleNaN() {
        double value = 0.0;
        boolean wasEqual = false;
        String message = "DB operation completed";
        String ddl1 = "DROP TABLE t1 IF EXISTS;CREATE TABLE t1 ( d DECIMAL, f DOUBLE, l BIGINT, i INTEGER, s SMALLINT, t TINYINT, dt DATE DEFAULT 'CURRENT_DATE', ti TIME DEFAULT 'CURRENT_TIME', ts TIMESTAMP DEFAULT 'CURRENT_TIMESTAMP' );";
        try {
            int max;
            this.stmnt.execute(ddl1);
            PreparedStatement ps = this.cConnection.prepareStatement("INSERT INTO t1 (d,f,l,i,s,t,dt,ti,ts) VALUES (?,?,?,?,?,?,?,?,?)");
            ps.setString(1, "0.2");
            ps.setDouble(2, 0.2);
            ps.setLong(3, Long.MAX_VALUE);
            ps.setInt(4, Integer.MAX_VALUE);
            ps.setInt(5, Short.MAX_VALUE);
            ps.setInt(6, 0);
            ps.setDate(7, new Date(System.currentTimeMillis()));
            ps.setTime(8, new Time(System.currentTimeMillis()));
            ps.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
            ps.execute();
            ps.setInt(1, 0);
            ps.setDouble(2, Double.NaN);
            ps.setLong(3, Long.MIN_VALUE);
            ps.setInt(4, Integer.MIN_VALUE);
            ps.setInt(5, Short.MIN_VALUE);
            ps.setInt(6, 0);
            ps.setTimestamp(7, new Timestamp(System.currentTimeMillis() + 1L));
            ps.setTime(8, new Time(System.currentTimeMillis() + 1L));
            ps.setDate(9, new Date(System.currentTimeMillis() + 1L));
            ps.execute();
            ps.setInt(1, 0);
            ps.setDouble(2, Double.POSITIVE_INFINITY);
            ps.setInt(4, Integer.MIN_VALUE);
            ps.setObject(5, (Object)new Short(2), 5);
            ps.setObject(6, (Object)new Integer(2), -6);
            ps.setObject(7, new Date(System.currentTimeMillis() + 2L));
            ps.setObject(8, new Time(System.currentTimeMillis() + 2L));
            ps.setObject(9, new Timestamp(System.currentTimeMillis() + 2L));
            ps.execute();
            ResultSet rs = this.stmnt.executeQuery("SELECT d, f, l, i, s*2, t FROM t1");
            boolean result = rs.next();
            value = rs.getDouble(2);
            int integerValue = rs.getInt(4);
            if (rs.next()) {
                value = rs.getDouble(2);
                wasEqual = Double.isNaN(value);
                integerValue = rs.getInt(4);
            }
            if ((rs = this.stmnt.executeQuery("SELECT MAX(i) FROM t1")).next()) {
                max = rs.getInt(1);
                System.out.println("Max value for i: " + max);
            }
            rs = this.stmnt.executeQuery("CREATE TABLE cdType (ID INTEGER NOT NULL, name VARCHAR(50), PRIMARY KEY(ID))");
            rs = this.stmnt.executeQuery("SELECT MAX(ID) FROM cdType");
            if (rs.next()) {
                max = rs.getInt(1);
                System.out.println("Max value for ID: " + max);
            } else {
                System.out.println("Max value for ID not returned");
            }
            this.stmnt.executeUpdate("INSERT INTO cdType VALUES (10,'Test String');");
            try {
                this.stmnt.executeUpdate("INSERT INTO cdType VALUES (10,'Test String');");
            }
            catch (SQLException e1) {
                this.stmnt.execute("ROLLBACK");
                this.cConnection.rollback();
            }
        }
        catch (SQLException e) {
            TestSql.fail((String)e.getMessage());
        }
        TestSql.assertEquals((boolean)true, (boolean)wasEqual);
    }

    protected void tearDown() {
        try {
            this.cConnection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("TestSql.tearDown() error: " + e.getMessage());
        }
    }

    public static void main(String[] argv) {
        TestResult result = new TestResult();
        TestSql testA = new TestSql("testMetaData");
        TestSql testB = new TestSql("testDoubleNaN");
        testA.run(result);
        testB.run(result);
        System.out.println("TestSql error count: " + result.failureCount());
    }
}

