/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class TestSqlPersistent
extends TestCase {
    String url = "jdbc:hsqldb:/hsql/test/testpersistent";
    String user;
    String password;
    Statement sStatement;
    Connection cConnection;

    public TestSqlPersistent(String name) {
        super(name);
    }

    protected void setUp() {
        this.user = "sa";
        this.password = "";
        this.sStatement = null;
        this.cConnection = null;
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.cConnection = DriverManager.getConnection(this.url, this.user, this.password);
            this.sStatement = this.cConnection.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("TestSql.setUp() error: " + e.getMessage());
        }
    }

    public void testInsertObject() {
        Object stringValue = null;
        Object integerValue = null;
        Double[] arrayValue = null;
        byte[] bytearrayValue = null;
        Object stringValueResult = null;
        Object integerValueResult = null;
        Object arrayValueResult = null;
        boolean wasNull = false;
        String message = "DB operation completed";
        try {
            int c;
            String sqlString = "DROP TABLE PREFERENCE IF EXISTS;CREATE CACHED TABLE PREFERENCE (User_Id INTEGER NOT NULL, Pref_Name VARCHAR(30) NOT NULL, Pref_Value OBJECT NOT NULL, DateCreated DATETIME DEFAULT 'NOW' NOT NULL, PRIMARY KEY(User_Id, Pref_Name) )";
            this.sStatement.execute(sqlString);
            sqlString = "INSERT INTO PREFERENCE (User_Id,Pref_Name,Pref_Value) VALUES (?,?,?)";
            PreparedStatement ps = this.cConnection.prepareStatement(sqlString);
            stringValue = "String Value for Preference 1";
            integerValue = new Integer(1000);
            arrayValue = new Double[]{new Double(1.0), new Double(Double.NaN), new Double(Double.NEGATIVE_INFINITY), new Double(Double.POSITIVE_INFINITY)};
            bytearrayValue = new byte[]{1, 2, 3, 4, 5, 6};
            ps.setInt(1, 1);
            ps.setString(2, "String Type Object 1");
            ps.setObject(3, stringValue, 1111);
            ps.execute();
            ps.setInt(1, 2);
            ps.setString(2, "Integer Type Object 2");
            ps.setObject(3, integerValue);
            ps.execute();
            ps.setInt(1, 3);
            ps.setString(2, "Array Type Object 3");
            ps.setCharacterStream(2, (Reader)new StringReader("Array Type Object 3"), 19);
            ps.setObject(3, arrayValue);
            ps.execute();
            ps.setInt(1, 3);
            ps.setString(2, "byte Array Type Object 3");
            ps.setCharacterStream(2, (Reader)new StringReader("byte Array Type Object 3"), 19);
            ps.setObject(3, (Object)bytearrayValue, 1111);
            ps.execute();
            ResultSet rs = this.sStatement.executeQuery("SELECT * FROM PREFERENCE");
            boolean result = rs.next();
            String str = rs.getString(2);
            System.out.println(str);
            InputStream is = rs.getUnicodeStream(2);
            while ((c = is.read()) > -1) {
                c = is.read();
                System.out.print((char)c);
            }
            System.out.println();
            is = rs.getAsciiStream(2);
            while ((c = is.read()) > -1) {
                System.out.print((char)c);
            }
            System.out.println();
            Reader re = rs.getCharacterStream(2);
            while ((c = re.read()) > -1) {
                System.out.print((char)c);
            }
            stringValueResult = rs.getObject(3);
            rs.next();
            integerValueResult = rs.getObject(3);
            rs.next();
            arrayValueResult = rs.getObject(3);
            wasNull = rs.wasNull();
            String castStringValue = (String)stringValueResult;
            Integer castIntegerValue = (Integer)integerValueResult;
            Double[] castDoubleArrayValue = (Double[])arrayValueResult;
            sqlString = "DELETE FROM PREFERENCE WHERE user_id = ?";
            PreparedStatement st = this.cConnection.prepareStatement(sqlString);
            st.setString(1, "2");
            int ret = st.executeUpdate();
            st.close();
            st = this.cConnection.prepareStatement("SELECT user_id FROM PREFERENCE WHERE user_id=?");
            st.setString(1, "2");
            rs = st.executeQuery();
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            // empty catch block
        }
        boolean success = stringValue.equals(stringValueResult) && integerValue.equals(integerValueResult) && Arrays.equals((Object[])arrayValue, (Object[])((Double[])arrayValueResult));
        TestSqlPersistent.assertEquals((boolean)true, (boolean)success);
    }

    protected void tearDown() {
        try {
            this.cConnection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("TestSql.tearDown() error: " + e.getMessage());
        }
    }

    public static void main(String[] argv) {
        TestResult result = new TestResult();
        TestSqlPersistent testC = new TestSqlPersistent("testInsertObject");
        testC.run(result);
        System.out.println("TestSqlPersistent error count: " + result.failureCount());
    }
}

