/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;

public class TestSubselect
extends TestCase {
    private static final String databaseDriver = "org.hsqldb.jdbcDriver";
    private static final String databaseURL = "jdbc:hsqldb:../test/subselect";
    private static final String databaseUser = "sa";
    private static final String databasePassword = "";
    public static final String datasetPath = "../test/dataset-subselect.xml";
    private Connection jdbcConnection;

    public TestSubselect(String s) {
        super(s);
    }

    protected static Connection getJDBCConnection() throws SQLException {
        return DriverManager.getConnection(databaseURL, databaseUser, databasePassword);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Class.forName(databaseDriver);
        this.jdbcConnection = TestSubselect.getJDBCConnection();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.jdbcConnection.close();
        this.jdbcConnection = null;
    }

    private static void compareResults(String sql, String[] expected, Connection jdbcConnection2) throws SQLException {
        Statement statement = jdbcConnection2.createStatement();
        ResultSet results = statement.executeQuery(sql);
        int rowCount = 0;
        while (results.next()) {
            TestSubselect.assertTrue((String)("Statement <" + sql + "> returned too many rows."), (rowCount < expected.length ? 1 : 0) != 0);
            TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong value."), (String)expected[rowCount], (String)results.getString(1));
            ++rowCount;
        }
        TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong number of rows."), (int)expected.length, (int)rowCount);
    }

    public void testSimpleJoin() throws SQLException {
        String sql = "select trees.id, trees.name, sizes.val, fruits.name, colors.val from trees, sizes, fruits, colors where trees.size_id = sizes.id and trees.fruit_id = fruits.id and fruits.color_id = colors.id order by 1";
        int expectedRows = 5;
        String[] expectedTrees = new String[]{"small golden delicious tree", "large macintosh tree", "large red delicious tree", "small red delicious tree", "medium granny smith tree"};
        String[] expectedSizes = new String[]{"small", "large", "large", "small", "medium"};
        String[] expectedFruits = new String[]{"golden delicious", "macintosh", "red delicious", "red delicious", "granny smith"};
        String[] expectedColors = new String[]{"green", "red", "red", "red", "green"};
        Statement statement = this.jdbcConnection.createStatement();
        ResultSet results = statement.executeQuery(sql);
        String[] trees = new String[expectedRows];
        String[] fruits = new String[expectedRows];
        String[] sizes = new String[expectedRows];
        String[] colors = new String[expectedRows];
        int rowCount = 0;
        while (results.next()) {
            TestSubselect.assertTrue((String)("Statement <" + sql + "> returned too many rows."), (rowCount <= expectedRows ? 1 : 0) != 0);
            TestSubselect.assertEquals((String)("Statement <" + sql + "> returned rows in wrong order."), (int)(1 + rowCount), (int)results.getInt(1));
            TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong value."), (String)expectedTrees[rowCount], (String)results.getString(2));
            TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong value."), (String)expectedSizes[rowCount], (String)results.getString(3));
            TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong value."), (String)expectedFruits[rowCount], (String)results.getString(4));
            TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong value."), (String)expectedColors[rowCount], (String)results.getString(5));
            ++rowCount;
        }
        TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong number of rows."), (int)expectedRows, (int)rowCount);
    }

    public void testWhereClausesColliding() throws SQLException {
        String sql = "select name from fruits where id in (select fruit_id from trees where id < 3) order by name";
        String[] expected = new String[]{"golden delicious", "macintosh"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testWhereClausesCollidingWithAliases() throws SQLException {
        String sql = "select a.name from fruits a where a.id in (select b.fruit_id from trees b where b.id < 3) order by name";
        String[] expected = new String[]{"golden delicious", "macintosh"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testHiddenCollision() throws SQLException {
        String sql = "select name from fruits where id in (select fruit_id from trees) order by name";
        String[] expected = new String[]{"golden delicious", "granny smith", "macintosh", "red delicious"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testHiddenCollisionWithAliases() throws SQLException {
        String sql = "select a.name from fruits a where a.id in (select b.fruit_id from trees b) order by a.name";
        String[] expected = new String[]{"golden delicious", "granny smith", "macintosh", "red delicious"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testWhereSelectColliding() throws SQLException {
        String sql = "select val from colors where id in (select id from trees where fruit_id = 3) order by val";
        String[] expected = new String[]{"indigo", "orange"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testWhereSelectCollidingWithAliases() throws SQLException {
        String sql = "select a.val from colors a where a.id in (select b.id from trees b where b.fruit_id = 3) order by a.val";
        String[] expected = new String[]{"indigo", "orange"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testSameTable() throws SQLException {
        String sql = "select name from trees where id in (select id from trees where fruit_id = 3) order by name";
        String[] expected = new String[]{"large red delicious tree", "small red delicious tree"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testSameTableWithAliases() throws SQLException {
        String sql = "select a.name from trees a where a.id in (select b.id from trees b where b.fruit_id = 3) order by a.name";
        String[] expected = new String[]{"large red delicious tree", "small red delicious tree"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testSameTableWithJoin() throws SQLException {
        String sql = "select sizes.val from trees, sizes where sizes.id = trees.size_id and trees.id in (select id from trees where fruit_id = 3) order by sizes.val";
        String[] expected = new String[]{"large", "small"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testAndedSubselects() throws SQLException {
        String sql = "select name from trees where size_id in (select id from sizes where val = 'large') and fruit_id in (select id from fruits where color_id = 1) order by name";
        String[] expected = new String[]{"large macintosh tree", "large red delicious tree"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testNestedSubselects() throws SQLException {
        String sql = "select name from trees where fruit_id in (select id from fruits where color_id in (select id from colors where val = 'red')) order by name";
        String[] expected = new String[]{"large macintosh tree", "large red delicious tree", "small red delicious tree"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testNotIn() throws SQLException {
        String sql = "select name from fruits where id not in (select fruit_id from trees) order by name";
        String[] expected = new String[]{"tangerine"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testNotInSameTableAndColumn() throws SQLException {
        String sql = "select name from fruits where id not in (select id from fruits where color_id > 1 ) order by name";
        String[] expected = new String[]{"macintosh", "red delicious"};
        TestSubselect.compareResults(sql, expected, this.jdbcConnection);
    }

    public void testAliasScope() throws SQLException {
        String sql = "select a.val, b.name from sizes a, trees b where a.id = b.size_id and b.id in (select a.id from trees a, fruits b where a.fruit_id = b.id and b.name='red delicious') order by a.val";
        String[] expectedSizes = new String[]{"large", "small"};
        String[] expectedTrees = new String[]{"large red delicious tree", "small red delicious tree"};
        TestSubselect.assertEquals((String)"Programmer error: expected arrays should be of equal length.", (int)expectedSizes.length, (int)expectedTrees.length);
        Statement statement = this.jdbcConnection.createStatement();
        ResultSet results = statement.executeQuery(sql);
        int rowCount = 0;
        while (results.next()) {
            TestSubselect.assertTrue((String)("Statement <" + sql + "> returned too many rows."), (rowCount < expectedSizes.length ? 1 : 0) != 0);
            TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong value."), (String)expectedSizes[rowCount], (String)results.getString(1));
            TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong value."), (String)expectedTrees[rowCount], (String)results.getString(2));
            ++rowCount;
        }
        TestSubselect.assertEquals((String)("Statement <" + sql + "> returned wrong number of rows."), (int)expectedSizes.length, (int)rowCount);
    }

    public static void main(String[] args) throws IOException {
    }
}

