/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import com.kingdee.eas.cp.hsqldb.util.CommonSwing;
import com.kingdee.eas.cp.hsqldb.util.ConnectionDialogCommon;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class ConnectionDialogSwing
extends JDialog
implements ActionListener,
ItemListener {
    private Connection mConnection;
    private JTextField mDriver;
    private JTextField mURL;
    private JTextField mUser;
    private JTextField mError;
    private JPasswordField mPassword;
    private String[][] connTypes;

    public static Connection createConnection(String driver, String url, String user, String password) throws Exception {
        Class.forName(driver).newInstance();
        return DriverManager.getConnection(url, user, password);
    }

    ConnectionDialogSwing(JFrame owner, String title) {
        super(owner, title, true);
    }

    private void create() {
        CommonSwing.setDefaultColor();
        Box main = Box.createHorizontalBox();
        Box labels = Box.createVerticalBox();
        Box controls = Box.createVerticalBox();
        Box buttons = Box.createHorizontalBox();
        Box whole = Box.createVerticalBox();
        Box status = Box.createHorizontalBox();
        main.add(Box.createHorizontalGlue());
        main.add(labels);
        main.add(Box.createHorizontalStrut(10));
        main.add(Box.createHorizontalGlue());
        main.add(controls);
        main.add(Box.createHorizontalGlue());
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(main);
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(buttons);
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(status);
        whole.add(Box.createVerticalStrut(10));
        whole.add(Box.createVerticalGlue());
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Type:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Driver"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("URL"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("User:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Password:"));
        labels.add(Box.createVerticalGlue());
        labels.add(Box.createVerticalStrut(10));
        controls.add(Box.createVerticalGlue());
        JComboBox<String> types = new JComboBox<String>();
        this.connTypes = ConnectionDialogCommon.getTypes();
        for (int i = 0; i < this.connTypes.length; ++i) {
            types.addItem(this.connTypes[i][0]);
        }
        types.addItemListener(this);
        controls.add(types);
        controls.add(Box.createVerticalGlue());
        this.mDriver = new JTextField(this.connTypes[0][1]);
        this.mDriver.addActionListener(this);
        controls.add(this.mDriver);
        this.mURL = new JTextField(this.connTypes[0][2]);
        this.mURL.addActionListener(this);
        controls.add(this.mURL);
        controls.add(Box.createVerticalGlue());
        this.mUser = new JTextField("sa");
        this.mUser.addActionListener(this);
        controls.add(this.mUser);
        controls.add(Box.createVerticalGlue());
        this.mPassword = new JPasswordField("");
        this.mPassword.addActionListener(this);
        controls.add(this.mPassword);
        controls.add(Box.createVerticalGlue());
        controls.add(Box.createVerticalStrut(10));
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(10));
        JButton b = new JButton("Ok");
        b.setActionCommand("ConnectOk");
        b.addActionListener(this);
        buttons.add(b);
        this.getRootPane().setDefaultButton(b);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(20));
        b = new JButton("Cancel");
        b.setActionCommand("ConnectCancel");
        b.addActionListener(this);
        buttons.add(b);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(10));
        this.mError = new JTextField("");
        this.mError.setEditable(false);
        status.add(Box.createHorizontalGlue());
        status.add(this.mError);
        status.add(Box.createHorizontalGlue());
        JPanel jp = new JPanel();
        jp.setBorder(new EmptyBorder(10, 10, 10, 10));
        jp.add("Center", whole);
        this.getContentPane().add("Center", jp);
        this.doLayout();
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        if (d.width >= 640) {
            this.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else {
            this.setLocation(0, 0);
            this.setSize(d);
        }
        this.show();
    }

    public static Connection createConnection(JFrame owner, String title) {
        ConnectionDialogSwing dialog = new ConnectionDialogSwing(owner, title);
        dialog.create();
        return dialog.mConnection;
    }

    private static JLabel createLabel(String s) {
        JLabel l = new JLabel(s);
        return l;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s.equals("ConnectOk") || ev.getSource() instanceof JTextField) {
            try {
                this.mConnection = ConnectionDialogSwing.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), new String(this.mPassword.getPassword()));
                this.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mError.setText(e.toString());
            }
        } else if (s.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String s = (String)e.getItem();
        for (int i = 0; i < this.connTypes.length; ++i) {
            if (!s.equals(this.connTypes[i][0])) continue;
            this.mDriver.setText(this.connTypes[i][1]);
            this.mURL.setText(this.connTypes[i][2]);
        }
    }
}

