/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import com.kingdee.eas.cp.hsqldb.util.CommonSwing;
import com.kingdee.eas.cp.hsqldb.util.ConnectionDialogSwing;
import com.kingdee.eas.cp.hsqldb.util.DatabaseManagerCommon;
import com.kingdee.eas.cp.hsqldb.util.GridSwing;
import com.kingdee.eas.cp.hsqldb.util.Transfer;
import com.kingdee.eas.cp.hsqldb.util.jdbcSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class DatabaseManagerSwing
extends JApplet
implements ActionListener,
WindowListener,
KeyListener {
    static final String NL = System.getProperty("line.separator");
    static int iMaxRecent = 24;
    Connection cConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    JMenu mRecent;
    String[] sRecent;
    int iRecent;
    JTextArea txtCommand;
    JScrollPane txtCommandScroll;
    JButton butExecute;
    JTree tTree;
    JScrollPane tScrollPane;
    DefaultTreeModel treeModel;
    DefaultMutableTreeNode rootNode;
    JPanel pResult;
    long lTime;
    int iResult;
    GridSwing gResult;
    JTable gResultTable;
    JScrollPane gScrollPane;
    JTextArea txtResult;
    JScrollPane txtResultScroll;
    JSplitPane nsSplitPane;
    JSplitPane ewSplitPane;
    boolean bHelp;
    JFrame fMain;
    String ifHuge = "";
    JToolBar jtoolbar;
    static String defDriver = "org.hsqldb.jdbcDriver";
    static String defURL = "jdbc:hsqldb:.";
    static String defUser = "sa";
    static String defPassword = "";
    static String defScript;
    static String defDirectory;

    @Override
    public void init() {
        DatabaseManagerSwing m = new DatabaseManagerSwing();
        m.main();
        try {
            m.connect(ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword));
            m.insertTestData();
            m.refreshTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] arg) {
        System.getProperties().put("sun.java2d.noddraw", "true");
        boolean autoConnect = false;
        for (int i = 0; i < arg.length; ++i) {
            String lowerArg = arg[i].toLowerCase();
            if (++i == arg.length) {
                DatabaseManagerSwing.showUsage();
                return;
            }
            if (lowerArg.equals("-driver")) {
                defDriver = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-url")) {
                defURL = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-user")) {
                defUser = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-password")) {
                defPassword = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-dir")) {
                defDirectory = arg[i];
                continue;
            }
            if (lowerArg.equals("-script")) {
                defScript = arg[i];
                continue;
            }
            DatabaseManagerSwing.showUsage();
            return;
        }
        DatabaseManagerSwing m = new DatabaseManagerSwing();
        m.main();
        Connection c = null;
        try {
            c = autoConnect ? ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword) : ConnectionDialogSwing.createConnection(m.fMain, "Connect");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (c == null) {
            return;
        }
        m.connect(c);
    }

    private void connect(Connection c) {
        if (c == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.cConn = c;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
            this.refreshTree();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManagerSwing [-options]\nwhere options include:\n    -driver <classname>  jdbc driver class\n    -url <name>          jdbc url\n    -user <name>         username used for connection\n    -password <password> password for this user\n    -dir <path>          default directory\n    -script <file>       reads from script file\n");
    }

    private void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.refreshTree();
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            this.refreshTree();
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    void main() {
        CommonSwing.setDefaultColor();
        this.fMain = new JFrame("HSQL Database Manager");
        this.fMain.getContentPane().add((Component)this.createToolBar(), "North");
        this.fMain.setIconImage(CommonSwing.getIcon());
        this.fMain.addWindowListener(this);
        JMenuBar bar = new JMenuBar();
        String[] fitems = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(bar, "File", fitems);
        String[] vitems = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text"};
        this.addMenu(bar, "View", vitems);
        String[] sitems = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "---", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-CHECKPOINT", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(bar, "Command", sitems);
        this.mRecent = new JMenu("Recent");
        bar.add(this.mRecent);
        String[] soptions = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data"};
        this.addMenu(bar, "Options", soptions);
        String[] stools = new String[]{"-Dump", "-Restore", "-Transfer"};
        this.addMenu(bar, "Tools", stools);
        this.fMain.setJMenuBar(bar);
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.fMain.getSize();
        if (d.width >= 640) {
            this.fMain.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else {
            this.fMain.setLocation(0, 0);
            this.fMain.setSize(d);
        }
        this.fMain.show();
        if (defScript != null) {
            if (defDirectory != null) {
                defScript = defDirectory + File.separator + defScript;
            }
            StringBuffer buf = new StringBuffer();
            this.ifHuge = DatabaseManagerCommon.readFile(defScript);
            if (4096 <= this.ifHuge.length()) {
                buf.append("This huge file cannot be edited. Please execute\n");
                this.txtCommand.setText(buf.toString());
            } else {
                this.txtCommand.setText(this.ifHuge);
            }
        }
        this.txtCommand.requestFocus();
    }

    private void addMenu(JMenuBar b, String name, String[] items) {
        JMenu menu = new JMenu(name);
        this.addMenuItems(menu, items);
        b.add(menu);
    }

    private void addMenuItems(JMenu f, String[] m) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        for (int i = 0; i < m.length; ++i) {
            if (m[i].equals("--")) {
                f.addSeparator();
                continue;
            }
            if (m[i].equals("---")) {
                if (d.width >= 640) {
                    f.addSeparator();
                    continue;
                }
                return;
            }
            JMenuItem item = new JMenuItem(m[i].substring(1));
            char c = m[i].charAt(0);
            if (c != '-') {
                item.setMnemonic(c);
            }
            item.addActionListener(this);
            f.add(item);
        }
    }

    @Override
    public void keyPressed(KeyEvent k) {
    }

    @Override
    public void keyReleased(KeyEvent k) {
    }

    @Override
    public void keyTyped(KeyEvent k) {
        if (k.getKeyChar() == '\n' && k.isControlDown()) {
            k.consume();
            this.execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s == null && ev.getSource() instanceof JMenuItem) {
            s = ((JMenuItem)ev.getSource()).getText();
        }
        if (s.equals("Exit")) {
            this.windowClosing(null);
        } else if (s.equals("Transfer")) {
            Transfer.work(null);
        } else if (s.equals("Dump")) {
            Transfer.work(new String[]{"-d"});
        } else if (s.equals("Restore")) {
            Transfer.work(new String[]{"-r"});
        } else if (s.equals("Logging on")) {
            jdbcSystem.setLogToSystem(true);
        } else if (s.equals("Logging off")) {
            jdbcSystem.setLogToSystem(false);
        } else if (s.equals("Refresh Tree")) {
            this.refreshTree();
        } else if (s.startsWith("#")) {
            int i = Integer.parseInt(s.substring(1));
            this.txtCommand.setText(this.sRecent[i]);
        } else if (s.equals("Connect...")) {
            this.connect(ConnectionDialogSwing.createConnection(this.fMain, "Connect"));
            this.refreshTree();
        } else if (s.equals("Results in Grid")) {
            this.iResult = 0;
            this.pResult.removeAll();
            this.pResult.add((Component)this.gScrollPane, "Center");
            this.pResult.doLayout();
            this.gResult.fireTableChanged(null);
            this.pResult.repaint();
        } else if (s.equals("Open Script...")) {
            File file;
            int option;
            JFileChooser f = new JFileChooser(".");
            f.setDialogTitle("Open Script...");
            if (defDirectory != null) {
                f.setCurrentDirectory(new File(defDirectory));
            }
            if ((option = f.showOpenDialog(this.fMain)) == 0 && (file = f.getSelectedFile()) != null) {
                StringBuffer buf = new StringBuffer();
                this.ifHuge = DatabaseManagerCommon.readFile(file.getAbsolutePath());
                if (4096 <= this.ifHuge.length()) {
                    buf.append("This huge file cannot be edited. Please execute\n");
                    this.txtCommand.setText(buf.toString());
                } else {
                    this.txtCommand.setText(this.ifHuge);
                }
            }
        } else if (s.equals("Save Script...")) {
            File file;
            int option;
            JFileChooser f = new JFileChooser(".");
            f.setDialogTitle("Save Script");
            if (defDirectory != null) {
                f.setCurrentDirectory(new File(defDirectory));
            }
            if ((option = f.showSaveDialog(this.fMain)) == 0 && (file = f.getSelectedFile()) != null) {
                DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtCommand.getText());
            }
        } else if (s.equals("Save Result...")) {
            File file;
            int option;
            JFileChooser f = new JFileChooser(".");
            f.setDialogTitle("Save Result...");
            if (defDirectory != null) {
                f.setCurrentDirectory(new File(defDirectory));
            }
            if ((option = f.showSaveDialog(this.fMain)) == 0 && (file = f.getSelectedFile()) != null) {
                this.showResultInText();
                DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtResult.getText());
            }
        } else if (s.equals("Results in Text")) {
            this.iResult = 1;
            this.pResult.removeAll();
            this.pResult.add((Component)this.txtResultScroll, "Center");
            this.pResult.doLayout();
            this.showResultInText();
            this.pResult.repaint();
        } else if (s.equals("AutoCommit on")) {
            try {
                this.cConn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        } else if (s.equals("AutoCommit off")) {
            try {
                this.cConn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {}
        } else if (s.equals("Commit")) {
            try {
                this.cConn.commit();
            }
            catch (SQLException sQLException) {}
        } else if (s.equals("Insert test data")) {
            this.insertTestData();
        } else if (s.equals("Rollback")) {
            try {
                this.cConn.rollback();
            }
            catch (SQLException sQLException) {}
        } else if (s.equals("Disable MaxRows")) {
            try {
                this.sStatement.setMaxRows(0);
            }
            catch (SQLException sQLException) {}
        } else if (s.equals("Set MaxRows to 100")) {
            try {
                this.sStatement.setMaxRows(100);
            }
            catch (SQLException sQLException) {}
        } else if (s.equals("SELECT")) {
            this.showHelp(DatabaseManagerCommon.selectHelp);
        } else if (s.equals("INSERT")) {
            this.showHelp(DatabaseManagerCommon.insertHelp);
        } else if (s.equals("UPDATE")) {
            this.showHelp(DatabaseManagerCommon.updateHelp);
        } else if (s.equals("DELETE")) {
            this.showHelp(DatabaseManagerCommon.deleteHelp);
        } else if (s.equals("CREATE TABLE")) {
            this.showHelp(DatabaseManagerCommon.createTableHelp);
        } else if (s.equals("DROP TABLE")) {
            this.showHelp(DatabaseManagerCommon.dropTableHelp);
        } else if (s.equals("CREATE INDEX")) {
            this.showHelp(DatabaseManagerCommon.createIndexHelp);
        } else if (s.equals("DROP INDEX")) {
            this.showHelp(DatabaseManagerCommon.dropIndexHelp);
        } else if (s.equals("CHECKPOINT")) {
            this.showHelp(DatabaseManagerCommon.checkpointHelp);
        } else if (s.equals("SCRIPT")) {
            this.showHelp(DatabaseManagerCommon.scriptHelp);
        } else if (s.equals("SHUTDOWN")) {
            this.showHelp(DatabaseManagerCommon.shutdownHelp);
        } else if (s.equals("SET")) {
            this.showHelp(DatabaseManagerCommon.setHelp);
        } else if (s.equals("Test Script")) {
            this.showHelp(DatabaseManagerCommon.testHelp);
        }
    }

    private void showHelp(String[] help) {
        this.txtCommand.setText(help[0]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.txtResult.setText(help[1]);
        this.pResult.repaint();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(help[0].length());
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain.dispose();
        System.exit(0);
    }

    private void clear() {
        this.ifHuge = "";
        this.txtCommand.setText(this.ifHuge);
    }

    private void execute() {
        this.gResult.clear();
        String sCmd = null;
        sCmd = 4096 <= this.ifHuge.length() ? this.ifHuge : this.txtCommand.getText();
        if (sCmd.startsWith("-->>>TEST<<<--")) {
            this.testPerformance();
            return;
        }
        String[] g = new String[1];
        try {
            this.lTime = System.currentTimeMillis();
            this.sStatement.execute(sCmd);
            int r = this.sStatement.getUpdateCount();
            if (r == -1) {
                this.formatResultSet(this.sStatement.getResultSet());
            } else {
                g[0] = "update count";
                this.gResult.setHead(g);
                g[0] = "" + r;
                this.gResult.addRow(g);
            }
            this.lTime = System.currentTimeMillis() - this.lTime;
            this.addToRecent(this.txtCommand.getText());
            this.gResult.fireTableChanged(null);
        }
        catch (SQLException e) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            g[0] = "SQL Error";
            this.gResult.setHead(g);
            String s = e.getMessage();
            s = s + " / Error Code: " + e.getErrorCode();
            g[0] = s = s + " / State: " + e.getSQLState();
            this.gResult.addRow(g);
            this.gResult.fireTableChanged(null);
        }
        this.updateResult();
        System.gc();
    }

    private void updateResult() {
        if (this.iResult == 0) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add((Component)this.gScrollPane, "Center");
                this.pResult.doLayout();
                this.gResult.fireTableChanged(null);
                this.pResult.repaint();
                this.bHelp = false;
            }
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    private void formatResultSet(ResultSet r) {
        if (r == null) {
            String[] g = new String[]{"Result"};
            this.gResult.setHead(g);
            g[0] = "(empty)";
            this.gResult.addRow(g);
            return;
        }
        try {
            int i;
            ResultSetMetaData m = r.getMetaData();
            int col = m.getColumnCount();
            String[] h = new String[col];
            for (i = 1; i <= col; ++i) {
                h[i - 1] = m.getColumnLabel(i);
            }
            this.gResult.setHead(h);
            while (r.next()) {
                for (i = 1; i <= col; ++i) {
                    h[i - 1] = r.getString(i);
                    if (!r.wasNull()) continue;
                    h[i - 1] = "(null)";
                }
                this.gResult.addRow(h);
            }
            r.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void testPerformance() {
        String all = this.txtCommand.getText();
        StringBuffer b = new StringBuffer();
        long total = 0L;
        for (int i = 0; i < all.length(); ++i) {
            char c = all.charAt(i);
            if (c == '\n') continue;
            b.append(c);
        }
        all = b.toString();
        String[] g = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(g);
        int max = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!all.equals("")) {
            String sql;
            int i = all.indexOf(59);
            if (i != -1) {
                sql = all.substring(0, i);
                all = all.substring(i + 1);
            } else {
                sql = all;
                all = "";
            }
            if (sql.startsWith("--#")) {
                max = Integer.parseInt(sql.substring(3));
                continue;
            }
            if (sql.startsWith("--")) continue;
            g[2] = sql;
            long l = 0L;
            try {
                l = DatabaseManagerCommon.testStatement(this.sStatement, sql, max);
                total += l;
                g[0] = "" + l;
                g[1] = "" + max;
                g[3] = "";
            }
            catch (SQLException e) {
                g[1] = "n/a";
                g[0] = "n/a";
                g[3] = e.toString();
            }
            this.gResult.addRow(g);
            System.out.println(l + " ms : " + sql);
        }
        g[0] = "" + total;
        g[1] = "total";
        g[2] = "";
        this.gResult.addRow(g);
        this.lTime = System.currentTimeMillis() - this.lTime;
        this.updateResult();
    }

    private void showResultInText() {
        int i;
        int l;
        String[] row;
        int i2;
        String[] col = this.gResult.getHead();
        int width = col.length;
        int[] size = new int[width];
        Vector data = this.gResult.getData();
        int height = data.size();
        for (i2 = 0; i2 < width; ++i2) {
            size[i2] = col[i2].length();
        }
        for (i2 = 0; i2 < height; ++i2) {
            row = (String[])data.elementAt(i2);
            for (int j = 0; j < width; ++j) {
                l = row[j].length();
                if (l <= size[j]) continue;
                size[j] = l;
            }
        }
        StringBuffer b = new StringBuffer();
        for (i = 0; i < width; ++i) {
            b.append(col[i]);
            for (l = col[i].length(); l <= size[i]; ++l) {
                b.append(' ');
            }
        }
        b.append(NL);
        for (i = 0; i < width; ++i) {
            for (l = 0; l < size[i]; ++l) {
                b.append('-');
            }
            b.append(' ');
        }
        b.append(NL);
        for (i = 0; i < height; ++i) {
            row = (String[])data.elementAt(i);
            for (int j = 0; j < width; ++j) {
                b.append(row[j]);
                for (int l2 = row[j].length(); l2 <= size[j]; ++l2) {
                    b.append(' ');
                }
            }
            b.append(NL);
        }
        b.append(NL + height + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(b.toString());
    }

    private void addToRecent(String s) {
        for (int i = 0; i < iMaxRecent; ++i) {
            if (!s.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = s;
        if (s.length() > 43) {
            s = s.substring(0, 40) + "...";
        }
        JMenuItem item = new JMenuItem(s);
        item.setActionCommand("#" + this.iRecent);
        item.addActionListener(this);
        this.mRecent.insert(item, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    private void initGUI() {
        JPanel pCommand = new JPanel();
        this.pResult = new JPanel();
        this.nsSplitPane = new JSplitPane(0, pCommand, this.pResult);
        pCommand.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font fFont = new Font("Dialog", 0, 12);
        this.txtCommand = new JTextArea(5, 40);
        this.txtCommand.setMargin(new Insets(5, 5, 5, 5));
        this.txtCommand.addKeyListener(this);
        this.txtCommandScroll = new JScrollPane(this.txtCommand);
        this.txtResult = new JTextArea(20, 40);
        this.txtResult.setMargin(new Insets(5, 5, 5, 5));
        this.txtResultScroll = new JScrollPane(this.txtResult);
        this.txtCommand.setFont(fFont);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        pCommand.add((Component)this.txtCommandScroll, "Center");
        this.gResult = new GridSwing();
        this.gResultTable = new JTable(this.gResult);
        this.gScrollPane = new JScrollPane(this.gResultTable);
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.rootNode = new DefaultMutableTreeNode("Connection");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tTree = new JTree(this.treeModel);
        this.tScrollPane = new JScrollPane(this.tTree);
        this.tScrollPane.setPreferredSize(new Dimension(120, 400));
        this.tScrollPane.setMinimumSize(new Dimension(70, 100));
        this.txtCommandScroll.setPreferredSize(new Dimension(360, 100));
        this.txtCommandScroll.setMinimumSize(new Dimension(180, 100));
        this.gScrollPane.setPreferredSize(new Dimension(460, 300));
        this.ewSplitPane = new JSplitPane(1, this.tScrollPane, this.nsSplitPane);
        this.fMain.getContentPane().add((Component)this.ewSplitPane, "Center");
        this.doLayout();
        this.fMain.pack();
    }

    private DefaultMutableTreeNode makeNode(Object userObject, MutableTreeNode parent) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(userObject);
        if (parent != null) {
            this.treeModel.insertNodeInto(node, parent, parent.getChildCount());
        }
        return node;
    }

    protected void refreshTree() {
        while (this.treeModel.getChildCount(this.rootNode) > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.treeModel.getChild(this.rootNode, 0);
            this.treeModel.removeNodeFromParent(child);
            child.removeAllChildren();
            child.removeFromParent();
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        try {
            this.rootNode.setUserObject(this.dMeta.getURL());
            String[] usertables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
            ResultSet result = this.dMeta.getTables(null, null, null, usertables);
            Vector<String> tables = new Vector<String>();
            Vector<String> remarks = new Vector<String>();
            while (result.next()) {
                tables.addElement(result.getString(3));
                remarks.addElement(result.getString(5));
            }
            result.close();
            for (int i = 0; i < tables.size(); ++i) {
                String name = (String)tables.elementAt(i);
                DefaultMutableTreeNode tableNode = this.makeNode(name, this.rootNode);
                ResultSet col = this.dMeta.getColumns(null, null, name, null);
                String remark = (String)remarks.elementAt(i);
                if (remark != null && !remark.trim().equals("")) {
                    this.makeNode(remark, tableNode);
                }
                while (col.next()) {
                    String c = col.getString(4);
                    DefaultMutableTreeNode columnNode = this.makeNode(c, tableNode);
                    String type = col.getString(6);
                    this.makeNode("Type: " + type, columnNode);
                    boolean nullable = col.getInt(11) != 0;
                    this.makeNode("Nullable: " + nullable, columnNode);
                }
                col.close();
                DefaultMutableTreeNode indexesNode = this.makeNode("Indices", tableNode);
                ResultSet ind = this.dMeta.getIndexInfo(null, null, name, false, false);
                String oldiname = null;
                while (ind.next()) {
                    DefaultMutableTreeNode indexNode = null;
                    boolean nonunique = ind.getBoolean(4);
                    String iname = ind.getString(6);
                    if (oldiname == null || !oldiname.equals(iname)) {
                        indexNode = this.makeNode(iname, indexesNode);
                        this.makeNode("Unique: " + !nonunique, indexNode);
                        oldiname = iname;
                    }
                    this.makeNode(ind.getString(9), indexNode);
                }
                ind.close();
            }
            DefaultMutableTreeNode propertiesNode = this.makeNode("Properties", this.rootNode);
            this.makeNode("User: " + this.dMeta.getUserName(), propertiesNode);
            this.makeNode("ReadOnly: " + this.cConn.isReadOnly(), propertiesNode);
            this.makeNode("AutoCommit: " + this.cConn.getAutoCommit(), propertiesNode);
            this.makeNode("Driver: " + this.dMeta.getDriverName(), propertiesNode);
            this.makeNode("Product: " + this.dMeta.getDatabaseProductName(), propertiesNode);
            this.makeNode("Version: " + this.dMeta.getDatabaseProductVersion(), propertiesNode);
        }
        catch (SQLException se) {
            DefaultMutableTreeNode propertiesNode = this.makeNode("Error getting metadata:", this.rootNode);
            this.makeNode(se.getMessage(), propertiesNode);
            this.makeNode(se.getSQLState(), propertiesNode);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
    }

    protected JToolBar createToolBar() {
        JToolBar jtoolbar = new JToolBar();
        jtoolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        JButton jbuttonClear = new JButton("Clear SQL Statement");
        jbuttonClear.setToolTipText("Clear SQL Statement");
        jbuttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                DatabaseManagerSwing.this.clear();
            }
        });
        JButton jbuttonExecute = new JButton("Execute SQL Statement");
        jbuttonExecute.setToolTipText("Execute SQL Statement");
        jbuttonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                DatabaseManagerSwing.this.execute();
            }
        });
        jtoolbar.addSeparator();
        jtoolbar.add(jbuttonClear);
        jtoolbar.addSeparator();
        jtoolbar.add(jbuttonExecute);
        jtoolbar.addSeparator();
        jbuttonClear.setAlignmentY(0.5f);
        jbuttonClear.setAlignmentX(0.5f);
        jbuttonExecute.setAlignmentY(0.5f);
        jbuttonExecute.setAlignmentX(0.5f);
        return jtoolbar;
    }
}

