/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import com.kingdee.eas.cp.hsqldb.HsqlProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class ShutdownServer {
    public static void main(String[] arg) {
        String p;
        String driver = "org.hsqldb.jdbcDriver";
        if (arg.length > 0 && (p = arg[0]) != null && p.startsWith("-?")) {
            ShutdownServer.printHelp();
            return;
        }
        HsqlProperties props = HsqlProperties.argArrayToProps(arg, "server");
        boolean webserver = props.isPropertyTrue("server.webserver", false);
        String defaulturl = webserver ? "jdbc:hsqldb:http://localhost" : "jdbc:hsqldb:hsql://localhost";
        int defaultport = webserver ? 80 : 9001;
        int port = props.getIntegerProperty("server.port", defaultport);
        String url = props.getProperty("server.url", defaulturl + ":" + port);
        String user = props.getProperty("server.user", "sa");
        String password = props.getProperty("server.password", "");
        String shutdownarg = props.getProperty("server.shutdownarg", "");
        try {
            Class.forName(driver);
            Connection connection = DriverManager.getConnection(url, user, password);
            Statement statement = connection.createStatement();
            statement.execute("SHUTDOWN " + shutdownarg);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(cnfe);
        }
        catch (SQLException sqle) {
            System.err.println(sqle);
        }
    }

    static void printHelp() {
        System.out.print("Usage: java ShutdownServer [-options]\nwhere options include:\n    -port <nr>               port where the server is listening\n    -user <name>             username of admin user\n    -password <value>        password of admin user\n    -webserver <true/false>  whether it's a web server\n    -url <value>             server url (overrides -webserver and -port options)\n    -shutdownarg <value>     IMMEDIATELY or COMPACT are allowed\nThe command line arguments override the default values.");
    }
}

