/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import com.kingdee.eas.cp.hsqldb.util.JDBCTypes;
import com.kingdee.eas.cp.hsqldb.util.Traceable;
import com.kingdee.eas.cp.hsqldb.util.TransferDb;
import com.kingdee.eas.cp.hsqldb.util.TransferTable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

class TransferHelper {
    protected TransferDb db;
    protected Traceable tracer;
    protected String sSchema;
    protected JDBCTypes JDBCT;
    private String quote;

    TransferHelper() {
        this.db = null;
        this.tracer = null;
        this.quote = "'";
        this.JDBCT = new JDBCTypes();
    }

    TransferHelper(TransferDb database, Traceable t, String q) {
        this.db = database;
        this.tracer = t;
        this.quote = q;
        this.JDBCT = new JDBCTypes();
    }

    void set(TransferDb database, Traceable t, String q) {
        this.db = database;
        this.tracer = t;
        this.quote = q;
    }

    String formatIdentifier(String id) {
        if (id == null) {
            return id;
        }
        if (id.equals("")) {
            return id;
        }
        if (!Character.isLetter(id.charAt(0)) || id.indexOf(32) != -1) {
            return this.quote + id + this.quote;
        }
        return id;
    }

    void setSchema(String _Schema) {
        this.sSchema = _Schema;
    }

    String formatName(String t) {
        String Name2 = "";
        if (this.sSchema != null && this.sSchema.length() > 0) {
            Name2 = this.sSchema + ".";
        }
        Name2 = Name2 + this.formatIdentifier(t);
        return Name2;
    }

    int convertFromType(int type) {
        return type;
    }

    int convertToType(int type) {
        return type;
    }

    Hashtable getSupportedTypes() {
        Hashtable hTypes = new Hashtable();
        if (this.db != null) {
            try {
                ResultSet result = this.db.meta.getTypeInfo();
                while (result.next()) {
                    Integer intobj = new Integer(result.getShort(2));
                    if (hTypes.get(intobj) != null) continue;
                    try {
                        hTypes.put(intobj, this.JDBCT.toString(result.getShort(2)));
                    }
                    catch (Exception exception) {}
                }
                result.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (hTypes.isEmpty()) {
            hTypes = this.JDBCT.getHashtable();
        }
        return hTypes;
    }

    String fixupColumnDefRead(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        return columnType;
    }

    String fixupColumnDefWrite(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        return columnType;
    }

    boolean needTransferTransaction() {
        return false;
    }

    Object convertColumnValue(Object value, int column, int type) {
        return value;
    }

    void beginDataTransfer() {
    }

    void endDataTransfer() {
    }
}

