/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import com.kingdee.eas.cp.hsqldb.util.ZaurusTableForm;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ZaurusEditor
extends Panel
implements ActionListener {
    static TextField tStatus;
    Connection cConn;
    DatabaseMetaData dbmeta;
    Button bSearchRow;
    Button bNewRow;
    Button bCancel1;
    Button bPrev;
    Button bNext;
    Button bDelete;
    Button bNewSearch;
    Button bCancel2;
    Button bNewInsert;
    Button bNewSearch1;
    Panel pSearchButs;
    Panel pEditButs;
    Panel pInsertButs;
    Vector vHoldTableNames;
    Vector vHoldForms;
    int aktHoldNr;
    Panel pForm;
    Panel pButton;
    CardLayout lForm;
    CardLayout lButton;
    TextField fSearchWords;
    Choice cTables;
    CheckboxGroup gAllWords;
    CheckboxGroup gIgnoreCase;
    CheckboxGroup gNoMatchWhole;
    boolean lastButtonDelete;

    public static void printStatus(String text) {
        tStatus.setText(text);
    }

    public static void clearStatus() {
        tStatus.setText("");
    }

    public ZaurusEditor() {
        this.initGUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Button button = (Button)e.getSource();
        if (button == this.bSearchRow) {
            this.resetLastButtonDelete();
            this.aktHoldNr = this.getChoosenTableIndex();
            int numberOfRows = ((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).searchRows(this.getWords(), this.gAllWords.getSelectedCheckbox().getLabel().equals("all"), this.gIgnoreCase.getSelectedCheckbox().getLabel().equals("yes"), this.gNoMatchWhole.getSelectedCheckbox().getLabel().equals("no"));
            String tableName = (String)this.vHoldTableNames.elementAt(this.aktHoldNr);
            if (numberOfRows > 0) {
                this.lForm.show(this.pForm, tableName);
                this.lButton.show(this.pButton, "edit");
                this.bPrev.setEnabled(false);
                this.bNext.setEnabled(numberOfRows != 1);
                ZaurusEditor.printStatus("found " + numberOfRows + " rows in table " + tableName);
            } else if (numberOfRows == 0) {
                ZaurusEditor.printStatus("no rows found in table " + tableName);
            }
        } else if (button == this.bNewRow) {
            this.aktHoldNr = this.getChoosenTableIndex();
            this.lForm.show(this.pForm, (String)this.vHoldTableNames.elementAt(this.aktHoldNr));
            this.lButton.show(this.pButton, "insert");
            ((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).insertNewRow();
        } else if (button == this.bNewInsert) {
            this.resetLastButtonDelete();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveNewRow()) {
                ((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).insertNewRow();
            }
        } else if (button == this.bNewSearch) {
            this.resetLastButtonDelete();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveChanges()) {
                this.lForm.show(this.pForm, "search");
                this.lButton.show(this.pButton, "search");
            }
        } else if (button == this.bNewSearch1) {
            this.resetLastButtonDelete();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveNewRow()) {
                this.lForm.show(this.pForm, "search");
                this.lButton.show(this.pButton, "search");
            }
        } else if (button == this.bNext) {
            this.resetLastButtonDelete();
            this.clearStatus();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveChanges()) {
                this.bPrev.setEnabled(true);
                if (!((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).nextRow()) {
                    this.bNext.setEnabled(false);
                }
            }
        } else if (button == this.bPrev) {
            this.resetLastButtonDelete();
            this.clearStatus();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveChanges()) {
                this.bNext.setEnabled(true);
                if (!((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).prevRow()) {
                    this.bPrev.setEnabled(false);
                }
            }
        } else if (button == this.bCancel1) {
            this.resetLastButtonDelete();
            ((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).cancelChanges();
        } else if (button == this.bCancel2) {
            this.resetLastButtonDelete();
            this.lForm.show(this.pForm, "search");
            this.lButton.show(this.pButton, "search");
        } else if (button == this.bDelete) {
            if (this.lastButtonDelete) {
                switch (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).deleteRow()) {
                    case 1: {
                        this.lForm.show(this.pForm, "search");
                        this.lButton.show(this.pButton, "search");
                        break;
                    }
                    case 2: {
                        this.bPrev.setEnabled(false);
                        break;
                    }
                    case 3: {
                        this.bNext.setEnabled(false);
                        break;
                    }
                }
                this.lastButtonDelete = false;
            } else {
                ZaurusEditor.printStatus("Press 'Delete' a second time to delete row.");
                this.lastButtonDelete = true;
            }
        }
    }

    public void refresh(Connection c) {
        this.cConn = c;
        if (this.vHoldForms == null) {
            this.initGUI();
        } else {
            this.resetTableForms();
        }
    }

    private void initGUI() {
        Vector vAllTables = this.getAllTables();
        if (vAllTables == null) {
            return;
        }
        this.vHoldTableNames = new Vector(20);
        this.vHoldForms = new Vector(20);
        this.setLayout(new BorderLayout(3, 3));
        Panel pFormButs = new Panel();
        pFormButs.setLayout(new BorderLayout(3, 3));
        this.pForm = new Panel();
        this.lForm = new CardLayout(2, 2);
        this.pForm.setLayout(this.lForm);
        Panel pEntry = new Panel();
        pEntry.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridy = 0;
        c.gridx = 0;
        pEntry.add((Component)new Label("Search table"), c);
        c.gridx = 1;
        this.cTables = new Choice();
        Enumeration e = vAllTables.elements();
        while (e.hasMoreElements()) {
            this.cTables.addItem((String)e.nextElement());
        }
        c.gridwidth = 2;
        pEntry.add((Component)this.cTables, c);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 1;
        pEntry.add((Component)new Label("Search words"), c);
        c.gridx = 1;
        c.gridwidth = 2;
        this.fSearchWords = new TextField(8);
        pEntry.add((Component)this.fSearchWords, c);
        c.gridwidth = 1;
        c.gridy = 2;
        c.gridx = 0;
        pEntry.add((Component)new Label("Use search words"), c);
        this.gAllWords = new CheckboxGroup();
        Checkbox[] checkboxes = new Checkbox[2];
        checkboxes[0] = new Checkbox("all", this.gAllWords, true);
        c.gridx = 1;
        pEntry.add((Component)checkboxes[0], c);
        checkboxes[1] = new Checkbox("any ", this.gAllWords, false);
        c.gridx = 2;
        pEntry.add((Component)checkboxes[1], c);
        c.gridy = 3;
        c.gridx = 0;
        pEntry.add((Component)new Label("Ignore case"), c);
        this.gIgnoreCase = new CheckboxGroup();
        Checkbox[] checkboxes1 = new Checkbox[2];
        checkboxes1[0] = new Checkbox("yes", this.gIgnoreCase, true);
        c.gridx = 1;
        pEntry.add((Component)checkboxes1[0], c);
        checkboxes1[1] = new Checkbox("no", this.gIgnoreCase, false);
        c.gridx = 2;
        pEntry.add((Component)checkboxes1[1], c);
        c.gridy = 4;
        c.gridx = 0;
        pEntry.add((Component)new Label("Match whole col"), c);
        this.gNoMatchWhole = new CheckboxGroup();
        Checkbox[] checkboxes2 = new Checkbox[2];
        checkboxes2[0] = new Checkbox("no", this.gNoMatchWhole, true);
        c.gridx = 1;
        pEntry.add((Component)checkboxes2[0], c);
        checkboxes2[1] = new Checkbox("yes ", this.gNoMatchWhole, false);
        c.gridx = 2;
        pEntry.add((Component)checkboxes2[1], c);
        this.pForm.add("search", pEntry);
        pFormButs.add("Center", this.pForm);
        this.initButtons();
        this.pButton = new Panel();
        this.lButton = new CardLayout(2, 2);
        this.pButton.setLayout(this.lButton);
        this.pButton.add("search", this.pSearchButs);
        this.pButton.add("edit", this.pEditButs);
        this.pButton.add("insert", this.pInsertButs);
        pFormButs.add("South", this.pButton);
        this.add("Center", pFormButs);
        Font fFont = new Font("Dialog", 0, 10);
        tStatus = new TextField("");
        tStatus.setEditable(false);
        this.add("South", tStatus);
    }

    private Vector getAllTables() {
        Vector<String> result = new Vector<String>(20);
        try {
            if (this.cConn == null) {
                return null;
            }
            this.dbmeta = this.cConn.getMetaData();
            String[] tableTypes = new String[]{"TABLE"};
            ResultSet allTables = this.dbmeta.getTables(null, null, null, tableTypes);
            while (allTables.next()) {
                String aktTable = allTables.getString("TABLE_NAME");
                ResultSet primKeys = this.dbmeta.getPrimaryKeys(null, null, aktTable);
                if (primKeys.next()) {
                    result.addElement(aktTable);
                }
                primKeys.close();
            }
            allTables.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    private int getChoosenTableIndex() {
        String tableName = this.cTables.getSelectedItem();
        int index = this.getTableIndex(tableName);
        if (index >= 0) {
            return index;
        }
        ZaurusTableForm tableForm = new ZaurusTableForm(tableName, this.cConn);
        this.pForm.add(tableName, tableForm);
        this.vHoldTableNames.addElement(tableName);
        this.vHoldForms.addElement(tableForm);
        return this.vHoldTableNames.size() - 1;
    }

    private int getTableIndex(String tableName) {
        for (int index = 0; index < this.vHoldTableNames.size(); ++index) {
            if (!tableName.equals((String)this.vHoldTableNames.elementAt(index))) continue;
            return index;
        }
        return -1;
    }

    private String[] getWords() {
        StringTokenizer tokenizer = new StringTokenizer(this.fSearchWords.getText());
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            result[i++] = tokenizer.nextToken();
        }
        return result;
    }

    private void initButtons() {
        this.bSearchRow = new Button("Search Rows");
        this.bNewRow = new Button("Insert New Row");
        this.bSearchRow.addActionListener(this);
        this.bNewRow.addActionListener(this);
        this.pSearchButs = new Panel();
        this.pSearchButs.setLayout(new GridLayout(1, 0, 4, 4));
        this.pSearchButs.add(this.bSearchRow);
        this.pSearchButs.add(this.bNewRow);
        this.bCancel1 = new Button("Cancel");
        this.bPrev = new Button("Prev");
        this.bNext = new Button("Next");
        this.bDelete = new Button("Delete");
        this.lastButtonDelete = false;
        this.bNewSearch = new Button("Search");
        this.bCancel1.addActionListener(this);
        this.bPrev.addActionListener(this);
        this.bNext.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.bNewSearch.addActionListener(this);
        this.pEditButs = new Panel();
        this.pEditButs.setLayout(new GridLayout(1, 0, 4, 4));
        this.pEditButs.add(this.bCancel1);
        this.pEditButs.add(this.bPrev);
        this.pEditButs.add(this.bNext);
        this.pEditButs.add(this.bDelete);
        this.pEditButs.add(this.bNewSearch);
        this.pInsertButs = new Panel();
        this.pInsertButs.setLayout(new GridLayout(1, 0, 4, 4));
        this.bCancel2 = new Button("Cancel Insert");
        this.bNewInsert = new Button("New Insert");
        this.bNewSearch1 = new Button("Search");
        this.bCancel2.addActionListener(this);
        this.bNewInsert.addActionListener(this);
        this.bNewSearch1.addActionListener(this);
        this.pInsertButs.add(this.bCancel2);
        this.pInsertButs.add(this.bNewInsert);
        this.pInsertButs.add(this.bNewSearch1);
    }

    private void resetLastButtonDelete() {
        if (this.lastButtonDelete) {
            ZaurusEditor.printStatus("");
            this.lastButtonDelete = false;
        }
    }

    private void resetTableForms() {
        this.lForm.show(this.pForm, "search");
        this.lButton.show(this.pButton, "search");
        Vector vAllTables = this.getAllTables();
        this.cTables.removeAll();
        Enumeration e = vAllTables.elements();
        while (e.hasMoreElements()) {
            this.cTables.addItem((String)e.nextElement());
        }
        e = this.vHoldForms.elements();
        while (e.hasMoreElements()) {
            this.pForm.remove((ZaurusTableForm)e.nextElement());
        }
        this.vHoldTableNames = new Vector(20);
        this.vHoldForms = new Vector(20);
    }
}

