/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryCollection;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.util.CPBCCommonParams;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BudgetCommonUtil {
    public static Map getBizSourceBillCols(Context ctx, String sourceBillId, Set sourceEntryIds) throws BOSException {
        if (sourceBillId == null) {
            return null;
        }
        BOSObjectType sourceBosType = new ObjectUuidPK(sourceBillId).getObjectType();
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)sourceBosType)) {
            return BudgetCommonUtil.getSourceBillOfOtherBillCols(ctx, sourceEntryIds);
        }
        if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)sourceBosType)) {
            return BudgetCommonUtil.getSourceBillOfDailyLoanBillCols(ctx, sourceEntryIds);
        }
        if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)sourceBosType)) {
            return BudgetCommonUtil.getSourceBillOfEvectionLoanBillCols(ctx, sourceEntryIds);
        }
        return null;
    }

    private static Map getSourceBillOfOtherBillCols(Context ctx, Set sourceEntryIds) throws BOSException {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        OtherExpenseBillEntryCollection otherEntryCols = null;
        if (sourceEntryIds.size() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("expenseType.id"));
            sic.add(new SelectorItemInfo("bill.costedDept.id"));
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)BudgetCommonUtil.getFilterById(sourceEntryIds), CompareType.INNER));
            ev.setFilter(filter);
            ev.setSelector(sic);
            otherEntryCols = OtherExpenseBillEntryFactory.getLocalInstance(ctx).getOtherExpenseBillEntryCollection(ev);
            if (otherEntryCols != null) {
                int leng = otherEntryCols.size();
                for (int i = 0; i < leng; ++i) {
                    OtherExpenseBillEntryInfo entryInfo = otherEntryCols.get(i);
                    StringBuffer tempID = new StringBuffer();
                    tempID.append(entryInfo.getExpenseType().getId().toString());
                    tempID.append(entryInfo.getBill().getCostedDept().getId().toString());
                    entryMap.put(entryInfo.getId().toString(), tempID.toString());
                }
            }
        }
        return entryMap;
    }

    private static Map getSourceBillOfDailyLoanBillCols(Context ctx, Set sourceEntryIds) throws BOSException {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        DailyLoanBillEntryCollection otherEntryCols = null;
        if (sourceEntryIds.size() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("expenseType.id"));
            sic.add(new SelectorItemInfo("bill.costedDept.id"));
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)BudgetCommonUtil.getFilterById(sourceEntryIds), CompareType.INNER));
            ev.setFilter(filter);
            ev.setSelector(sic);
            otherEntryCols = DailyLoanBillEntryFactory.getLocalInstance(ctx).getDailyLoanBillEntryCollection(ev);
            if (otherEntryCols != null) {
                int leng = otherEntryCols.size();
                for (int i = 0; i < leng; ++i) {
                    DailyLoanBillEntryInfo entryInfo = otherEntryCols.get(i);
                    StringBuffer tempID = new StringBuffer();
                    tempID.append(entryInfo.getExpenseType().getId().toString());
                    tempID.append(entryInfo.getBill().getCostedDept().getId().toString());
                    entryMap.put(entryInfo.getId().toString(), tempID.toString());
                }
            }
        }
        return entryMap;
    }

    private static Map getSourceBillOfEvectionLoanBillCols(Context ctx, Set sourceEntryIds) throws BOSException {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        EvectionLoanBillEntryCollection otherEntryCols = null;
        if (sourceEntryIds.size() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("expenseType.id"));
            sic.add(new SelectorItemInfo("bill.costedDept.id"));
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)BudgetCommonUtil.getFilterById(sourceEntryIds), CompareType.INNER));
            ev.setFilter(filter);
            ev.setSelector(sic);
            otherEntryCols = EvectionLoanBillEntryFactory.getLocalInstance(ctx).getEvectionLoanBillEntryCollection(ev);
            if (otherEntryCols != null) {
                int leng = otherEntryCols.size();
                for (int i = 0; i < leng; ++i) {
                    EvectionLoanBillEntryInfo entryInfo = otherEntryCols.get(i);
                    StringBuffer tempID = new StringBuffer();
                    tempID.append(entryInfo.getExpenseType().getId().toString());
                    tempID.append(entryInfo.getBill().getCostedDept().getId().toString());
                    entryMap.put(entryInfo.getId().toString(), tempID.toString());
                }
            }
        }
        return entryMap;
    }

    protected static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountUsed"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("costedDept.id"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.expenseType.id"));
        return sic;
    }

    protected static String getFilterById(Set sourceBillIds) {
        String filters = null;
        if (sourceBillIds.size() > 0) {
            StringBuffer ids = new StringBuffer();
            Iterator ite = sourceBillIds.iterator();
            if (ite.hasNext()) {
                ids.append("'" + ite.next() + "'");
            }
            while (ite.hasNext()) {
                ids.append(",'" + ite.next() + "'");
            }
            filters = ids.toString();
        }
        return filters;
    }
}

