/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollCheckEntryInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BudgetCheckDimension;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.util.ReverseUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetModifyUtil {
    static String expenseTypeId = null;
    static String costCenterId = null;
    static String projectId = null;
    static Map tempMap = null;
    static Map checkMap = null;
    static Map entryMap = null;
    static Map infoMap = null;
    static BigDecimal amount = null;
    static BigDecimal checkAmount = null;
    static BigDecimal bgAmount = null;
    static List valueList = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.BudgetModifyUtil");

    public static void updateBudgetDo(Context ctx, BizCollBillBaseInfo info, String amountField, boolean reqBillUseBg, boolean loanBillUseBg, boolean eveReqBillUseBg) throws EASBizException, BOSException {
        valueList = null;
        if (info.get("ReqCheckEntries") != null && ((AbstractObjectCollection)info.get("ReqCheckEntries")).size() > 0) {
            boolean isEve;
            boolean bl = isEve = info instanceof EvectionLoanBillInfo || info instanceof TravelAccountBillInfo;
            if (eveReqBillUseBg && isEve || reqBillUseBg && !isEve) {
                valueList = BizCollUtil.converToList((AbstractObjectCollection)info.get("ReqCheckEntries"));
            }
        }
        if (info.get("LoanCheckEntries") != null && ((AbstractObjectCollection)info.get("LoanCheckEntries")).size() > 0) {
            if (valueList != null) {
                valueList.addAll(BizCollUtil.converToList((AbstractObjectCollection)info.get("LoanCheckEntries"), loanBillUseBg));
            } else {
                valueList = BizCollUtil.converToList((AbstractObjectCollection)info.get("LoanCheckEntries"), loanBillUseBg);
            }
        }
        if (valueList != null && valueList.size() > 0) {
            valueList = ReverseUtil.dealCheckListByRequstBg(ctx, info, valueList);
            valueList = ReverseUtil.sortCheckList(valueList);
            valueList = BudgetModifyUtil.groupCheckByExpenseType(ctx, valueList, "checkAmount");
            BudgetModifyUtil.updateBudgetDoForCheckBg(ctx, info, valueList, amountField);
        } else {
            BudgetModifyUtil.updateBillBudgetDoForBgAudit(ctx, info, amountField);
        }
        IBizCollBillBase iBizCollBillBase = BudgetModifyUtil.getBillService(ctx, info);
        if (info.getId() != null && iBizCollBillBase.exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            iBizCollBillBase.updatePartial((CoreBaseInfo)info, BudgetModifyUtil.getUpdateSelector());
        }
    }

    public static void updateBudgetDoForCheckBg(Context ctx, BizCollBillBaseInfo info, List valueList, String amountField) throws EASBizException, BOSException {
        BudgetModifyUtil.updateBudgetDoForCheckBg(ctx, info, valueList, amountField, false);
    }

    public static void updateBudgetDoForCheckBg(Context ctx, BizCollBillBaseInfo info, List valueList, String amountField, boolean forBillClose) throws EASBizException, BOSException {
        AbstractObjectCollection con = (AbstractObjectCollection)info.get("entries");
        String costDeptId = ReverseUtil.getCostDeptIdForBg(ctx, info, null);
        HashMap<String, Object> dimensionMap = new HashMap<String, Object>();
        String[] bgFileds = (String[])BudgetModifyUtil.getDimensionAndFiled(ctx).get("BGFIELD_DIMENSION");
        CoreBillEntryBaseInfo entryInfo = null;
        BigDecimal amount = null;
        BigDecimal bgAmount = null;
        Map tempMap = null;
        BigDecimal checkAmount = null;
        Object fieldValue = null;
        int size = con.size();
        for (int i = 0; i < size; ++i) {
            int j;
            entryInfo = (CoreBillEntryBaseInfo)con.getObject(i);
            int dimensionSize = bgFileds.length;
            for (j = 0; j < dimensionSize; ++j) {
                String bgFiled = bgFileds[j];
                fieldValue = entryInfo.get(bgFiled);
                if (fieldValue instanceof IObjectValue && fieldValue != null) {
                    dimensionMap.put(bgFiled, ((IObjectValue)fieldValue).getString("id"));
                } else {
                    dimensionMap.put(bgFiled, fieldValue);
                }
                if (!"costCenter".equals(bgFiled)) continue;
                if (costDeptId == null) {
                    dimensionMap.put(bgFiled, entryInfo.getObjectValue(bgFiled).getString("id"));
                    continue;
                }
                dimensionMap.put(bgFiled, costDeptId);
            }
            amount = entryInfo.getBigDecimal(amountField);
            if (amount == null) {
                amount = BizCollUtil.ZERO;
            }
            bgAmount = amount;
            int checksize = valueList.size();
            for (j = 0; j < checksize; ++j) {
                tempMap = (Map)valueList.get(j);
                boolean isSame = BudgetModifyUtil.isSameDimension(bgFileds, tempMap, dimensionMap);
                if (!isSame) continue;
                checkAmount = (BigDecimal)tempMap.get("amount");
                if (checkAmount.compareTo(BizCollUtil.ZERO) <= 0) break;
                if (amount.compareTo(checkAmount) >= 0) {
                    bgAmount = amount.subtract(checkAmount);
                    tempMap.put("amount", BizCollUtil.ZERO);
                    break;
                }
                bgAmount = BizCollUtil.ZERO;
                tempMap.put("amount", checkAmount.subtract(amount));
                break;
            }
            if (forBillClose) {
                entryInfo.setBigDecimal("budgetUsed", entryInfo.getBigDecimal("budgetUsed").subtract(bgAmount));
                bgAmount = bgAmount.negate();
            } else {
                entryInfo.setBigDecimal("budgetUsed", bgAmount);
            }
            entryInfo.setBigDecimal("budgetDo", bgAmount);
        }
    }

    protected static void updateBillBudgetDoForBgAudit(Context ctx, BizCollBillBaseInfo billInfo, String amountField) throws EASBizException, BOSException {
        CoreBillEntryBaseInfo entryInfo = null;
        AbstractObjectCollection billEntry = (AbstractObjectCollection)billInfo.get("entries");
        int length = billEntry.size();
        for (int i = 0; i < length; ++i) {
            entryInfo = (CoreBillEntryBaseInfo)billEntry.getObject(i);
            entryInfo.setBigDecimal("budgetDo", entryInfo.getBigDecimal(amountField));
            entryInfo.setBigDecimal("budgetUsed", entryInfo.getBigDecimal(amountField));
        }
    }

    public static IBizCollBillBase getBillService(Context ctx, BizCollBillBaseInfo billInfo) throws EASBizException, BOSException {
        IBizCollBillBase iservice = null;
        if (billInfo instanceof OtherExpenseBillInfo) {
            iservice = OtherExpenseBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof DailyLoanBillInfo) {
            iservice = DailyLoanBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof EvectionLoanBillInfo) {
            iservice = EvectionLoanBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof BizAccountBillInfo) {
            iservice = BizAccountBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof BizAccountOutBillInfo) {
            iservice = BizAccountOutBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof TravelAccountBillInfo) {
            iservice = TravelAccountBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof DailyPurchaseAccountBillInfo) {
            iservice = DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof EvectionReqBillInfo) {
            iservice = EvectionReqBillFactory.getLocalInstance(ctx);
        }
        return iservice;
    }

    protected static SelectorItemCollection getUpdateSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entries.id"));
        selector.add(new SelectorItemInfo("entries.budgetDo"));
        selector.add(new SelectorItemInfo("entries.budgetUsed"));
        return selector;
    }

    public static List groupCheckByExpenseType(List list, String amountField) {
        BizCollCheckEntryInfo checkInfo = null;
        amount = null;
        expenseTypeId = null;
        costCenterId = null;
        projectId = null;
        ArrayList<Map> checkList = new ArrayList<Map>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            checkInfo = (BizCollCheckEntryInfo)list.get(i);
            if (expenseTypeId == null && costCenterId == null && projectId == null) {
                expenseTypeId = checkInfo.getSourceBillExpenseTypeId();
                costCenterId = checkInfo.getSourceBillCostCenterId();
                projectId = checkInfo.getSourceBillProjectId() != null ? checkInfo.getSourceBillProjectId() : "";
                infoMap = new HashMap();
                infoMap.put("expenseType", expenseTypeId);
                infoMap.put("costCenter", costCenterId);
                infoMap.put("projectId", projectId);
                infoMap.put("amount", checkInfo.getBigDecimal(amountField));
                checkList.add(infoMap);
                continue;
            }
            if (checkInfo.getSourceBillExpenseTypeId().equals(expenseTypeId) && checkInfo.getSourceBillCostCenterId().equals(costCenterId) && projectId.equals(checkInfo.getSourceBillProjectId())) {
                infoMap = (Map)checkList.get(checkList.size() - 1);
                amount = (BigDecimal)infoMap.get("amount");
                amount = amount.add(checkInfo.getBigDecimal(amountField));
                infoMap.put("amount", amount);
                continue;
            }
            if (checkInfo.getSourceBillExpenseTypeId().equals(expenseTypeId) && checkInfo.getSourceBillCostCenterId().equals(costCenterId) && checkInfo.getSourceBillProjectId() == null) {
                infoMap = (Map)checkList.get(checkList.size() - 1);
                amount = (BigDecimal)infoMap.get("amount");
                amount = amount.add(checkInfo.getBigDecimal(amountField));
                infoMap.put("amount", amount);
                continue;
            }
            expenseTypeId = checkInfo.getSourceBillExpenseTypeId();
            costCenterId = checkInfo.getSourceBillCostCenterId();
            projectId = checkInfo.getSourceBillProjectId() != null ? checkInfo.getSourceBillProjectId() : "";
            infoMap = new HashMap();
            infoMap.put("expenseType", expenseTypeId);
            infoMap.put("costCenter", costCenterId);
            infoMap.put("projectId", projectId);
            infoMap.put("amount", checkInfo.getBigDecimal(amountField));
            checkList.add(infoMap);
        }
        return checkList;
    }

    public static List groupCheckByExpenseType(Context ctx, List list, String amountField) {
        BizCollCheckEntryInfo checkInfo = null;
        Map infoMap = null;
        String[] bgFileds = (String[])BudgetModifyUtil.getDimensionAndFiled(ctx).get("BGFIELD_DIMENSION");
        String[] bgSourceFileds = (String[])BudgetModifyUtil.getDimensionAndFiled(ctx).get("SOURCEBGFIELD_DIMENSION");
        HashMap<String, Object> dimensionMap = null;
        ArrayList checkList = new ArrayList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            checkInfo = (BizCollCheckEntryInfo)list.get(i);
            dimensionMap = new HashMap<String, Object>();
            int dimensionSize = bgSourceFileds.length;
            for (int j = 0; j < dimensionSize; ++j) {
                String bgFiled = bgFileds[j];
                String bgSourceFiled = bgSourceFileds[j];
                dimensionMap.put(bgFiled, checkInfo.get(bgSourceFiled));
            }
            dimensionMap.put("amount", checkInfo.getBigDecimal(amountField));
            if (checkList.size() > 0) {
                boolean isSame = true;
                int jsize = checkList.size();
                for (int j = 0; j < jsize && !(isSame = BudgetModifyUtil.isSameDimension(bgFileds, dimensionMap, infoMap = (Map)checkList.get(j))); ++j) {
                }
                if (isSame) {
                    if (infoMap == null) continue;
                    BigDecimal amount = infoMap.get("amount") == null ? BigDecimal.ZERO : (BigDecimal)infoMap.get("amount");
                    BigDecimal checkAmount = checkInfo.get(amountField) == null ? BigDecimal.ZERO : (BigDecimal)checkInfo.get(amountField);
                    amount = amount.add(checkAmount);
                    infoMap.put("amount", amount);
                    continue;
                }
                checkList.add(dimensionMap);
                continue;
            }
            checkList.add(dimensionMap);
        }
        return checkList;
    }

    public static boolean isSameDimension(String[] bgFileds, Map dimensionMap, Map infoMap) {
        boolean isSame = true;
        String infoMapValue = null;
        String dimensionMapValue = null;
        for (String bgFiled : bgFileds) {
            infoMapValue = (String)infoMap.get(bgFiled);
            dimensionMapValue = (String)dimensionMap.get(bgFiled);
            if (infoMapValue == null && dimensionMapValue == null) continue;
            if (infoMapValue == null) {
                infoMapValue = "";
            }
            if (dimensionMapValue == null) {
                dimensionMapValue = "";
            }
            if (infoMapValue.equals(dimensionMapValue)) continue;
            isSame = false;
            break;
        }
        return isSame;
    }

    public static List converEntryToList(Context ctx, AbstractObjectCollection reqCheckCon, String costdepId, String amountField) {
        List list = BudgetModifyUtil.converToList(reqCheckCon, true);
        HashMap<String, Object> map = null;
        ArrayList valueList = new ArrayList();
        boolean isAccountBill = false;
        if (costdepId == null) {
            isAccountBill = true;
        }
        String[] bgFileds = (String[])BudgetModifyUtil.getDimensionAndFiled(ctx).get("BGFIELD_DIMENSION");
        IObjectValue listEntry = null;
        Object fieldValue = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            listEntry = (IObjectValue)list.get(i);
            map = new HashMap<String, Object>();
            for (String bgField : bgFileds) {
                fieldValue = listEntry.get(bgField);
                if (fieldValue instanceof IObjectValue) {
                    if (fieldValue != null) {
                        map.put(bgField, ((IObjectValue)fieldValue).getString("id"));
                    } else {
                        map.put(bgField, "");
                    }
                } else {
                    map.put(bgField, fieldValue);
                }
                if (!"costcenter".equals(bgField) || isAccountBill) continue;
                map.put(bgField, costdepId);
            }
            BigDecimal amount = listEntry.getBigDecimal(amountField) == null ? BizCollUtil.ZERO : listEntry.getBigDecimal(amountField);
            map.put("amount", amount);
            map.put("entryId", listEntry.getString("id"));
            valueList.add(map);
        }
        return valueList;
    }

    public static List converToList(AbstractObjectCollection reqCheckCon, boolean isUseBg) {
        ArrayList<IObjectValue> list = new ArrayList<IObjectValue>();
        int size = reqCheckCon.size();
        for (int i = 0; i < size; ++i) {
            if (!isUseBg && !reqCheckCon.getObject(i).getBoolean("hasSourceBill")) continue;
            list.add(reqCheckCon.getObject(i));
        }
        return list;
    }

    public static Map getDimensionAndFiled(Context ctx) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("BGFIELD_DIMENSION", BudgetCheckDimension.BGFIELD_DIMENSION);
        map.put("SOURCEBGFIELD_DIMENSION", BudgetCheckDimension.SOURCEBGFIELD_DIMENSION);
        return map;
    }
}

