/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CreateToException;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.app.reverse.payPlan.PayPlanBillReverseHandler;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fm.pp.IPPBillDisposer;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.framework.ICoreBase;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PayPlanBillReBack
implements IPPBillDisposer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.PayPlanBillReBack");

    public void dispose(Context context, BillDisposerAction billDisposer) throws BOSException, EASBizException {
        logger.error((Object)"--cp.bc PayPlanBillReBack");
        if (billDisposer == null || billDisposer.getDestBill() == null) {
            return;
        }
        DisposerActionEnum actionType = billDisposer.getActionType();
        logger.error((Object)("--cp.bc PayPlanBillReBack actionType=" + actionType));
        PayPlanBillInfo payPlanInfo = (PayPlanBillInfo)billDisposer.getDestBill();
        String srcBillId = payPlanInfo.getSourceBillId();
        logger.error((Object)("--cp.bc PayPlanBillReBack srcBillId=" + srcBillId));
        if (StringUtils.isEmpty((String)srcBillId)) {
            throw new CreateToException(CreateToException.PAYBILL_SOURCEBILLID_NULL);
        }
        ICoreBase iCoreBase = BizCollUtil.getBizInterfaceByBOSUuid(context, BOSUuid.read((String)srcBillId));
        if (!(iCoreBase instanceof IBizCollBillBase)) {
            throw new CreateToException(CreateToException.PAYBILL_SOURCEBILLID_NULL);
        }
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)iCoreBase;
        BizCollBillBaseInfo billInfo = iBizCollBillBase.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(srcBillId), this.getSelector());
        if (!(billInfo instanceof EvectionLoanBillInfo) && StringUtils.isEmpty((String)payPlanInfo.getSrcBillHeadID())) {
            throw new CreateToException(CreateToException.PAYBILL_SOURCEBILLENTRYID_NULL);
        }
        if (DisposerActionEnum.SAVE.equals((Object)actionType)) {
            PayPlanBillReverseHandler.payPlanHandler((Context)context, (IBizCollBillBase)iBizCollBillBase, (BizCollBillBaseInfo)billInfo, (PayPlanBillInfo)payPlanInfo, (String)"Save");
        } else if (DisposerActionEnum.BC_CALLBACK.equals((Object)actionType)) {
            PayPlanBillReverseHandler.payPlanHandler((Context)context, (IBizCollBillBase)iBizCollBillBase, (BizCollBillBaseInfo)billInfo, (PayPlanBillInfo)payPlanInfo, (String)"callBack");
        }
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("isPaySchedule"));
        sic.add(new SelectorItemInfo("isCreatePayPlanBill"));
        return sic;
    }

    public static boolean isSupport1toMany() {
        return true;
    }
}

