/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.EvectionExpBillEntryBaseInfo;
import com.kingdee.eas.cp.bc.budget.AbstractBillBudgetModify;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public abstract class AbstractTrBillBudgetModify
extends AbstractBillBudgetModify {
    @Override
    protected void setBudgetDoForReturnBudgetOfNotApproved(AbstractObjectCollection cols, List params) {
        if (cols == null) {
            return;
        }
        BigDecimal zeroAmount = new BigDecimal("0.00");
        int length = cols.size();
        for (int i = 0; i < length; ++i) {
            EvectionExpBillEntryBaseInfo entryInfo = (EvectionExpBillEntryBaseInfo)cols.getObject(i);
            BigDecimal budgetDo = entryInfo.getBudgetUsed().multiply(new BigDecimal("-1"));
            String entryId = entryInfo.getId().toString();
            Object[] param = new Object[]{budgetDo, zeroAmount, entryId};
            params.add(param);
        }
    }

    @Override
    protected void setBudgetDoForReturnBudgetOfApproved(Context ctx, CoreBillEntryBaseInfo entry, BizCollCoreBillBaseInfo billInfo, Map sourceEntrysMap, List params) {
        BigDecimal budgetUsed;
        BigDecimal budgetDo;
        EvectionExpBillEntryBaseInfo entryInfo = (EvectionExpBillEntryBaseInfo)entry;
        BigDecimal zeroAmount = new BigDecimal("0.00");
        if (entryInfo.getSourceBillEntryID() == null) {
            budgetDo = entryInfo.getAmountApproved().subtract(entryInfo.getAmount());
            budgetUsed = entryInfo.getAmountApproved();
        } else {
            boolean noChange = this.checkEntryChange(entryInfo, billInfo, sourceEntrysMap);
            if (noChange) {
                budgetDo = entryInfo.getAmountApproved().subtract(entryInfo.getAmount());
                budgetUsed = entryInfo.getAmountApproved();
            } else if (entryInfo.getAmount().compareTo(entryInfo.getSourceAmountBalance()) > 0) {
                if (entryInfo.getAmountApproved().compareTo(entryInfo.getSourceAmountBalance()) > 0) {
                    budgetDo = entryInfo.getAmountApproved().subtract(entryInfo.getAmount());
                    budgetUsed = entryInfo.getAmountApproved().subtract(entryInfo.getSourceAmountBalance());
                } else {
                    budgetDo = entryInfo.getSourceAmountBalance().subtract(entryInfo.getAmount());
                    budgetUsed = zeroAmount;
                }
            } else {
                budgetDo = zeroAmount;
                budgetUsed = zeroAmount;
            }
        }
        Object[] param = new Object[]{budgetDo, budgetUsed, entryInfo.getId().toString()};
        params.add(param);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void updateBudgetDo(Context ctx, CoreBillEntryBaseInfo entry, BizCollCoreBillBaseInfo billInfo, Map sourceEntrysMap, List params) throws EASBizException, BOSException {
        EvectionExpBillEntryBaseInfo tempEntry = (EvectionExpBillEntryBaseInfo)entry;
        BigDecimal budgetDo = null;
        BigDecimal budgetUsed = null;
        String entryID = null;
        boolean entryIsAddNew = false;
        if (tempEntry.getSourceBillEntryID() == null) {
            budgetDo = tempEntry.getAmount();
            budgetUsed = tempEntry.getAmount();
            entryID = tempEntry.getId().toString();
        } else {
            boolean noChange = this.checkEntryChange(tempEntry, billInfo, sourceEntrysMap);
            if (noChange) {
                if (tempEntry.getSourceAmountBalance() != null && tempEntry.getSourceAmountBalance().compareTo(new BigDecimal("0.00")) <= 0) {
                    budgetDo = tempEntry.getAmount();
                    budgetUsed = tempEntry.getAmount();
                    entryID = tempEntry.getId().toString();
                } else {
                    if (tempEntry.getAmount().compareTo(tempEntry.getSourceAmountBalance()) < 0) return;
                    budgetDo = tempEntry.getAmount().subtract(tempEntry.getSourceAmountBalance());
                    budgetUsed = tempEntry.getAmount().subtract(tempEntry.getSourceAmountBalance());
                    entryID = tempEntry.getId().toString();
                }
            } else {
                budgetDo = tempEntry.getAmount();
                budgetUsed = tempEntry.getAmount();
                entryID = tempEntry.getId().toString();
            }
        }
        Object[] param = new Object[]{budgetDo, budgetUsed, entryID};
        params.add(param);
    }
}

