/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.AssistantAccountFacadeFactory;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.client.AbstractAssistantAccountListUI;
import com.kingdee.eas.cp.bc.client.BCAsstactXBalanceConditionUI;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.IRptAsstactXBalance;
import com.kingdee.eas.fi.gl.RptAsstactXBalanceFactory;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.IRptFilterObject;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AssistantAccountListUI
extends AbstractAssistantAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(AssistantAccountListUI.class);
    private String RES = "com.kingdee.eas.cp.bc.client.AssistantAccountResource";
    public static String BizCollResource = "com.kingdee.eas.cp.bc.BizCollResource";
    private String LOANRES = "com.kingdee.eas.cp.bc.client.LoanReqResource";
    private IRowSet rowSet;
    private CurrencyInfo currencyInfo;
    private OrgUnitInfo orgInfo;
    private AccountViewInfo accountInfo;
    private CommonQueryDialog queryDialog = new CommonQueryDialog();
    private CommRptBaseConditionUI userPanel = null;
    private boolean showDialogOnLoad = true;
    protected RptParams params = null;
    private boolean shouldReloadPrintVar = true;
    boolean isFirstDefaultQuery = true;
    StringBuffer resultSQL = null;
    Object[] objParam = null;
    List columnKeylist = null;
    List columnValueList = null;
    boolean hasCostCenter = false;
    boolean hasAdminOrg = false;
    PeriodEntity pe = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        AssistantAccountListUI.checkFIUnit(SysContext.getSysContext().getCurrentFIUnit(), false);
        if (!BizCollUtil.checkValidPerson()) {
            this.showErrorMessage("com.kingdee.eas.hr.train.client.TrainApplyResource", "userNoPerson", this);
        }
        super.onLoad();
        this.tbl.checkParsed();
        this.accountInfo = this.getAccount(this.getAccountNumber());
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setVisible(true);
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setVisible(true);
        this.menuItemQuery.setEnabled(true);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.pe = this.getPeriod(company);
        if (this.showDialogOnLoad) {
            if (!this.showQueryDialog(true)) {
                this.close();
            }
        } else {
            this.query();
        }
    }

    public void showErrorMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)this.getResource(RES, message));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public String getResource(String RES, String message) {
        return EASResource.getString((String)RES, (String)message);
    }

    protected void close() {
        SysUtil.abort();
    }

    public void initOther() throws Exception {
        if (this.accountInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"read_account_error"));
            SysUtil.abort();
            return;
        }
    }

    public void initTbl() throws Exception {
        int i;
        if (this.rowSet == null) {
            return;
        }
        this.tbl.checkParsed();
        this.tbl.removeRows();
        this.tbl.removeColumns();
        this.tbl.addHeadRow();
        int n = this.columnKeylist.size();
        for (i = 0; i < n; ++i) {
            IColumn iCol = this.tbl.addColumn();
            iCol.setKey(this.columnKeylist.get(i).toString());
            this.tbl.getHeadRow(0).getCell(this.columnKeylist.get(i).toString()).setValue(this.columnValueList.get(i));
        }
        n = this.tbl.getColumnCount() - 1;
        for (i = 0; i < n; ++i) {
            this.tbl.getColumn(i).setGroup(true);
        }
        this.tbl.getColumn("FEndBalanceDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        String numberFormat = CtrlFormatUtilities.getDecimalFormatString();
        this.tbl.getColumn("FEndBalanceDebit").getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}n");
        IRow row = null;
        while (this.rowSet.next()) {
            row = this.tbl.addRow();
            int n2 = this.columnKeylist.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                row.getCell(this.columnKeylist.get(i2).toString()).setValue((Object)this.rowSet.getString(this.columnKeylist.get(i2).toString()));
            }
            row.getStyleAttributes().setLocked(true);
        }
        this.tbl.getGroupManager().group();
        this.repaint();
    }

    public void initTableData() {
        IRowSet rows = null;
        try {
            rows = AssistantAccountFacadeFactory.getRemoteInstance().getDataList(this.objParam, this.resultSQL.toString());
        }
        catch (EASBizException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"read_data_error"));
            logger.error((Object)e.getMainCode());
            return;
        }
        catch (BOSException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"read_data_error"));
            logger.error((Object)e.getMessage());
            return;
        }
        this.rowSet = rows;
    }

    private String getAccountNumber() {
        String number = "1134";
        try {
            number = BizCollUtil.getLoanBalanceAccountNumber();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return number;
    }

    private AccountViewInfo getAccount(String number) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (SysContext.getSysContext().getCurrentFIUnit().getAccountTable() == null || SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"accountTable_notSet"));
            SysUtil.abort();
        }
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        Object iav = null;
        AccountViewCollection cols = null;
        AccountViewInfo tempInfo = null;
        try {
            cols = AccountViewFactory.getRemoteInstance().getAccountViewCollection(ev);
        }
        catch (BOSException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"read_account_error"));
            SysUtil.abort();
        }
        if (cols.size() > 0) {
            tempInfo = cols.get(0);
        }
        return tempInfo;
    }

    private String getBalType() {
        return "1";
    }

    private PeriodEntity getPeriod(CompanyOrgUnitInfo company) {
        try {
            return new PeriodEntity(CommRptBaseFactory.getRemoteInstance().getPeriodRange(company));
        }
        catch (Exception e) {
            String s = EASResource.getString((String)this.LOANRES, (String)"read_period_error");
            MsgBox.showError((Component)((Object)this), (String)s);
            this.setCursorOfDefault();
            SysUtil.abort();
            return null;
        }
    }

    private CompanyOrgUnitInfo getCompany() {
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    private CurrencyInfo getCurrencyInfo() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"BB01", CompareType.EQUALS));
        filter.setMaskString("#0");
        ev.setFilter(filter);
        CurrencyInfo info = null;
        try {
            CurrencyCollection cols = CurrencyFactory.getRemoteInstance().getCurrencyCollection(ev);
            if (cols != null && cols.size() > 0) {
                info = cols.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return info;
    }

    public static void checkFIUnit(CompanyOrgUnitInfo company, boolean isSupportVirtual) throws Exception {
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (company.isIsOnlyUnion() && !isSupportVirtual) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
    }

    protected AdminOrgUnitInfo getOrgUnitReferToApplier(PersonInfo applier) {
        if (applier == null || applier.getId() == null) {
            return null;
        }
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getRemoteInstance();
            AdminOrgUnitCollection adminOrgUnitCollection = iPersonFacade.getAdminOrgUnitByPerson(applier.getId());
            if (adminOrgUnitCollection != null && adminOrgUnitCollection.size() > 0) {
                adminOrgUnitInfo = adminOrgUnitCollection.get(0);
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        return adminOrgUnitInfo;
    }

    protected AdminOrgUnitInfo getPrimaryOrgUnitReferToApplier(PersonInfo applier) {
        if (applier == null || applier.getId() == null) {
            return null;
        }
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        try {
            adminOrgUnitInfo = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(applier.getId());
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        return adminOrgUnitInfo;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showQueryDialog(false);
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new BCAsstactXBalanceConditionUI();
    }

    protected IMetaDataPK getQueryMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.cp.bc.app", "EmptyQueryForAssostamtAccountListQuery");
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getQueryDialogUserPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setWidth(dd.width);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.userPanel.onInit(this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setParam((Object)this.params);
            }
        }
    }

    protected RptParams getUIContextInitParams() throws BOSException, EASBizException {
        IRptAsstactXBalance ir;
        RptParams paramsForInit = this.getParamsForInit();
        if (paramsForInit != null && paramsForInit.size() > 0 && (ir = RptAsstactXBalanceFactory.getRemoteInstance()) != null) {
            RptParams temp = ir.init(paramsForInit);
            temp.setObject("accountInfo", (Object)this.accountInfo);
            return temp;
        }
        return null;
    }

    protected RptParams getParamsForInit() {
        RptParams rp = new RptParams();
        CompanyOrgUnitInfo companyClone = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        companyClone.setDescription(null);
        rp.setObject("company", (Object)companyClone);
        return rp;
    }

    protected void query() throws Exception {
        this.account.setText("[" + this.params.getObjectElement("jebAccount.value.number") + "] " + this.params.getObjectElement("jebAccount.value.name"));
        this.account.setToolTipText(this.account.getText());
        this.currency.setText(String.valueOf(this.params.getObjectElement("jbxCurrency.value.name")));
        this.currency.setToolTipText(this.currency.getText());
        this.currencyUnit.setText(String.valueOf(this.params.getObjectElement("jbxCurrency.value.baseUnit")));
        this.currencyUnit.setToolTipText(this.currencyUnit.getText());
        this.depart.setText(this.getAdminOrgUnit().getName(this.getCurrentLocale()));
        this.depart.setToolTipText(this.depart.getText());
        this.getSQL();
        this.initTableData();
        this.initTbl();
    }

    private OrgUnitInfo getAdminOrgUnit() {
        if (this.orgInfo == null) {
            AdminOrgUnitInfo orgInfo1 = null;
            IPerson ip = null;
            try {
                ip = PersonFactory.getRemoteInstance();
                PersonInfo applier = (PersonInfo)ip.getValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId()));
                orgInfo1 = this.getPrimaryOrgUnitReferToApplier(applier);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            this.orgInfo = orgInfo1;
        }
        return this.orgInfo;
    }

    private void getSQL() {
        String language = SysContext.getSysContext().getOriginLocale().getLanguage();
        this.hasAdminOrg = false;
        this.hasCostCenter = false;
        String adminKey = "T_ORG_ADMIN";
        this.columnKeylist = new ArrayList();
        this.columnValueList = new ArrayList();
        this.resultSQL = new StringBuffer();
        String select = "select  ";
        StringBuffer selectColumnSB = new StringBuffer();
        StringBuffer appendWhereSB = new StringBuffer();
        StringBuffer groupBySB = new StringBuffer();
        StringBuffer innerJoinSB = new StringBuffer();
        RptRowSet rs = (RptRowSet)this.params.getObject("rs");
        if (rs == null) {
            return;
        }
        rs.reset();
        while (rs.next()) {
            if (rs.getObject("FSelected") == null || !((Boolean)rs.getObject("FSelected")).booleanValue()) continue;
            if (rs.getObject("FREALTIONDATAOBJECT").toString().equalsIgnoreCase(adminKey)) {
                this.hasAdminOrg = true;
                appendWhereSB.append(" and ");
                appendWhereSB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
                appendWhereSB.append(".FLongNumber like ? ");
            }
            selectColumnSB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
            selectColumnSB.append(".FID ");
            selectColumnSB.append(rs.getObject("FASSTHGATTRIBUTE").toString() + "id,");
            selectColumnSB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
            selectColumnSB.append(".FNumber ");
            selectColumnSB.append(rs.getObject("FASSTHGATTRIBUTE").toString() + "number,");
            this.columnKeylist.add(rs.getObject("FASSTHGATTRIBUTE").toString() + "number");
            StringBuffer sb = new StringBuffer(rs.getObject("FNAME").toString());
            sb.append(EASResource.getString((String)BizCollResource, (String)"number"));
            this.columnValueList.add(sb.toString());
            selectColumnSB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
            if ("zh".equals(language)) {
                selectColumnSB.append(".FName_l2 ");
            } else if ("en".equals(language)) {
                selectColumnSB.append(".FName_l1 ");
            } else {
                selectColumnSB.append(".FName_l3 ");
            }
            selectColumnSB.append(rs.getObject("FASSTHGATTRIBUTE").toString() + "name,");
            this.columnKeylist.add(rs.getObject("FASSTHGATTRIBUTE").toString() + "name");
            this.columnValueList.add(rs.getObject("FNAME").toString());
            if (groupBySB.length() > 0) {
                groupBySB.append(",");
            }
            groupBySB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
            groupBySB.append(".FID,");
            groupBySB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
            if ("zh".equals(language)) {
                groupBySB.append(".FName_L2,");
            } else if ("en".equals(language)) {
                groupBySB.append(".FName_L1,");
            } else {
                groupBySB.append(".FName_L3,");
            }
            groupBySB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
            groupBySB.append(".FNumber");
            innerJoinSB.append(" inner join ");
            innerJoinSB.append(rs.getObject("FREALTIONDATAOBJECT").toString());
            innerJoinSB.append(" ");
            innerJoinSB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
            innerJoinSB.append(" on ");
            innerJoinSB.append(rs.getObject("FASSTHGATTRIBUTE").toString());
            innerJoinSB.append(".FID");
            innerJoinSB.append("=B.");
            innerJoinSB.append(rs.getObject("FMAPPINGFIELDNAME").toString());
            innerJoinSB.append("  ");
        }
        this.columnValueList.add(EASResource.getString((String)this.RES, (String)"balance"));
        this.columnKeylist.add("FEndBalanceDebit");
        String currencyId = String.valueOf(this.params.getObjectElement("jbxCurrency.value.id"));
        String amountFiled = "FEndBalanceFor";
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            amountFiled = "FEndBalanceLocal";
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            amountFiled = "FEndBalanceRpt";
        }
        StringBuffer sb1 = new StringBuffer();
        sb1.append(" sum(case ");
        sb1.append("            when D.FDC = 1 and A.FPeriod = ? then ");
        sb1.append(" A.").append(amountFiled).append(" else  0 end) FEndBalanceDebit, ");
        sb1.append("\t0 as FLEVEL,1 as FIsLeaf ");
        sb1.append(" from \t").append(AssistantAccountListUI.getBalanceTable(1, currencyId)).append(" A ");
        sb1.append("inner join T_BD_AssistantHG B on A.FAssistGrpID=B.FID ");
        sb1.append("inner join T_BD_AccountView D on D.Fid=A.Faccountid ");
        StringBuffer whereSB = new StringBuffer();
        whereSB.append(" where A.FOrgunitID= ? ");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            whereSB.append(" and A.FCurrencyID=  ? ");
        }
        whereSB.append(" and D.FNumber=  ?  ");
        whereSB.append(" and A.FPeriod=  ?  ");
        if (this.hasAdminOrg || this.hasCostCenter) {
            whereSB.append(appendWhereSB);
        }
        this.resultSQL.append(select);
        this.resultSQL.append(selectColumnSB.toString());
        this.resultSQL.append(sb1.toString());
        this.resultSQL.append(innerJoinSB.toString());
        this.resultSQL.append(whereSB.toString());
        this.resultSQL.append(" group by ");
        this.resultSQL.append(groupBySB.toString());
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            int defaultParams = 5;
            if (this.hasAdminOrg) {
                ++defaultParams;
            }
            this.objParam = new Object[defaultParams];
            this.objParam[0] = String.valueOf(this.pe.getCurrentYear() * 100 + this.pe.getCurrentPeriod());
            this.objParam[1] = this.getCompanyID();
            this.objParam[2] = String.valueOf(this.params.getObjectElement("jbxCurrency.value.id"));
            this.objParam[3] = this.accountInfo.getNumber();
            this.objParam[4] = String.valueOf(this.pe.getCurrentYear() * 100 + this.pe.getCurrentPeriod());
            if (this.hasAdminOrg) {
                this.objParam[5] = SysContext.getSysContext().getCurrentFIUnit().getLongNumber() + "%";
            }
        } else {
            int defaultParams = 4;
            if (this.hasAdminOrg) {
                ++defaultParams;
            }
            this.objParam = new Object[defaultParams];
            this.objParam[0] = String.valueOf(this.pe.getCurrentYear() * 100 + this.pe.getCurrentPeriod());
            this.objParam[1] = this.getCompanyID();
            this.objParam[2] = this.accountInfo.getNumber();
            this.objParam[3] = String.valueOf(this.pe.getCurrentYear() * 100 + this.pe.getCurrentPeriod());
            if (this.hasAdminOrg) {
                this.objParam[4] = SysContext.getSysContext().getCurrentFIUnit().getLongNumber() + "%";
            }
        }
    }

    public static String getBalanceTable(int balType, String currencyId) {
        String table = "T_GL_AssistBalance";
        if (balType == 1) {
            table = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) ? table + "_1L" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) ? table + "_1R" : table + "_1F");
        } else if (balType == 5) {
            table = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) ? table + "_5L" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) ? table + "_5R" : table + "_5F");
        } else {
            throw new IllegalArgumentException("balType must be 1 or 5.");
        }
        return table;
    }

    private String getCompanyID() {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        String orgunitID = "";
        if (company != null) {
            orgunitID = company.getId().toString();
        }
        return orgunitID;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                QuerySolutionInfo solution;
                QueryPanelInfo qpi;
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName) && (qpi = (solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName)).getQueryPanelInfo().get(0)) != null) {
                    try {
                        byte[] bs = qpi.getParam();
                        if (bs != null) {
                            this.params = (RptParams)CommonUtil.getObject((byte[])bs);
                        }
                        if (this.params != null) {
                            this.userPanel.setCustomCondition(this.params);
                        } else {
                            CustomerParams cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                            if (cp != null) {
                                Object obj = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
                                this.params = new RptParams();
                                RptFilterInfo rfi = (RptFilterInfo)obj;
                                IRptFilterObject ff = this.params.toIRptFilerObject(rfi);
                                this.params = ff instanceof RptParams ? (RptParams)ff : null;
                                this.userPanel.setCustomerParams(cp);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            boolean ok = false;
            if ((this.params == null || !useDefaultSolution) && this.queryDialog.show()) {
                CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                this.prepareQuery().callHandler();
                ok = true;
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.userPanel.setParam((Object)this.params);
                this.query();
                this.shouldReloadPrintVar = true;
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.initTableData();
        this.initTbl();
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            request.put("className", (Object)this.getMetaDataPK().getFullName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public IUIActionPostman prepareQuery() {
        IUIActionPostman handler = this.prepareInit();
        RequestContext request = new RequestContext();
        this.getSQL();
        request.put("resultSQL", (Object)this.resultSQL);
        request.put("objParam", (Object)this.objParam);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

