/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.client.AbstractBCAsstactXBalanceConditionUI;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.RptAsstactXBalanceFactory;
import com.kingdee.eas.fi.gl.client.RptAsstactXBalanceConditionUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BCAsstactXBalanceConditionUI
extends AbstractBCAsstactXBalanceConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactXBalanceConditionUI.class);
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    private RptRowSet rs = null;

    public BCAsstactXBalanceConditionUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tbl.getColumn(2).setWidth(110);
        this.tbl.getColumn(3).setWidth(110);
        this.kdUp.setEnabled(false);
        this.kdUp.setText(null);
        this.kdUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.kdUp.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUp"));
        this.kdDown.setEnabled(false);
        this.kdDown.setText(null);
        this.kdDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.kdDown.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDown"));
        this.setSize(420, 358);
        this.jspYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BCAsstactXBalanceConditionUI.this.spnPeriodYearEnd_stateChanged(e);
            }
        });
    }

    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) {
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        RptClientUtil.periodChanged((IUIObject)this, (CompanyOrgUnitInfo)company, (int)yearEnd, (int)numberEnd, (KDBizPromptBox)this.jebAccount, (KDBizPromptBox)this.jebAccount);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void jebAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.jebAccount_dataChanged(e);
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(-1);
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(1);
    }

    private void moveRow(int offset) {
        if (this.tbl.getSelectManager().get() != null) {
            int r = this.tbl.getSelectManager().get().getTop();
            int newr = r + offset;
            if (r < 0 || newr < 0 || newr >= this.tbl.getRowCount()) {
                return;
            }
            IRow row = this.tbl.removeRow(r);
            this.tbl.addRow(newr, row);
            this.tbl.getSelectManager().select(newr, 0, newr, this.tbl.getColumnCount());
            this.tbl.getLayoutManager().scrollToShow(newr, 0);
            this.rs.moveRow(r, newr);
        }
    }

    public void onInit(RptParams initParams) throws Exception {
        GlUtils.updateBalance();
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("currencys");
        PeriodEntity pe = new PeriodEntity((Map)initParams.getObject("periodRange"));
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        company = GlUtils.getCompanyById((String)company.getId().toString());
        RptClientUtil.setJComboBoxCurrencys((JComboBox)this.jbxCurrency, (CurrencyCollection)cc, null, (CompanyOrgUnitInfo)company);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)company.getCU().getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        filter.setMaskString("#0 and #1");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, filter, false, false);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.jebAccount.setSelector((KDPromptSelector)apb);
        this.jebAccount.setEntityViewInfo(myevi);
        this.jebAccount.setEditable(true);
        this.jebAccount.setEditFormat("$number$");
        this.jebAccount.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccount.setDisplayFormat("$number$ - $name$");
        this.jebAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("CAA.*"));
        this.jebAccount.setSelectorCollection(sc);
        this.jebAccount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                AccountViewInfo ai = (AccountViewInfo)BCAsstactXBalanceConditionUI.this.jebAccount.getValue();
                if (ai != null && BCAsstactXBalanceConditionUI.this.getTag() != 1) {
                    try {
                        RptParams rp = new RptParams();
                        rp.setString("fid", ai.getId().toString());
                        rp = RptAsstactXBalanceFactory.getRemoteInstance().getAsstactByAccount(rp);
                        BCAsstactXBalanceConditionUI.this.rs = (RptRowSet)rp.getObject("rs");
                    }
                    catch (Exception e) {
                        MsgBox.showInfo((Component)((Object)BCAsstactXBalanceConditionUI.this), (String)e.getMessage());
                    }
                }
                BCAsstactXBalanceConditionUI.this.setTableData();
            }
        });
        this.jebAccount.setValue(initParams.getObject("accountInfo"));
    }

    private void setTableData() {
        this.kdUp.setEnabled(false);
        this.kdDown.setEnabled(false);
        this.tbl.removeRows();
        if (this.rs == null) {
            return;
        }
        if (this.rs.getRowCount() == 0) {
            return;
        }
        this.kdUp.setEnabled(true);
        this.kdDown.setEnabled(true);
        this.tbl.setRefresh(false);
        this.rs.reset();
        while (this.rs.next()) {
            IRow row = this.tbl.addRow();
            row.getCell("selected").setValue((Object)Boolean.valueOf(String.valueOf(this.rs.getObject("FSelected"))));
            row.getCell("type").setValue((Object)this.rs.getString("FName"));
            row.getCell("from").setValue(this.rs.getObject("FFrom"));
            row.getCell("to").setValue(this.rs.getObject("FTo"));
            KDBizPromptBox bizPromptBox = new KDBizPromptBox();
            bizPromptBox.setEditable(true);
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setCommitFormat("$number$");
            bizPromptBox.setDisplayFormat("$number$ - $name$");
            bizPromptBox.setQueryInfo(this.rs.getString("FDefaultQueryName"));
            EntityViewInfo vv = new EntityViewInfo();
            FilterInfo ff = new FilterInfo();
            vv.setFilter(ff);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            if ("1".equals(String.valueOf(this.rs.getObject("FIsMultiLevel")))) {
                sic.add(new SelectorItemInfo("longnumber"));
            }
            bizPromptBox.setSelectorCollection(sic);
            GeneralAsstActTypeGroupInfo grp = null;
            if (this.rs.getObject("FGLAsstActTypeGrpID") != null) {
                grp = new GeneralAsstActTypeGroupInfo();
                grp.setId(BOSUuid.read((String)this.rs.getString("FGLAsstActTypeGrpID")));
            }
            GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)this.rs.getString("FAsstHGAttribute"), (boolean)"1".equals(String.valueOf(this.rs.getObject("FisForCompany"))), (boolean)false, null, (CoreUIObject)this, (boolean)false);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
            row.getCell("from").setEditor((ICellEditor)editor);
            row.getCell("to").setEditor((ICellEditor)editor);
        }
        this.tbl.setRefresh(true);
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this), new Component[]{this.tbl});
        this.rs.reset();
        int i = 0;
        while (this.rs.next()) {
            this.rs.setValue("FSelected", this.tbl.getCell(i, 0).getValue());
            this.rs.setValue("FFrom", this.tbl.getCell(i, 2).getValue());
            this.rs.setValue("FTo", this.tbl.getCell(i, 3).getValue());
            ++i;
        }
        rm.setProperty("rs", (Object)this.rs);
        return rm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        this.setTag(1);
        RptConditionManager rm = new RptConditionManager(params, new String[]{"rs"});
        rm.restoreAllStatus((Container)((Object)this));
        this.rs = (RptRowSet)rm.getProperty("rs");
        this.setTableData();
        this.setTag(0);
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        int yearEnd = (Integer)this.jspYearTo.getValue();
        if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), (int)yearEnd, (int)(yearBegin = ((Integer)this.jspYearFrom.getValue()).intValue()), (int)(numberBegin = ((Integer)this.jspPeriodFrom.getValue()).intValue()))) {
            return false;
        }
        if (this.jebAccount.getValue() == null) {
            this.jebAccount.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes((String)"select_accountView_please"));
            return false;
        }
        if (this.rs == null) {
            this.jebAccount.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes((String)"reSelect_accountView_for_incorrectness_act"));
            return false;
        }
        boolean s = false;
        this.getCustomCondition();
        this.rs.reset();
        while (this.rs.next()) {
            if (this.rs.getObject("FSelected") == null || !((Boolean)this.rs.getObject("FSelected")).booleanValue()) continue;
            s = true;
            break;
        }
        if (!s) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes((String)"select_act_item_please"));
            return false;
        }
        if (this.jbxCurrency.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"44_BCAsstactXBalanceConditionUI"));
            this.jbxCurrency.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public void clear() {
        this.jbxCurrency.setSelectedIndex(-1);
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            this.tbl.getRow(i).getCell("selected").setValue((Object)new Boolean(false));
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }
}

