/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollRptFilterInfo;
import com.kingdee.eas.cp.bc.BizCollRptUtil;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.client.AbstractBizCollReportQueryUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class BizCollReportQueryUI
extends AbstractBizCollReportQueryUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(BizCollReportQueryUI.class);
    Map paramMap = null;
    Set OrgRangeSet = null;
    boolean isDelimitOrgScope = false;
    public static final int PERIOD_TYPE_MONTH = 0;
    public static final int PERIOD_TYPE_QUARTER = 1;
    public static final int PERIOD_TYPE_YEAR = 2;
    public static final int PERIOD_TYPE_PERIOD = 3;
    private static final int MONTHS_OF_YEAR = 12;
    private static final int MONTHS_OF_QUARTER = 3;
    boolean hasInit = false;
    AdminF7 adminF7 = new AdminF7((IUIObject)this);
    CompanyF7 compF7 = new CompanyF7((IUIObject)this);

    public BizCollReportQueryUI() throws Exception {
        this.initF7();
        this.initState();
        Color color = this.getBackground();
        this.pnlObj.setBackground(color);
        this.pnlRange.setBackground(color);
        this.initDefaultSchema();
    }

    public void initState() {
        Locale local = SysContext.getSysContext().getLocale();
        DefaultComboBoxModel<IntvlType> model = new DefaultComboBoxModel<IntvlType>();
        model.addElement(new IntvlType("0", ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BizCollResource.ALL", (Locale)local)));
        model.addElement(new IntvlType(String.valueOf(20), StateEnum.DRAFT.getAlias()));
        model.addElement(new IntvlType(String.valueOf(25), StateEnum.SUBMIT.getAlias()));
        model.addElement(new IntvlType(String.valueOf(30), StateEnum.CHECKING.getAlias()));
        model.addElement(new IntvlType(String.valueOf(60), StateEnum.CHECKED.getAlias()));
        model.addElement(new IntvlType(String.valueOf(40), StateEnum.CHECKFAILD.getAlias()));
        String type = (String)SysContext.getSysContext().getProperty((Object)"type");
        if (type == null || !type.equals("req")) {
            model.addElement(new IntvlType(String.valueOf(45), StateEnum.ALREADYVOUCHER.getAlias()));
            model.addElement(new IntvlType(String.valueOf(65), StateEnum.ISPAYBILL.getAlias()));
            model.addElement(new IntvlType(String.valueOf(70), StateEnum.ALREADYPAYMENT.getAlias()));
        }
        model.addElement(new IntvlType(String.valueOf(80), StateEnum.CLOSED.getAlias()));
        this.kdcbState.setModel(model);
    }

    private void initF7() {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP019");
        try {
            this.paramMap = ExpenseCommenFacadeFactory.getRemoteInstance().getParams(paramList);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        boolean bl = this.isDelimitOrgScope = this.paramMap.get("CP019") == null ? false : new Boolean(this.paramMap.get("CP019").toString());
        if (this.isDelimitOrgScope) {
            String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            try {
                this.OrgRangeSet = MakeControl.getOrgIdsByUserAndType(userid, OrgRangeType.BIZ_ORG_TYPE, null);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        this.paramMap.put("CP019", new Boolean(this.isDelimitOrgScope));
        this.prmtPerson.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this));
        this.prmtOrg.setEnabled(true);
        this.lblQuery.setEnabled(true);
        this.prmtOrg.setDisplayFormat("$name$");
        this.prmtOrg.setEditFormat("$number$");
        this.prmtOrg.setCommitFormat("$number$");
        this.prmtOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtPerson.setDisplayFormat("$name$");
        this.prmtPerson.setEditFormat("$number$");
        this.prmtPerson.setCommitFormat("$number$");
        this.prmtPerson.setQueryInfo("com.kingdee.eas.basedata.org.app.PositionQuery");
        this.pkEndDate.addDataChangeListener((DataChangeListener)this);
        this.pkBeginDate.addDataChangeListener((DataChangeListener)this);
        CompanyOrgUnitInfo info = null;
        MakeControl.makeCostCenterF7(this.prmpCostCenter, info, this.paramMap, this.OrgRangeSet);
        MakeControl.makeCostTargetBizQuery(this.prmpCostObj);
        MakeControl.makePayMode(this.prmpPayMode);
        this.prmpPayMode.setRequired(false);
    }

    public void dataChanged(DataChangeEvent arg0) {
        this.initInterval(this.getIntervalTypeByDate((Date)this.pkBeginDate.getValue(), (Date)this.pkEndDate.getValue()));
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void clear() {
        this.prmtOrg.setValue(null);
        this.prmpCostCenter.setValue(null);
        this.prmpCostObj.setValue(null);
        this.prmtPerson.setValue(null);
        this.prmpPayMode.setValue(null);
        this.btnMonth.setSelected(false);
        this.btnQuarter.setSelected(false);
        this.btnYear.setSelected(false);
        this.btnPeriod.setSelected(false);
        this.pkBeginDate.setEnabled(false);
        this.pkEndDate.setEnabled(false);
        this.lblTo.setEnabled(false);
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    private boolean checkInput() {
        return true;
    }

    public boolean verify() {
        try {
            this.checkError();
            return true;
        }
        catch (ExpAccException ite) {
            MsgBox.showInfo((String)ite.getMessage());
            return false;
        }
    }

    private void checkError() throws ExpAccException {
        Date dtTo;
        if (this.pkBeginDate.getValue() == null || this.pkEndDate.getValue() == null) {
            return;
        }
        Date dtFrom = (Date)this.pkBeginDate.getValue();
        if (dtFrom.compareTo(dtTo = (Date)this.pkEndDate.getValue()) > 0) {
            throw new ExpAccException(ExpAccException.REQDATE_FROM_GT_TO);
        }
    }

    public Object getParam() {
        HashMap<String, BizCollRptFilterInfo> map = new HashMap<String, BizCollRptFilterInfo>();
        map.put("qryFilter", this.getQryFilter());
        this.getUIContext().put("filterInfo", map.get("qryFilter"));
        return map;
    }

    public void setParam(Object param) {
        if (param == null) {
            try {
                this.initDefaultSchema();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            HashMap map = (HashMap)param;
            BizCollRptFilterInfo qryFilter = (BizCollRptFilterInfo)map.get("qryFilter");
            try {
                this.setDatas(qryFilter);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CustomerParams result = cp;
        this.clear();
        if (result == null) {
            try {
                this.initDefaultSchema();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            String qryFilterStr = result.getCustomerParam("qryFilter");
            BizCollRptFilterInfo qryFilter = this.StringToBizCollRptFilterInfo(qryFilterStr);
            try {
                this.setDatas(qryFilter);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        HashMap<String, BizCollRptFilterInfo> map = new HashMap<String, BizCollRptFilterInfo>();
        BizCollRptFilterInfo qryFilter = this.getQryFilter();
        String qryFilterStr = this.bizCollRptFilterInfoToString(qryFilter);
        cp.addCustomerParam("qryFilter", qryFilterStr);
        map.put("qryFilter", this.getQryFilter());
        this.getUIContext().put("filterInfo", map.get("qryFilter"));
        return cp;
    }

    public String bizCollRptFilterInfoToString(BizCollRptFilterInfo qryFilter) {
        StringBuffer qryFilterStr = new StringBuffer();
        qryFilterStr.append(0).append(",");
        qryFilterStr.append(1).append(",");
        String id = null;
        if (qryFilter.companyInfo != null) {
            id = qryFilter.companyInfo.getId().toString();
        }
        qryFilterStr.append(id).append(",");
        id = null;
        if (qryFilter.adminInfo != null) {
            id = qryFilter.adminInfo.getId().toString();
        }
        qryFilterStr.append(id).append(",");
        id = null;
        if (qryFilter.applier != null) {
            id = qryFilter.applier.getId().toString();
        }
        qryFilterStr.append(id).append(",");
        id = null;
        if (qryFilter.costOrg != null) {
            id = qryFilter.costOrg.getId().toString();
        }
        qryFilterStr.append(id).append(",");
        id = null;
        if (qryFilter.costObj != null) {
            id = qryFilter.costObj.getId().toString();
        }
        qryFilterStr.append(id).append(",");
        qryFilterStr.append(qryFilter.state).append(",");
        qryFilterStr.append(qryFilter.periodType).append(",");
        qryFilterStr.append(qryFilter.intervalType).append(",");
        DateFormat df = MultilingualUtil.getDateFormat();
        qryFilterStr.append(df.format(qryFilter.beginDate)).append(",");
        qryFilterStr.append(df.format(qryFilter.endDate)).append(",");
        qryFilterStr.append(df.format(qryFilter.ctrlBeginDate)).append(",");
        qryFilterStr.append(df.format(qryFilter.ctrlEndDate)).append(",");
        qryFilterStr.append(qryFilter.numberOfYears).append(",");
        qryFilterStr.append(qryFilter.typeStat).append(",");
        qryFilterStr.append(qryFilter.isIncludeSubCUs).append(",");
        qryFilterStr.append(qryFilter.isTotal).append(",");
        qryFilterStr.append(qryFilter.level).append(",");
        id = null;
        if (qryFilter.currentCU != null) {
            id = qryFilter.currentCU.getId().toString();
        }
        qryFilterStr.append(id).append(",");
        qryFilterStr.append(qryFilter.isFromReport).append(",");
        qryFilterStr.append(qryFilter.objType);
        qryFilterStr.append(",");
        id = null;
        if (qryFilter.settlementTypeInfo != null) {
            id = qryFilter.settlementTypeInfo.getId().toString();
        }
        qryFilterStr.append(id);
        return qryFilterStr.toString();
    }

    public BizCollRptFilterInfo StringToBizCollRptFilterInfo(String qryFilterStr) {
        BizCollRptFilterInfo qryFilter = new BizCollRptFilterInfo();
        String[] qryFilterStrArray = qryFilterStr.split(",");
        String id = qryFilterStrArray[2];
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (id != null && !id.equals("null")) {
            try {
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                companyOrgUnitInfo = (CompanyOrgUnitInfo)iCompany.getValue((IObjectPK)new ObjectUuidPK(id));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        qryFilter.companyInfo = companyOrgUnitInfo;
        id = qryFilterStrArray[3];
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (id != null && !id.equals("null")) {
            try {
                IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
                adminOrgUnitInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        qryFilter.adminInfo = adminOrgUnitInfo;
        id = qryFilterStrArray[4];
        if (id != null && !id.equals("null")) {
            qryFilter.applier = (PersonInfo)BizCollUtil.returnObjectValueById(id);
        }
        id = qryFilterStrArray[5];
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        if (id != null && !id.equals("null")) {
            try {
                ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
                costCenterOrgUnitInfo = iCostCenterOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        qryFilter.costOrg = costCenterOrgUnitInfo;
        id = qryFilterStrArray[6];
        CostObjectInfo costObjectInfo = null;
        if (id != null && !id.equals("null")) {
            try {
                ICostObject iCostObject = CostObjectFactory.getRemoteInstance();
                costObjectInfo = iCostObject.getCostObjectInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        qryFilter.costObj = costObjectInfo;
        qryFilter.state = Integer.parseInt(qryFilterStrArray[7]);
        qryFilter.periodType = Integer.parseInt(qryFilterStrArray[8]);
        qryFilter.intervalType = qryFilterStrArray[9];
        DateFormat df = MultilingualUtil.getDateFormat();
        try {
            qryFilter.beginDate = df.parse(qryFilterStrArray[10]);
            qryFilter.endDate = df.parse(qryFilterStrArray[11]);
            Calendar calendarEnd = Calendar.getInstance();
            calendarEnd.setTime(df.parse(qryFilterStrArray[11]));
            calendarEnd.add(5, 1);
            calendarEnd.add(14, -1);
            qryFilter.endDate = calendarEnd.getTime();
            qryFilter.ctrlBeginDate = df.parse(qryFilterStrArray[12]);
            qryFilter.ctrlEndDate = df.parse(qryFilterStrArray[13]);
        }
        catch (ParseException e) {
            super.handUIException((Throwable)e);
        }
        qryFilter.numberOfYears = Integer.parseInt(qryFilterStrArray[14]);
        qryFilter.typeStat = qryFilterStrArray[15];
        qryFilter.isIncludeSubCUs = Boolean.valueOf(qryFilterStrArray[16]);
        qryFilter.isTotal = Boolean.valueOf(qryFilterStrArray[17]);
        qryFilter.level = Integer.parseInt(qryFilterStrArray[18]);
        id = qryFilterStrArray[19];
        CtrlUnitInfo ctrlUnitInfo = null;
        if (id != null && !id.equals("null")) {
            try {
                ICtrlUnit iCtrlUnit = CtrlUnitFactory.getRemoteInstance();
                ctrlUnitInfo = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        qryFilter.currentCU = ctrlUnitInfo;
        qryFilter.isFromReport = Boolean.valueOf(qryFilterStrArray[20]);
        if (qryFilterStrArray.length > 22) {
            qryFilter.objType = Integer.parseInt(qryFilterStrArray[21]);
            id = qryFilterStrArray[22];
            SettlementTypeInfo settlementTypeInfo = null;
            try {
                if (id != null && !id.equals("null")) {
                    settlementTypeInfo = SettlementTypeFactory.getRemoteInstance().getSettlementTypeInfo((IObjectPK)new ObjectUuidPK(id));
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
            qryFilter.settlementTypeInfo = settlementTypeInfo;
        }
        return qryFilter;
    }

    public BizCollRptFilterInfo getQryFilter() {
        BizCollRptFilterInfo qryFilter = new BizCollRptFilterInfo();
        qryFilter.ctrlBeginDate = (Date)this.pkBeginDate.getValue();
        qryFilter.ctrlEndDate = (Date)this.pkEndDate.getValue();
        if (this.btnOrg.isSelected()) {
            qryFilter.objType = 0;
            qryFilter.typeStat = "admin";
            qryFilter.adminInfo = (AdminOrgUnitInfo)this.prmtOrg.getValue();
        } else if (this.btnCompany.isSelected()) {
            qryFilter.objType = 1;
            qryFilter.typeStat = "company";
            qryFilter.companyInfo = (CompanyOrgUnitInfo)this.prmtOrg.getValue();
        } else if (this.btnPerson.isSelected()) {
            qryFilter.objType = 2;
            qryFilter.typeStat = "person";
            qryFilter.applier = (PersonInfo)this.prmtOrg.getValue();
        } else {
            qryFilter.objType = -1;
        }
        qryFilter.periodType = this.btnMonth.isSelected() ? 0 : (this.btnYear.isSelected() ? 2 : (this.btnQuarter.isSelected() ? 1 : (this.btnPeriod.isSelected() ? 3 : -1)));
        Date[] dates = this.getDates(qryFilter.periodType);
        qryFilter.beginDate = dates[0];
        qryFilter.endDate = dates[1];
        IntvlType intervalType = (IntvlType)this.comboRange.getSelectedItem();
        qryFilter.intervalType = intervalType == null ? "quarter" : intervalType.getValue();
        qryFilter.costOrg = (CostCenterOrgUnitInfo)this.prmpCostCenter.getValue();
        qryFilter.costObj = (CostObjectInfo)this.prmpCostObj.getValue();
        qryFilter.state = this.getSelectedState();
        qryFilter.settlementTypeInfo = (SettlementTypeInfo)this.prmpPayMode.getValue();
        return qryFilter;
    }

    public void loadData(EntityViewInfo view) {
        super.loadData(view);
    }

    private void setDatas(BizCollRptFilterInfo qryFilter) throws Exception {
        switch (qryFilter.objType) {
            case -1: {
                this.btnOrg.setSelected(false);
                this.btnPerson.setSelected(false);
                break;
            }
            case 0: {
                this.btnOrg.setSelected(true);
                this.btnCompany.setSelected(false);
                this.btnPerson.setSelected(false);
                this.prmtOrg.setValue((Object)qryFilter.adminInfo);
                break;
            }
            case 1: {
                this.btnOrg.setSelected(false);
                this.btnCompany.setSelected(true);
                this.btnPerson.setSelected(false);
                this.prmtOrg.setValue((Object)qryFilter.companyInfo);
                break;
            }
            case 2: {
                this.btnOrg.setSelected(false);
                this.btnCompany.setSelected(false);
                this.btnPerson.setSelected(true);
                this.prmtOrg.setValue((Object)qryFilter.applier);
                break;
            }
        }
        this.prmpCostCenter.setValue((Object)qryFilter.costOrg);
        this.prmpCostObj.setValue((Object)qryFilter.costObj);
        this.setSelectedState(qryFilter.state);
        this.queryObj_radioButtonClick(false);
        switch (qryFilter.periodType) {
            case -1: {
                this.btnMonth.setSelected(false);
                this.btnQuarter.setSelected(false);
                this.btnYear.setSelected(false);
                this.btnPeriod.setSelected(false);
                break;
            }
            case 0: {
                this.btnMonth.setSelected(true);
                this.btnQuarter.setSelected(false);
                this.btnYear.setSelected(false);
                this.btnPeriod.setSelected(false);
                break;
            }
            case 1: {
                this.btnMonth.setSelected(false);
                this.btnQuarter.setSelected(true);
                this.btnYear.setSelected(false);
                this.btnPeriod.setSelected(false);
                break;
            }
            case 2: {
                this.btnMonth.setSelected(false);
                this.btnQuarter.setSelected(false);
                this.btnYear.setSelected(true);
                this.btnPeriod.setSelected(false);
                break;
            }
            case 3: {
                this.btnMonth.setSelected(false);
                this.btnQuarter.setSelected(false);
                this.btnYear.setSelected(false);
                this.btnPeriod.setSelected(true);
            }
        }
        this.pkBeginDate.setValue((Object)qryFilter.ctrlBeginDate);
        this.pkEndDate.setValue((Object)qryFilter.ctrlEndDate);
        this.queryRange_radioButtonClick();
        if (qryFilter.intervalType != null) {
            int size = this.comboRange.getItemCount();
            for (int i = 0; i < size; ++i) {
                if (!((IntvlType)this.comboRange.getItemAt(i)).getValue().equals(qryFilter.intervalType)) continue;
                this.comboRange.setSelectedIndex(i);
                break;
            }
        } else {
            this.comboRange.setSelectedItem(null);
        }
        this.prmpPayMode.setValue((Object)qryFilter.settlementTypeInfo);
    }

    private int getSelectedState() {
        IntvlType ob = (IntvlType)this.kdcbState.getSelectedItem();
        return Integer.parseInt(ob.getValue());
    }

    private void setSelectedState(int sEnum) {
        Enumeration e = this.grpState.getElements();
        int count = 0;
        int bc = this.grpState.getButtonCount();
        while (e.hasMoreElements()) {
            KDRadioButton ab = (KDRadioButton)e.nextElement();
            if (sEnum == ab.getMnemonic()) {
                this.grpState.setSelected(ab.getModel(), true);
            }
            if (++count <= bc) continue;
            break;
        }
    }

    private Date[] getDates(int periodType) {
        Date[] dates = new Date[2];
        if (periodType != -1) {
            Date today = new Date();
            String intvlType = ((IntvlType)this.comboRange.getSelectedItem()).getValue();
            if (periodType != 3) {
                if (periodType == 2) {
                    dates[0] = new Date(today.getYear(), 0, 1);
                    dates[1] = new Date(today.getYear(), 11, 31);
                } else if (periodType == 1) {
                    int quarter = DateTimeUtils.getQuarter((Date)today);
                    dates[0] = new Date(today.getYear(), 3 * (quarter - 1), 1);
                    dates[1] = quarter == 4 ? DateTimeUtils.addDay((Date)new Date(today.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), dates[0].getMonth() + 3, 1), (long)-1L);
                } else if (periodType == 0) {
                    dates[0] = new Date(today.getYear(), today.getMonth(), 1);
                    int month = today.getMonth();
                    dates[1] = month == 11 ? DateTimeUtils.addDay((Date)new Date(today.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), month + 1, 1), (long)-1L);
                }
            } else {
                dates[0] = (Date)this.pkBeginDate.getValue();
                dates[1] = (Date)this.pkEndDate.getValue();
                Date end = (Date)this.pkEndDate.getValue();
                Calendar calendarEnd = Calendar.getInstance();
                calendarEnd.setTime(end);
                calendarEnd.add(5, 1);
                calendarEnd.add(14, -1);
                dates[1] = end = calendarEnd.getTime();
            }
        } else {
            dates[0] = (Date)this.pkBeginDate.getValue();
            dates[1] = (Date)this.pkEndDate.getValue();
        }
        return dates;
    }

    public void initDefaultSchema() throws Exception {
        if (!this.hasInit) {
            this.btnOrg.setSelected(true);
            this.queryObj_radioButtonClick(false);
            this.btnYear.setSelected(true);
            this.queryRange_radioButtonClick();
            int size = this.comboRange.getItemCount();
            for (int i = 0; i < size; ++i) {
                if (!((IntvlType)this.comboRange.getItemAt(i)).getValue().equals("quarter")) continue;
                this.comboRange.setSelectedIndex(i);
                break;
            }
            this.hasInit = true;
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOrg_actionPerformed(ActionEvent e) throws Exception {
        super.btnOrg_actionPerformed(e);
        this.queryObj_radioButtonClick(true);
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        this.queryObj_radioButtonClick(true);
    }

    @Override
    protected void btnPerson_actionPerformed(ActionEvent e) throws Exception {
        this.queryObj_radioButtonClick(true);
    }

    @Override
    protected void btnOrg_keyTyped(KeyEvent e) throws Exception {
        super.btnOrg_keyTyped(e);
        this.queryObj_radioButtonClick(true);
    }

    private void queryObj_radioButtonClick(boolean isClear) throws Exception {
        if (isClear) {
            this.prmtOrg.setData(null);
        }
        if (this.btnOrg.isSelected()) {
            this.prmtOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
            this.adminF7.setIsCUFilter(true);
            this.adminF7.disablePerm(null, false);
            this.prmtOrg.setSelector((KDPromptSelector)this.adminF7);
            this.lblQuery.setText(this.btnOrg.getText());
        } else if (this.btnCompany.isSelected()) {
            this.prmtOrg.setSelector(null);
            this.prmtOrg.setQueryInfo(null);
            MakeControl.makeCompanyF7(this.prmtOrg, (CoreUIObject)this, this.paramMap, this.OrgRangeSet);
            this.lblQuery.setText(this.btnCompany.getText());
        } else {
            this.prmtOrg.setSelector(null);
            this.prmtOrg.setQueryInfo(null);
            MakeControl.makeApplierF7(this.prmtOrg, (CoreUIObject)this);
            this.lblQuery.setText(this.btnPerson.getText());
        }
    }

    @Override
    protected void prmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrg_dataChanged(e);
    }

    @Override
    protected void prmtPerson_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPerson_dataChanged(e);
    }

    private void queryRange_radioButtonClick() {
        if (!this.comboRange.isEnabled()) {
            this.comboRange.setEnabled(true);
            this.lblPeriod.setEnabled(true);
        }
        if (this.btnMonth.isSelected()) {
            this.pkBeginDate.setEnabled(false);
            this.pkEndDate.setEnabled(false);
            this.lblTo.setEnabled(false);
            this.initInterval("month");
        } else if (this.btnQuarter.isSelected()) {
            this.pkBeginDate.setEnabled(false);
            this.pkEndDate.setEnabled(false);
            this.lblTo.setEnabled(false);
            this.initInterval("quarter");
        } else if (this.btnYear.isSelected()) {
            this.pkBeginDate.setEnabled(false);
            this.pkEndDate.setEnabled(false);
            this.lblTo.setEnabled(false);
            this.initInterval("year");
        } else if (this.btnPeriod.isSelected()) {
            this.pkBeginDate.setEnabled(true);
            this.pkEndDate.setEnabled(true);
            this.lblTo.setEnabled(true);
            this.initInterval(this.getIntervalTypeByDate((Date)this.pkBeginDate.getValue(), (Date)this.pkEndDate.getValue()));
        }
    }

    private String getIntervalTypeByDate(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return "month";
        }
        int beginYear = DateTimeUtils.getYear((Date)beginDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int beginMonth = DateTimeUtils.getMonth((Date)beginDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int interval = (endYear - beginYear) * 12 + (endMonth - beginMonth);
        if (interval >= 11) {
            return "year";
        }
        if (interval >= 2) {
            return "quarter";
        }
        return "month";
    }

    private void initInterval(String type) {
        DefaultComboBoxModel<IntvlType> model = new DefaultComboBoxModel<IntvlType>();
        if (type.endsWith("month")) {
            model.addElement(new IntvlType("month", BizCollRptUtil.ALIAS_MONTH));
        } else if (type.endsWith("quarter")) {
            model.addElement(new IntvlType("month", BizCollRptUtil.ALIAS_MONTH));
            model.addElement(new IntvlType("quarter", BizCollRptUtil.ALIAS_QUARTER));
        } else {
            model.addElement(new IntvlType("month", BizCollRptUtil.ALIAS_MONTH));
            model.addElement(new IntvlType("quarter", BizCollRptUtil.ALIAS_QUARTER));
            model.addElement(new IntvlType("year", BizCollRptUtil.ALIAS_YEAR));
        }
        this.comboRange.setModel(model);
    }

    @Override
    protected void btnMonth_actionPerformed(ActionEvent e) throws Exception {
        super.btnMonth_actionPerformed(e);
        this.queryRange_radioButtonClick();
    }

    @Override
    protected void btnQuarter_actionPerformed(ActionEvent e) throws Exception {
        super.btnQuarter_actionPerformed(e);
        this.queryRange_radioButtonClick();
    }

    @Override
    protected void btnYear_actionPerformed(ActionEvent e) throws Exception {
        super.btnYear_actionPerformed(e);
        this.queryRange_radioButtonClick();
    }

    @Override
    protected void btnPeriod_actionPerformed(ActionEvent e) throws Exception {
        super.btnPeriod_actionPerformed(e);
        this.queryRange_radioButtonClick();
    }

    @Override
    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkBeginDate_dataChanged(e);
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkEndDate_dataChanged(e);
    }

    public class IntvlType {
        String _value;
        String _alias;

        public IntvlType(String value, String alias) {
            this._value = value;
            this._alias = alias;
        }

        public String getValue() {
            return this._value;
        }

        public String getAlias() {
            return this._alias;
        }

        public String toString() {
            return this._alias;
        }
    }
}

