/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollRptFilterInfo;
import com.kingdee.eas.cp.bc.BizCollRptUtil;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ForPrintFacadeFactory;
import com.kingdee.eas.cp.bc.IForPrintFacade;
import com.kingdee.eas.cp.bc.client.AbstractBizCollRpt;
import com.kingdee.eas.cp.bc.client.BizCollReportQueryUI;
import com.kingdee.eas.cp.bc.client.ExpenseActRpt;
import com.kingdee.eas.cp.bc.client.ExpenseReqRpt;
import com.kingdee.eas.cp.bc.client.LoanRpt;
import com.kingdee.eas.cp.bc.util.CurrencyUtil;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.cp.bc.util.OutputExcelUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public abstract class BizCollRpt
extends AbstractBizCollRpt {
    private static final Logger logger = CoreUIObject.getLogger(BizCollRpt.class);
    public static final int FNAME_COL_WIDTH = 160;
    public static final int ISEXPENSE_COL_WIDTH = 90;
    public static final int NOEXPENSE_COL_WIDTH = 90;
    public static final int TOTAL_COL_WIDTH = 90;
    public static final int MOUTH_COL_WIDTH = 90;
    private BizCollRptFilterInfo filterInfo = null;
    public int time = 0;
    private static final javax.swing.Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final javax.swing.Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    int groupCount = -1;
    int beginYear = -1;
    int beginMonth = -1;
    int endYear = -1;
    int endMonth = -1;
    int beginQuarter = -1;
    int endQuarter = -1;
    int index = 0;
    boolean isTree = true;
    private boolean isFirstDefaultQuery = true;
    private PersonInfo personId = null;
    Map rateMap = new HashMap();
    CommonQueryDialog dialog = null;
    BizCollReportQueryUI filterUI = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    public void onLoad() throws Exception {
        if (!BizCollUtil.checkValidPerson()) {
            this.showErrorMessage("com.kingdee.eas.hr.train.client.TrainApplyResource", "userNoPerson", this);
        }
        super.onLoad();
        this.tbMain.getStyleAttributes().setLocked(true);
        this.tbMain.addKDTMouseListener((KDTMouseListener)new ExpenseTableListen(this.tbMain, "FName"));
        this.tbMain.checkParsed();
        this.enableExportExcel(this.tbMain);
        if (this.getUIContext().get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS") != null) {
            this.filterInfo = (BizCollRptFilterInfo)this.getUIContext().get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS");
            this.initUI();
        } else {
            this.showFilterUI(false);
        }
        this.menuExport.setAccelerator(KeyStroke.getKeyStroke(69, 192, false));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke(123, 192, false));
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected KDTable getTableForOA() {
        return this.tbMain;
    }

    public void showErrorMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)this.getResource(RES, message));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public String getResource(String RES, String message) {
        return EASResource.getString((String)RES, (String)message);
    }

    private void initFilter() {
        this.beginYear = DateTimeUtils.getYear((Date)this.filterInfo.beginDate);
        this.endYear = DateTimeUtils.getYear((Date)this.filterInfo.endDate);
        this.beginMonth = this.filterInfo.beginDate.getMonth();
        this.endMonth = this.filterInfo.endDate.getMonth();
        this.beginQuarter = DateTimeUtils.getQuarter((Date)this.filterInfo.beginDate);
        this.endQuarter = DateTimeUtils.getQuarter((Date)this.filterInfo.endDate);
        this.contFrom.setBoundLabelText(MultilingualUtil.formatDate(this.filterInfo.beginDate));
        this.contTo.setBoundLabelText(MultilingualUtil.formatDate(this.filterInfo.endDate));
        if ("admin".equals(this.filterInfo.typeStat)) {
            if (this.filterInfo.adminInfo != null) {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("admin"));
                this.contName.setBoundLabelText(this.filterInfo.adminInfo.getName());
            } else {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("admin"));
                if (SysContext.getSysContext().getCurrentAdminUnit() != null) {
                    this.contName.setBoundLabelText(SysContext.getSysContext().getCurrentAdminUnit().getName());
                }
            }
        } else if ("company".equals(this.filterInfo.typeStat)) {
            if (this.filterInfo.companyInfo != null) {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("company"));
                this.contName.setBoundLabelText(this.filterInfo.companyInfo.getName());
            } else {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("company"));
                if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                    this.contName.setBoundLabelText(SysContext.getSysContext().getCurrentFIUnit().getName());
                }
            }
        } else if ("person".equals(this.filterInfo.typeStat)) {
            if (this.filterInfo.applier != null) {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("person"));
                this.contName.setBoundLabelText(this.filterInfo.applier.getName());
            } else {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("person"));
                if (this.getApplier() != null) {
                    this.contName.setBoundLabelText(this.getApplier().getName());
                } else {
                    this.contName.setBoundLabelText("");
                }
            }
        }
        if (this.filterInfo.costObj != null) {
            this.contCtObj.setBoundLabelText(this.filterInfo.costObj.getName());
        } else {
            this.contCtObj.setBoundLabelText("");
        }
        if (this.filterInfo.costOrg != null) {
            this.contOrg.setBoundLabelText(this.filterInfo.costOrg.getName());
        } else {
            this.contOrg.setBoundLabelText("");
        }
        if (this.filterInfo.intervalType.equals("year")) {
            this.groupCount = this.endYear + 1 - this.beginYear;
        } else if (this.filterInfo.intervalType.equals("quarter")) {
            this.groupCount = (this.endYear - this.beginYear) * 4 + (this.endQuarter - this.beginQuarter + 1);
        } else if (this.filterInfo.intervalType.equals("month")) {
            this.groupCount = (this.endYear - this.beginYear) * 12 + (this.endMonth - this.beginMonth + 1);
        }
        ++this.beginMonth;
        ++this.endMonth;
        if (!this.filterInfo.isFromReport || this.time > 0) {
            this.filterInfo.currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        ++this.time;
    }

    private void initUI() {
        this.initData();
    }

    private void clearTable() {
        this.tbMain.removeHeadRows();
        this.tbMain.removeRows();
        this.tbMain.removeColumns();
    }

    public String getPercentFmtStr() {
        return "#,##0.00_ ";
    }

    private String getColNameSuffix(int curGroup) {
        String suffix = "_";
        int year = -1;
        int num = -1;
        if (this.filterInfo.intervalType.equals("year")) {
            suffix = suffix + (this.beginYear + curGroup - 1);
        } else if (this.filterInfo.intervalType.equals("quarter")) {
            num = (this.beginQuarter + curGroup - 1) % 4;
            year = (this.beginQuarter + curGroup - 1) / 4 + this.beginYear;
            if (num == 0) {
                num = 4;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "quarter";
        } else if (this.filterInfo.intervalType.equals("month")) {
            num = (this.beginMonth + curGroup - 1) % 12;
            year = (this.beginMonth + curGroup - 1) / 12 + this.beginYear;
            if (num == 0) {
                num = 12;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "month";
        }
        return suffix;
    }

    private String getHeaderCellAlias(String cellName, int index) {
        if (cellName.equals("FID")) {
            return "FID";
        }
        if (cellName.equals("FName")) {
            if (this.filterInfo.typeStat == null) {
                return "";
            }
            if ("admin".equals(this.filterInfo.typeStat)) {
                return BizCollRptUtil.getAlias("admin");
            }
            if ("company".equals(this.filterInfo.typeStat)) {
                return BizCollRptUtil.getAlias("company");
            }
            if ("person".equals(this.filterInfo.typeStat)) {
                return BizCollRptUtil.getAlias("person");
            }
        } else {
            if (cellName.equals("total")) {
                return BizCollRptUtil.getAlias("total");
            }
            String[] strArry = StringUtils.split((String)cellName, (String)"_");
            if (index == 0) {
                if (strArry.length == 2) {
                    return MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BizCollResource", (String)"searchYear"), String.valueOf(strArry[1]));
                }
                if ("month".equals(strArry[3])) {
                    return MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BizCollResource", (String)"yearAndMonth"), String.valueOf(strArry[1]), String.valueOf(strArry[2]));
                }
                return MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BizCollResource", (String)"searchQuarter"), String.valueOf(strArry[1]), String.valueOf(strArry[2]));
            }
            return BizCollRptUtil.getAlias(strArry[0]);
        }
        return "";
    }

    protected void setTableStyle() {
        this.tbMain.getColumn("FID").getStyleAttributes().setHided(true);
    }

    protected abstract String getType();

    protected void getSubColumn(KDTable tbMain, String colNameSuffix) {
        IColumn col = null;
        col = tbMain.addColumn();
        col.setKey("isExpense" + colNameSuffix);
        col.setWidth(90);
        col.getStyleAttributes().setNumberFormat(this.getPercentFmtStr());
        col = tbMain.addColumn();
        col.setKey("noExpense" + colNameSuffix);
        col.setWidth(90);
        col.getStyleAttributes().setNumberFormat(this.getPercentFmtStr());
        col = tbMain.addColumn();
        col.setKey("subTotal" + colNameSuffix);
        col.setWidth(90);
        col.getStyleAttributes().setNumberFormat(this.getPercentFmtStr());
    }

    protected void initTableColumn() {
        IColumn col = null;
        col = this.tbMain.addColumn();
        col.setKey("FID");
        col = this.tbMain.addColumn();
        col.setKey("FName");
        col.setWidth(160);
        String colNameSuffix = null;
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            this.getSubColumn(this.tbMain, colNameSuffix);
        }
        col = this.tbMain.addColumn();
        col.setKey("total");
        col.setWidth(90);
        col.getStyleAttributes().setNumberFormat(this.getPercentFmtStr());
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void initTableHeader() {
        IRow row = null;
        String key = null;
        row = this.tbMain.addHeadRow();
        int size = this.tbMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            key = this.tbMain.getColumnKey(i);
            row.getCell(key).setValue((Object)this.getHeaderCellAlias(key, 0));
        }
        row = this.tbMain.addHeadRow();
        String value = null;
        int size2 = this.tbMain.getColumnCount();
        for (int i = 0; i < size2; ++i) {
            key = this.tbMain.getColumnKey(i);
            value = this.getHeaderCellAlias(key, 1);
            row.getCell(key).setValue((Object)value);
        }
        KDTMergeManager merger = this.tbMain.getHeadMergeManager();
        merger.mergeBlock(0, 0, 1, 0, 3);
        merger.mergeBlock(0, 1, 1, 1, 3);
        for (int i = 0; i < this.groupCount; ++i) {
            merger.mergeBlock(0, 2 + i * 3, 0, 2 + (i + 1) * 3 - 1, 3);
        }
        merger.mergeBlock(0, 2 + this.groupCount * 3, 1, 2 + this.groupCount * 3, 3);
    }

    public String getFilter() {
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        if (this.filterInfo.state > 0) {
            sb.append(" FState=" + this.filterInfo.state);
            isFirst = false;
        }
        if (this.filterInfo.costObj != null) {
            if (!isFirst) {
                sb.append(" and ");
            }
            sb.append(" FSupportedObjID='" + this.filterInfo.costObj.getId().toString());
            sb.append("'");
            isFirst = false;
        }
        if (this.filterInfo.costOrg != null) {
            if (!isFirst) {
                sb.append(" and ");
            }
            sb.append(" FCostedDeptID='" + this.filterInfo.costOrg.getId().toString());
            sb.append("'");
            isFirst = false;
        }
        if (this.filterInfo.settlementTypeInfo != null) {
            String filedName = "FPayModeId";
            if (this instanceof ExpenseActRpt || this instanceof LoanRpt) {
                if (!isFirst) {
                    sb.append(" and ");
                }
                filedName = "FPayMent";
            } else if (this instanceof ExpenseReqRpt) {
                if (!isFirst) {
                    sb.append(" and ");
                }
                filedName = "FPayModeId";
            }
            sb.append(filedName);
            sb.append("='");
            sb.append(this.filterInfo.settlementTypeInfo.getId().toString());
            sb.append("'");
        }
        sb.append(" ");
        return sb.toString();
    }

    private IRowSet getDatas() throws EASBizException, BOSException {
        IForPrintFacade facade = ForPrintFacadeFactory.getRemoteInstance();
        if ("admin".equals(this.filterInfo.typeStat)) {
            return facade.getAdminRowset(this.filterInfo.beginDate, this.filterInfo.endDate, "", this.getType(), this.getFilter());
        }
        if ("company".equals(this.filterInfo.typeStat)) {
            return facade.getCompRowset(this.filterInfo.beginDate, this.filterInfo.endDate, "", this.getType(), this.getFilter());
        }
        if ("person".equals(this.filterInfo.typeStat)) {
            PersonInfo perId = null;
            perId = this.filterInfo.applier != null ? this.filterInfo.applier : this.getApplier();
            if (perId != null) {
                return facade.getPersonRowset(this.filterInfo.beginDate, this.filterInfo.endDate, perId.getId().toString(), this.getType(), this.getFilter());
            }
        }
        return null;
    }

    private PersonInfo getApplier() {
        if (this.personId == null) {
            try {
                IPerson ip = PersonFactory.getRemoteInstance();
                this.personId = (PersonInfo)ip.getValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId()));
            }
            catch (BOSException e) {
                this.personId = null;
            }
            catch (EASBizException e) {
                this.personId = null;
            }
        }
        return this.personId;
    }

    private DefaultKingdeeTreeNode makeNode(IRowSet rows) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FID", rows.getString("FID"));
        map.put("FName", rows.getString("FName"));
        map.put("FLongNumber", rows.getString("FLongNumber"));
        map.put("FIsLeaf", rows.getBoolean("FIsLeaf"));
        map.put("FLevel", new Integer(rows.getInt("FLevel")));
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("FState", new Integer(rows.getInt("FState")));
        values.put("FAmount", rows.getBigDecimal("FAmount"));
        values.put("FCurrencyID", rows.getString("FCurrencyID"));
        values.put("FLoanState", rows.getString("FLoanState"));
        values.put("FBizReqDate", rows.getDate("FBizReqDate"));
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        if (rows.getBigDecimal("FAmount") != null && !rows.getBigDecimal("FAmount").equals(BizCollUtil.ZERO)) {
            list.add(values);
        }
        map.put("valueList", list);
        logger.debug((Object)rows.getString("FName"));
        return new DefaultKingdeeTreeNode(map);
    }

    private DefaultKingdeeTreeNode getParent(DefaultKingdeeTreeNode node, int levelInteval) {
        DefaultKingdeeTreeNode parent = null;
        if (levelInteval == 0) {
            return (DefaultKingdeeTreeNode)node.getParent();
        }
        parent = (DefaultKingdeeTreeNode)node.getParent();
        return this.getParent(parent, levelInteval - 1);
    }

    private int getLevel(DefaultKingdeeTreeNode node) {
        return (Integer)((HashMap)node.getUserObject()).get("FLevel");
    }

    private String getId(DefaultKingdeeTreeNode node) {
        return ((HashMap)node.getUserObject()).get("FID").toString();
    }

    private void putValues(IRowSet rows, DefaultKingdeeTreeNode node) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("FState", new Integer(rows.getInt("FState")));
        values.put("FAmount", rows.getBigDecimal("FAmount"));
        values.put("FCurrencyID", rows.getString("FCurrencyID"));
        values.put("FLoanState", rows.getString("FLoanState"));
        values.put("FBizReqDate", rows.getDate("FBizReqDate"));
        if (rows.getBigDecimal("FAmount") == null || rows.getBigDecimal("FAmount").equals(BizCollUtil.ZERO)) {
            return;
        }
        HashMap map = (HashMap)node.getUserObject();
        ((ArrayList)map.get("valueList")).add(values);
    }

    private DefaultKingdeeTreeNode getOrgUnitTreeNode() throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        rootNode = BizCollRpt.buildTreeNodeByRowSet(BizCollRpt.getAdminRowSet(this.filterInfo.currentCU, this.filterInfo.adminInfo, false), false);
        return rootNode;
    }

    private HashMap getOrgIDs(String orgTreeID) throws EASBizException, BOSException {
        String cu = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        HashMap displayOrgIds = OrgF7InnerUtils.getAuthorizedOrgViewIDs((IObjectPK)userPK, (OrgViewType)OrgViewType.COMPANY, (IObjectPK)new ObjectUuidPK(orgTreeID), null, null);
        return displayOrgIds;
    }

    private DefaultKingdeeTreeNode getCompanyTreeNode() throws Exception {
        IOrgTree iOrgTree = null;
        OrgTreeInfo orgTree = null;
        DefaultKingdeeTreeNode rootNode = null;
        String rootUnitID = null;
        try {
            iOrgTree = OrgTreeFactory.getRemoteInstance();
            orgTree = iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD"));
            rootUnitID = this.filterInfo.companyInfo == null ? SysContext.getSysContext().getCurrentFIUnit().getId().toString() : this.filterInfo.companyInfo.getId().toString();
            String treeID = orgTree.getId().toString();
            rootNode = (DefaultKingdeeTreeNode)OrgF7InnerUtils.buildTreeModel((String)treeID, (String)rootUnitID, (HashMap)this.getOrgIDs(treeID), (boolean)true, (boolean)false, (boolean)false).getRoot();
        }
        catch (Exception e0) {
            rootNode = new DefaultKingdeeTreeNode();
            rootNode.setUserObject((Object)SysContext.getSysContext().getCurrentFIUnit());
            logger.info((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e0));
        }
        return rootNode;
    }

    private DefaultKingdeeTreeNode getTreeNode(IRowSet rows) throws SQLException, Exception {
        if (rows.size() == 0) {
            return null;
        }
        DefaultKingdeeTreeNode root = null;
        DefaultKingdeeTreeNode curNode = null;
        DefaultKingdeeTreeNode parent = null;
        Object childNode = null;
        int curLevel = -1;
        Object index = null;
        String curId = null;
        int i = 0;
        boolean flag = true;
        while (rows.next()) {
            if (i == 0) {
                root = this.makeNode(rows);
                curLevel = this.getLevel(root);
                curId = this.getId(root);
                curNode = root;
            } else if (!StringUtils.isEmpty(curId) && !curId.equals(rows.getString("FID"))) {
                if (curLevel == rows.getInt("FLevel")) {
                    if (curNode != null && curNode.getParent() != null) {
                        parent = (DefaultKingdeeTreeNode)curNode.getParent();
                    }
                } else {
                    parent = curLevel < rows.getInt("FLevel") ? curNode : this.getParent(curNode, curLevel - rows.getInt("FLevel"));
                }
                curNode = this.makeNode(rows);
                if (parent != null) {
                    parent.add((MutableTreeNode)curNode);
                }
            } else {
                this.putValues(rows, curNode);
            }
            ++i;
            curId = rows.getString("FID");
            curLevel = rows.getInt("FLevel");
        }
        return root;
    }

    private void getDataList(DefaultKingdeeTreeNode treeNode, ArrayList list) {
        list.add(treeNode.getUserObject());
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.getDataList((DefaultKingdeeTreeNode)treeNode.getChildAt(i), list);
        }
    }

    private void getDataList(IRowSet rows, ArrayList list) throws SQLException {
        if (rows == null) {
            return;
        }
        HashMap map1 = new HashMap();
        Map map2 = new HashMap();
        HashMap<String, Object> values = new HashMap<String, Object>();
        String id = null;
        while (rows.next()) {
            ArrayList<HashMap<String, Object>> aList;
            id = rows.getString("FID");
            if (map1.containsKey(id)) {
                map2 = (Map)map1.get(id);
                values = new HashMap();
                values.put("FState", new Integer(rows.getInt("FState")));
                values.put("FAmount", rows.getBigDecimal("FAmount"));
                values.put("FAmountApproved", rows.getBigDecimal("FAmountApproved"));
                values.put("FAmountBalance", rows.getBigDecimal("FAmountBalance"));
                values.put("FAmountUsed", rows.getBigDecimal("FAmountUsed"));
                values.put("FCurrencyID", rows.getString("FCurrencyID"));
                values.put("FBizReqDate", rows.getDate("FBizReqDate"));
                values.put("FLoanState", rows.getString("FLoanState"));
                if (rows.getBigDecimal("FAmount") == null || rows.getBigDecimal("FAmount").equals(BizCollUtil.ZERO)) continue;
                if (map2.get("valueList") == null) {
                    aList = new ArrayList<HashMap<String, Object>>();
                    aList.add(values);
                    map2.put("valueList", aList);
                    continue;
                }
                ((ArrayList)map2.get("valueList")).add(values);
                continue;
            }
            map2 = new HashMap();
            map2.put("FID", id);
            map2.put("FName", rows.getString("FName"));
            values = new HashMap();
            values.put("FState", new Integer(rows.getInt("FState")));
            values.put("FLoanState", rows.getString("FLoanState"));
            values.put("FAmount", rows.getBigDecimal("FAmount"));
            values.put("FAmountApproved", rows.getBigDecimal("FAmountApproved"));
            values.put("FAmountBalance", rows.getBigDecimal("FAmountBalance"));
            values.put("FAmountUsed", rows.getBigDecimal("FAmountUsed"));
            values.put("FCurrencyID", rows.getString("FCurrencyID"));
            values.put("FBizReqDate", rows.getDate("FBizReqDate"));
            if (rows.getBigDecimal("FAmount") == null || rows.getBigDecimal("FAmount").equals(BizCollUtil.ZERO)) continue;
            if (map2.get("valueList") == null) {
                aList = new ArrayList();
                aList.add(values);
                map2.put("valueList", aList);
            } else {
                ((ArrayList)map2.get("valueList")).add(values);
            }
            map1.put(id, map2);
        }
        Set set = map1.entrySet();
        Iterator ite = set.iterator();
        Map cMap = null;
        while (ite.hasNext()) {
            Map.Entry entry = ite.next();
            cMap = (Map)entry.getValue();
            list.add(cMap);
        }
    }

    private void getCompanyNode(DefaultKingdeeTreeNode root, IRowSet rows, ArrayList list1) throws SQLException {
        Object orgRoot = null;
        if (root == null) {
            return;
        }
        orgRoot = root.getUserObject() instanceof OrgStructureInfo ? ((OrgStructureInfo)root.getUserObject()).getUnit() : (OrgUnitInfo)root.getUserObject();
        HashMap mapRoot = new HashMap();
        HashMap<String, Object> mapChild = new HashMap<String, Object>();
        this.index = 0;
        mapChild.put("index", new Integer(this.index));
        mapChild.put("FID", orgRoot.getId().toString());
        mapChild.put("FName", orgRoot.getName());
        mapChild.put("FLongNumber", orgRoot.getLongNumber());
        if (root.getChildCount() > 0) {
            mapChild.put("FIsLeaf", Boolean.FALSE);
        } else {
            mapChild.put("FIsLeaf", Boolean.TRUE);
        }
        mapChild.put("FLevel", new Integer(0));
        mapRoot.put(orgRoot.getId().toString(), mapChild);
        this.getCellUserObjects(root, mapRoot, 1);
        Map map1 = new HashMap();
        String id = null;
        Object map2 = null;
        Object map3 = null;
        HashMap<String, Object> values = null;
        while (rows.next()) {
            id = rows.getString("FID");
            map1 = (Map)mapRoot.get(id);
            if (map1 == null) continue;
            values = new HashMap<String, Object>();
            values.put("FState", new Integer(rows.getInt("FState")));
            values.put("FAmount", rows.getBigDecimal("FAmount"));
            values.put("FAmountApproved", rows.getBigDecimal("FAmountApproved"));
            values.put("FAmountBalance", rows.getBigDecimal("FAmountBalance"));
            values.put("FAmountUsed", rows.getBigDecimal("FAmountUsed"));
            values.put("FCurrencyID", rows.getString("FCurrencyID"));
            values.put("FBizReqDate", rows.getDate("FBizReqDate"));
            values.put("FLoanState", rows.getString("FLoanState"));
            if (rows.getBigDecimal("FAmount") == null || rows.getBigDecimal("FAmount").equals(BizCollUtil.ZERO)) continue;
            if (map1.get("valueList") == null) {
                ArrayList<HashMap<String, Object>> aList = new ArrayList<HashMap<String, Object>>();
                aList.add(values);
                map1.put("valueList", aList);
                continue;
            }
            ((ArrayList)map1.get("valueList")).add(values);
        }
        Set set = mapRoot.entrySet();
        Iterator ite = set.iterator();
        Map cMap = null;
        while (ite.hasNext()) {
            Map.Entry entry = ite.next();
            cMap = (Map)entry.getValue();
            list1.add(cMap);
        }
        Collections.sort(list1, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map map1 = (Map)o1;
                Map map2 = (Map)o2;
                Integer x1 = (Integer)map1.get("index");
                Integer x2 = (Integer)map2.get("index");
                return x1.compareTo(x2);
            }
        });
    }

    private void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Map map, int level) {
        HashMap<String, Object> map2 = null;
        if (treeNode != null && treeNode.getUserObject() != null) {
            Object org = null;
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                org = childNode.getUserObject() instanceof OrgStructureInfo ? ((OrgStructureInfo)childNode.getUserObject()).getUnit() : (OrgUnitInfo)childNode.getUserObject();
                map2 = new HashMap<String, Object>();
                map2.put("index", new Integer(++this.index));
                map2.put("FID", org.getId().toString());
                map2.put("FName", org.getName());
                map2.put("FLongNumber", org.getLongNumber());
                if (childNode.getChildCount() > 0) {
                    map2.put("FIsLeaf", Boolean.FALSE);
                } else {
                    map2.put("FIsLeaf", Boolean.TRUE);
                }
                map2.put("FLevel", new Integer(level));
                map.put(org.getId().toString(), map2);
                if (childNode.getChildCount() <= 0) continue;
                int lev = level + 1;
                this.getCellUserObjects(childNode, map, lev);
            }
        }
    }

    protected void initData() {
        GetDataDialog dlg = null;
        Window parentDlg = SwingUtilities.getWindowAncestor((Component)((Object)this));
        dlg = parentDlg instanceof Dialog ? new GetDataDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this))) : (parentDlg instanceof Frame ? new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this))) : new GetDataDialog());
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                BizCollRpt.this.initFilter();
                BizCollRpt.this.clearTable();
                BizCollRpt.this.initTableColumn();
                BizCollRpt.this.setTableStyle();
                BizCollRpt.this.initTableHeader();
                IRowSet datas = BizCollRpt.this.getDatas();
                Object row = null;
                DefaultKingdeeTreeNode root = null;
                ArrayList valueList = new ArrayList();
                if ("admin".equals(((BizCollRpt)BizCollRpt.this).filterInfo.typeStat)) {
                    BizCollRpt.this.isTree = true;
                    root = BizCollRpt.this.getOrgUnitTreeNode();
                    BizCollRpt.this.getCompanyNode(root, datas, valueList);
                } else if ("company".equals(((BizCollRpt)BizCollRpt.this).filterInfo.typeStat)) {
                    BizCollRpt.this.isTree = true;
                    root = BizCollRpt.this.getCompanyTreeNode();
                    BizCollRpt.this.getCompanyNode(root, datas, valueList);
                } else if ("person".equals(((BizCollRpt)BizCollRpt.this).filterInfo.typeStat)) {
                    BizCollRpt.this.isTree = false;
                    BizCollRpt.this.getDataList(datas, valueList);
                }
                if (valueList != null) {
                    BizCollRpt.this.fillTable(valueList);
                }
                BizCollRpt.this.setTotalLine();
                return null;
            }

            public void finish(Object obj) throws Exception {
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dlg.show();
    }

    private int getCurGroup(Date date) {
        int curYear = DateTimeUtils.getYear((Date)date);
        if (this.filterInfo.intervalType.equals("year")) {
            return curYear - this.beginYear + 1;
        }
        if (this.filterInfo.intervalType.equals("quarter")) {
            int curQuarter = DateTimeUtils.getQuarter((Date)date);
            return (curYear - this.beginYear) * 4 + curQuarter;
        }
        if (this.filterInfo.intervalType.equals("month")) {
            return (this.endYear - this.beginYear) * 12 + date.getMonth();
        }
        return 0;
    }

    private String getColNameByDate(Date date) {
        String suffix = "_";
        int year = -1;
        int num = -1;
        int curGroup = this.getCurGroup(date);
        if (this.filterInfo.intervalType.equals("year")) {
            suffix = suffix + (this.beginYear + curGroup - 1);
        } else if (this.filterInfo.intervalType.equals("quarter")) {
            num = DateTimeUtils.getQuarter((Date)date);
            year = DateTimeUtils.getYear((Date)date);
            suffix = suffix + year + "_" + num + "_" + "quarter";
        } else if (this.filterInfo.intervalType.equals("month")) {
            year = DateTimeUtils.getYear((Date)date);
            num = date.getMonth();
            suffix = suffix + year + "_" + ++num + "_" + "month";
        }
        return suffix;
    }

    public BigDecimal getExchangeRate(String curId) throws Exception {
        BigDecimal rate = null;
        if (curId == null || curId.length() != 44) {
            return new BigDecimal("1");
        }
        if (this.rateMap.containsKey(curId)) {
            return (BigDecimal)this.rateMap.get(curId);
        }
        CurrencyInfo cur = new CurrencyInfo();
        cur.setId(BOSUuid.read((String)curId));
        rate = CurrencyUtil.getExchangeRate(cur);
        if (rate.equals(new BigDecimal("0"))) {
            rate = new BigDecimal("1");
        }
        this.rateMap.put(curId, rate);
        return rate;
    }

    protected void fillTable(ArrayList valueList) throws Exception {
        HashMap values = null;
        HashMap map = null;
        int minLevel = -1;
        int level = -1;
        ArrayList list = null;
        BizCellTreeRenderer cellRen = new BizCellTreeRenderer();
        int count = valueList.size();
        for (int k = 0; k < count; ++k) {
            values = (HashMap)valueList.get(k);
            IRow row = this.tbMain.addRow();
            if (this.isTree) {
                level = (Integer)values.get("FLevel");
                if (k == 0) {
                    minLevel = level;
                }
                BizCellObject cellObj = new BizCellObject();
                cellObj.setId(values.get("FID").toString());
                if (values.get("FName") != null) {
                    cellObj.setName(values.get("FName").toString());
                } else {
                    cellObj.setName("");
                }
                cellObj.setLongNumber(values.get("FLongNumber").toString());
                cellObj.setLeaf((Boolean)values.get("FIsLeaf"));
                cellObj.setExpanded(true);
                cellObj.setLevel(level);
                row.getCell("FName").setValue((Object)cellObj);
                row.getCell("FName").setRenderer((IBasicRender)cellRen);
            } else {
                row.getCell("FName").setValue((Object)values.get("FName").toString());
            }
            row.getCell("FID").setValue((Object)values.get("FID").toString());
            list = (ArrayList)values.get("valueList");
            Date curDate = null;
            Integer state = null;
            BigDecimal totalamount = null;
            BigDecimal amount = null;
            BigDecimal amountApproved = null;
            BigDecimal amountBalance = null;
            BigDecimal amountUsed = null;
            String cur = null;
            ICell isExpenseCell = null;
            ICell noExpenseCell = null;
            ICell subTotalCell = null;
            ICell totalCell = null;
            String suffix = null;
            String isLoan = null;
            if (list == null) continue;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                map = (HashMap)list.get(i);
                curDate = (Date)map.get("FBizReqDate");
                state = (Integer)map.get("FState");
                amount = (BigDecimal)map.get("FAmount");
                amountApproved = (BigDecimal)map.get("FAmountApproved");
                amountBalance = (BigDecimal)map.get("FAmountBalance");
                amountUsed = (BigDecimal)map.get("FAmountUsed");
                cur = (String)map.get("FCurrencyID");
                isLoan = (String)map.get("FLoanState");
                if (amount == null) {
                    amount = BizCollUtil.ZERO;
                }
                if (amountApproved == null) {
                    amountApproved = BizCollUtil.ZERO;
                }
                if (amountBalance == null) {
                    amountBalance = BizCollUtil.ZERO;
                }
                if (amountUsed == null) {
                    amountUsed = BizCollUtil.ZERO;
                }
                totalamount = BizCollUtil.ZERO;
                try {
                    amount = amount.multiply(this.getExchangeRate(cur));
                    amountApproved = amountApproved.multiply(this.getExchangeRate(cur));
                    amountBalance = amountBalance.multiply(this.getExchangeRate(cur));
                    amountUsed = amountUsed.multiply(this.getExchangeRate(cur));
                }
                catch (RuntimeException e) {
                    logger.error((Object)e.getMessage());
                }
                suffix = this.getColNameByDate(curDate);
                subTotalCell = row.getCell("subTotal" + suffix);
                if ("expense".equals(this.getType())) {
                    isExpenseCell = row.getCell("isExpense" + suffix);
                    noExpenseCell = row.getCell("noExpense" + suffix);
                    isExpenseCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                    noExpenseCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                    isExpenseCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    noExpenseCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    if (70 <= state) {
                        if (isExpenseCell != null) {
                            amountApproved = amountApproved.setScale(2, 4);
                            isExpenseCell.setValue((Object)BizCollUtil.objToBigDecimal(isExpenseCell.getValue()).add(amountApproved));
                            totalamount = amountApproved;
                        }
                    } else if (state >= 45) {
                        if (noExpenseCell != null) {
                            amountApproved = amountApproved.setScale(2, 4);
                            noExpenseCell.setValue((Object)BizCollUtil.objToBigDecimal(noExpenseCell.getValue()).add(amountApproved));
                            totalamount = amountApproved;
                        }
                    } else if (state != 27 && noExpenseCell != null) {
                        amount = amount.setScale(2, 4);
                        noExpenseCell.setValue((Object)BizCollUtil.objToBigDecimal(noExpenseCell.getValue()).add(amount));
                        totalamount = amount;
                    }
                    if (subTotalCell != null) {
                        subTotalCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                        subTotalCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        subTotalCell.setValue((Object)BizCollUtil.objToBigDecimal(subTotalCell.getValue()).add(totalamount));
                    }
                    totalCell = row.getCell("total");
                    totalCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                    totalCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    if (totalCell == null) continue;
                    totalCell.setValue((Object)BizCollUtil.objToBigDecimal(totalCell.getValue()).add(totalamount));
                    continue;
                }
                if ("loan".equals(this.getType())) {
                    isExpenseCell = row.getCell("isLoan" + suffix);
                    noExpenseCell = row.getCell("noLoan" + suffix);
                    isExpenseCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                    noExpenseCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                    isExpenseCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    noExpenseCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    if ("Y".equals(isLoan)) {
                        if (isExpenseCell != null) {
                            amountApproved = amountApproved.setScale(2, 4);
                            isExpenseCell.setValue((Object)BizCollUtil.objToBigDecimal(isExpenseCell.getValue()).add(amountApproved));
                            totalamount = amountApproved;
                        }
                    } else if (("P".equals(isLoan) || "N".equals(isLoan)) && state >= 45) {
                        if (isExpenseCell != null) {
                            amountUsed = amountUsed.setScale(2, 4);
                            isExpenseCell.setValue((Object)BizCollUtil.objToBigDecimal(isExpenseCell.getValue()).add(amountUsed));
                        }
                        if (noExpenseCell != null) {
                            amountBalance = amountBalance.setScale(2, 4);
                            noExpenseCell.setValue((Object)BizCollUtil.objToBigDecimal(noExpenseCell.getValue()).add(amountBalance));
                        }
                        totalamount = amountUsed.add(amountBalance);
                    } else if (state != 27 && noExpenseCell != null) {
                        amount = amount.setScale(2, 4);
                        noExpenseCell.setValue((Object)BizCollUtil.objToBigDecimal(noExpenseCell.getValue()).add(amount));
                        totalamount = amount;
                    }
                    if (subTotalCell != null) {
                        subTotalCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                        subTotalCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        subTotalCell.setValue((Object)BizCollUtil.objToBigDecimal(subTotalCell.getValue()).add(totalamount));
                    }
                    totalCell = row.getCell("total");
                    totalCell = row.getCell("total");
                    totalCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                    if (totalCell == null) continue;
                    totalCell.setValue((Object)BizCollUtil.objToBigDecimal(totalCell.getValue()).add(totalamount));
                    continue;
                }
                if (!"req".equals(this.getType())) continue;
                if (state >= 45) {
                    totalamount = amountApproved;
                } else if (state != 27) {
                    totalamount = amount;
                }
                if (subTotalCell != null) {
                    subTotalCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                    subTotalCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    subTotalCell.setValue((Object)BizCollUtil.objToBigDecimal(subTotalCell.getValue()).add(totalamount));
                }
                totalCell = row.getCell("total");
                totalCell.getStyleAttributes().setNumberFormat("#,##0.00_ ");
                totalCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (totalCell == null) continue;
                totalCell.setValue((Object)BizCollUtil.objToBigDecimal(totalCell.getValue()).add(totalamount));
            }
        }
    }

    protected void calAmount() {
    }

    protected void setTotalLine() {
        int i;
        IRow totalRow = this.tbMain.getGroupManager().getStatRowTemplate(-1);
        totalRow.getCell(this.tbMain.getColumnIndex("FName")).setValue((Object)BizCollRptUtil.getAlias("total"));
        String key = null;
        int size = this.tbMain.getColumnCount();
        for (i = 0; i < size; ++i) {
            if (i < 2) continue;
            key = this.tbMain.getColumnKey(i);
            totalRow.getCell(key).setExpressions("SUM");
            totalRow.getCell(key).getStyleAttributes().setNumberFormat("#,##0.00_ ");
            totalRow.getCell(key).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            totalRow.getCell(key).getStyleAttributes().setLocked(true);
        }
        this.tbMain.getGroupManager().setTotalize(true);
        this.tbMain.getGroupManager().group();
        this.tbMain.setVisible(false);
        this.tbMain.setVisible(true);
        size = this.tbMain.getColumnCount();
        for (i = 0; i < size; ++i) {
            if (i < 2) continue;
            key = this.tbMain.getColumnKey(i);
            IRow last = this.tbMain.getRow(this.tbMain.getRowCount() - 1);
            if (last == null) continue;
            last.getCell(key).getStyleAttributes().setNumberFormat("#,##0.00_ ");
        }
    }

    public void showFilterUI(boolean loaded) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = this.getQueryMetaDataPK().getFullName();
        if (this.filterUI == null) {
            this.filterUI = new BizCollReportQueryUI();
        }
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getQueryMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getQueryMetaDataPK().getFullName(), queryName);
            QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
            if (qpi == null) {
                this.filterInfo = this.filterUI.getQryFilter();
                if (this.filterInfo != null) {
                    this.initUI();
                }
            } else {
                byte[] bytes = qpi.getParam();
                if (bytes != null) {
                    this.filterUI.setParam(CommonUtil.getObject((byte[])bytes));
                    this.filterInfo = this.filterUI.getQryFilter();
                    if (this.filterInfo != null) {
                        this.initUI();
                    }
                } else {
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                    if (cp != null && cp.getCustomerParam("qryFilter") != null) {
                        this.filterInfo = this.filterUI.StringToBizCollRptFilterInfo(cp.getCustomerParam("qryFilter"));
                        this.initUI();
                    } else {
                        this.filterInfo = this.filterUI.getQryFilter();
                        if (this.filterInfo != null) {
                            this.initUI();
                        }
                    }
                }
            }
            this.isFirstDefaultQuery = false;
        } else {
            if (this.dialog == null) {
                this.dialog = new CommonQueryDialog();
                this.dialog.clearUserPanels();
                this.dialog.setParentUIClassName(this.getQueryMetaDataPK().getFullName());
                this.dialog.setShowFilter(false);
                this.dialog.setShowSorter(false);
                this.dialog.setQueryObjectPK(this.getQueryMetaDataPK());
                this.dialog.addUserPanel((KDPanel)this.filterUI);
                this.dialog.setHeight(340);
                this.dialog.setWidth(445);
                this.dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
                if (this.getUIWindow() == null) {
                    this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
                } else {
                    this.dialog.setOwner((Component)((Object)this));
                }
            }
            if (this.dialog.show()) {
                this.filterInfo = this.filterUI.getQryFilter();
                if (this.filterInfo != null) {
                    this.initUI();
                }
            } else {
                SysUtil.abort();
            }
            if (this.isFirstDefaultQuery) {
                this.isFirstDefaultQuery = false;
            }
        }
        if (this.filterInfo.currentCU == null) {
            this.filterInfo.currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if (this.filterInfo.companyInfo == null) {
            this.filterInfo.companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (this.filterInfo.adminInfo == null) {
            this.filterInfo.adminInfo = SysContext.getSysContext().getCurrentAdminUnit();
        }
        if (this.filterInfo.applier == null) {
            this.filterInfo.applier = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        }
    }

    public IMetaDataPK getQueryMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.cp.bc.app.ExpenseAccountQuery");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tbMain);
        this.tbMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tbMain);
        this.tbMain.getPrintManager().printPreview();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showFilterUI(true);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tbMain, true, true, this.getUITitle());
    }

    protected Object getLastEntityViewInfo() {
        if (this.filterInfo.currentCU == null) {
            this.filterInfo.currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if (this.filterInfo.companyInfo == null) {
            this.filterInfo.companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (this.filterInfo.adminInfo == null) {
            this.filterInfo.adminInfo = SysContext.getSysContext().getCurrentAdminUnit();
        }
        if (this.filterInfo.applier == null) {
            this.filterInfo.applier = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        }
        this.filterInfo.isFromReport = true;
        return this.filterInfo;
    }

    public void initReportHead() {
        if ("admin".equals(this.filterInfo.typeStat)) {
            if (this.filterInfo.adminInfo != null) {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("admin").substring(0, 2));
                this.contName.setBoundLabelText(this.filterInfo.adminInfo.getName());
            } else if (!this.filterInfo.isFromReport || this.time != 0) {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("admin").substring(0, 2));
                if (SysContext.getSysContext().getCurrentAdminUnit() != null) {
                    this.contName.setBoundLabelText(SysContext.getSysContext().getCurrentAdminUnit().getName());
                }
            }
        } else if ("company".equals(this.filterInfo.typeStat)) {
            if (this.filterInfo.companyInfo != null) {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("company").substring(0, 2));
                this.contName.setBoundLabelText(this.filterInfo.companyInfo.getName());
            } else if (!this.filterInfo.isFromReport || this.time != 0) {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("company").substring(0, 2));
                if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                    this.contName.setBoundLabelText(SysContext.getSysContext().getCurrentFIUnit().getName());
                }
            }
        } else if ("person".equals(this.filterInfo.typeStat)) {
            if (this.filterInfo.applier != null) {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("person").substring(0, 2));
                this.contName.setBoundLabelText(this.filterInfo.applier.getName());
            } else {
                this.lblName.setBoundLabelText(BizCollRptUtil.getAlias("person").substring(0, 2));
                if (this.getApplier() != null) {
                    this.contName.setBoundLabelText(this.getApplier().getName());
                } else {
                    this.contName.setBoundLabelText("");
                }
            }
        }
    }

    private static IRowSet getAdminRowSet(CtrlUnitInfo cu, AdminOrgUnitInfo rootInfo, boolean includeChildCU) throws Exception {
        if (cu == null) {
            SysUtil.abort();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (rootInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
            if (includeChildCU) {
                fi.setMaskString("#0 or #1");
            } else {
                fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cu.getId().toString()));
                fi.setMaskString("(#0 or #1) and #2");
            }
        } else if (includeChildCU) {
            CtrlUnitInfo cuInfo = cu;
            fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.longNumber", (Object)cuInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.longNumber", (Object)(cuInfo.getLongNumber() + "!%"), CompareType.LIKE));
            fi.setMaskString("#0 or #1 ");
        } else {
            fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cu.getId().toString()));
        }
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private static DefaultKingdeeTreeNode buildTreeNodeByRowSet(IRowSet rows, boolean includeChildCU) throws Exception {
        if (rows == null) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        KDTreeNode subTreeNode = null;
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        AdminOrgUnitInfo adminInfo = null;
        if (includeChildCU) {
            rootTreeNode = new DefaultKingdeeTreeNode();
        }
        while (rows.next()) {
            adminInfo = BizCollRpt.createAdminUnitInfo(rows);
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(companyIcon);
            if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            } else {
                rootTreeNode.add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(adminInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIndex(row.getInt("index"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    class ExpenseTableListen
    implements KDTMouseListener {
        private KDTable table1;
        String colExpName;

        public ExpenseTableListen(KDTable table, String colName) {
            this.table1 = table;
            this.colExpName = colName;
        }

        public void tableClicked(KDTMouseEvent e) {
            int row = e.getRowIndex();
            int column = e.getColIndex();
            if (BizCollRpt.this.tbMain.getRow(row) != null && BizCollRpt.this.tbMain.getRow(row).isStat()) {
                return;
            }
            if (BizCollRpt.this.isTree) {
                this.cellClicked(this.table1, this.colExpName, row, column, e.getX(), e.getY());
            }
        }

        private void cellClicked(KDTable table, String colName, int row, int column, int x, int y) {
            if (row > -1 && column == table.getColumnIndex(colName)) {
                if (table.getRow(row) == null || table.getRow(row).getCell(column).getValue() == null) {
                    return;
                }
                BizCellObject comUserObject = (BizCellObject)table.getRow(row).getCell(column).getValue();
                BizCellTreeRenderer virtureCompanyRender = (BizCellTreeRenderer)table.getRow(row).getCell(column).getRenderer();
                if (virtureCompanyRender.inRect(comUserObject, x, y)) {
                    try {
                        this.doExpand(table, colName, comUserObject, row);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void doExpand(KDTable table, String strColName, BizCellObject comUserObject, int rowIndex) throws Exception {
            IRow row = table.getRow(rowIndex);
            int rowCount = table.getRowCount();
            if (comUserObject.isLeaf()) {
                return;
            }
            table.setRefresh(false);
            if (table.getRow(rowIndex).isStat()) {
                return;
            }
            if (comUserObject.isExpanded()) {
                for (int i = rowIndex + 1; i < rowCount; ++i) {
                    IRow row2 = table.getRow(i);
                    if (row2.isStat()) continue;
                    BizCellObject company2 = (BizCellObject)row2.getCell(strColName).getValue();
                    if (company2.getLevel() <= comUserObject.getLevel()) break;
                    row2.getStyleAttributes().setHided(true);
                }
                comUserObject.setExpanded(false);
            } else if (comUserObject.isHasExpanded()) {
                this.expandRow(table, strColName, rowIndex);
                comUserObject.setExpanded(true);
            } else {
                this.expandRow(table, strColName, rowIndex);
                comUserObject.setExpanded(true);
                comUserObject.setHasExpanded(true);
            }
            table.setRefresh(true);
            table.repaint();
        }

        private int expandRow(KDTable table, String strColName, int rowIndex) {
            IRow row = table.getRow(rowIndex);
            int rowCount = table.getRowCount();
            BizCellObject comUserObject = (BizCellObject)row.getCell(strColName).getValue();
            while (++rowIndex < rowCount) {
                IRow row2 = table.getRow(rowIndex);
                if (row2.isStat()) continue;
                BizCellObject companyUserObject2 = (BizCellObject)row2.getCell(strColName).getValue();
                if (companyUserObject2.getLevel() > comUserObject.getLevel()) {
                    row2.getStyleAttributes().setHided(false);
                    if (companyUserObject2.isExpanded()) {
                        rowIndex = this.expandRow(table, strColName, rowIndex);
                        continue;
                    }
                    if (companyUserObject2.isLeaf()) continue;
                    rowIndex = this.expandSkipChildren(table, strColName, rowIndex);
                    continue;
                }
                --rowIndex;
                break;
            }
            return rowIndex;
        }

        private int expandSkipChildren(KDTable table, String strColName, int rowIndex) {
            BizCellObject companyUserObject2;
            IRow row2;
            IRow row = table.getRow(rowIndex);
            int rowCount = table.getRowCount();
            BizCellObject companyUserObject = (BizCellObject)row.getCell(strColName).getValue();
            while (++rowIndex < rowCount && ((row2 = table.getRow(rowIndex)).isStat() || (companyUserObject2 = (BizCellObject)row2.getCell(strColName).getValue()).getLevel() != companyUserObject.getLevel())) {
            }
            return rowIndex - 1;
        }
    }

    class TreeIcon
    implements Icon {
        private int iconSize;
        private int margin;

        public TreeIcon() {
            this(9);
        }

        public TreeIcon(int iconSize) {
            this.iconSize = iconSize;
            this.margin = 2;
        }

        public int getWidth() {
            return this.iconSize;
        }

        public int getHeight() {
            return this.iconSize;
        }

        public void paint(Object value, Graphics g, int x, int y) {
            if (value instanceof Integer) {
                int type = (Integer)value;
                if (type == 0) {
                    this.drawLeaf(g, x, y);
                } else if (type == 1) {
                    this.drawCollapsed(g, x, y);
                } else {
                    this.drawExpanded(g, x, y);
                }
            }
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
            g.drawLine(x + 1 + this.iconSize / 2, y + this.margin, x + 1 + this.iconSize / 2, y + this.margin + lineSize);
        }
    }

    class BizCellTreeRenderer
    extends ObjectValueRender
    implements IBasicRender {
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected Icon cbIcon;
        private Map mapOfTreeNodeLocation = new Hashtable();

        public BizCellTreeRenderer() {
            this.cbIcon = new TreeIcon();
        }

        public boolean inRect(BizCellObject comUserObject, int x, int y) {
            String companyId = comUserObject.getId().toString();
            Rectangle rec = (Rectangle)this.mapOfTreeNodeLocation.get(companyId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics g, Shape clip, Object value, Style style) {
            BizCellObject comUserObject = (BizCellObject)value;
            int ident = comUserObject.getLevel() * 15;
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
            int v = comUserObject.isLeaf() ? 0 : (comUserObject.isExpanded() ? 2 : 1);
            Color color = style.getFontColor();
            g.setColor(color);
            Rectangle locRec = new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getWidth());
            String companyId = comUserObject.getId();
            if (this.mapOfTreeNodeLocation.get(companyId) == null) {
                this.mapOfTreeNodeLocation.put(companyId, locRec);
            }
            int xx = x + this.cbIcon.getWidth() + 8;
            if (comUserObject.toString().equals("")) {
                return;
            }
            Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - 8, (int)clip.getBounds().getHeight());
            this.simpleRender.draw(g, (Shape)newRec, comUserObject.getName(), style);
            if (v != 0) {
                this.cbIcon.paint((Object)new Integer(v), g, x, y);
            }
        }
    }

    class BizCellObject
    implements Serializable,
    Cloneable {
        private String id;
        private String name;
        private boolean isLeaf;
        private int level;
        private boolean expanded = false;
        private boolean hasExpanded = false;
        private String longNumber;

        BizCellObject() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.level; ++i) {
                buf.append("  ");
            }
            buf.append(this.name);
            return buf.toString();
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }

        public boolean isHasExpanded() {
            return this.hasExpanded;
        }

        public void setHasExpanded(boolean hasExpanded) {
            this.hasExpanded = hasExpanded;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

