/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyPurchaseExpBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseExpBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseExpBillInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.client.AbstractDailyExpenseEditUI;
import com.kingdee.eas.cp.bc.client.RecordsOfLendAndRepayUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import javax.swing.JTextField;

public class DailyExpenseEditUI
extends AbstractDailyExpenseEditUI {
    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        DailyPurchaseExpBillEntryInfo ret = new DailyPurchaseExpBillEntryInfo();
        ret.setAmount(new BigDecimal("0.0"));
        return ret;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    protected IObjectValue createNewData() {
        DailyPurchaseExpBillInfo ret = new DailyPurchaseExpBillInfo();
        super.fillBillHeader(ret);
        ret.getEntries().add((DailyPurchaseExpBillEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return ret;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DailyPurchaseExpBillFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getBaseSelectors();
        SelectorItemCollection superSic = super.getSelectors();
        int n = superSic.size();
        for (int i = 0; i < n; ++i) {
            sic.add(superSic.get(i));
        }
        return sic;
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        IRow row = this.kdtEntries.getRow(e.getRowIndex());
        ICell priceCell = row.getCell("price");
        ICell countCell = row.getCell("count");
        BigDecimal price = BizCollUtil.toBigDecimal(priceCell.getValue());
        BigDecimal count = BizCollUtil.toBigDecimal(countCell.getValue());
        if (price != null && count != null) {
            row.getCell("amount").setValue((Object)price.multiply(count));
            super.caculateBillAmount();
        } else if (price == null || count == null) {
            row.getCell("amount").setValue((Object)"0.00");
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setBtnViewRrcdsOfLendAndRepayState();
        KDBizPromptBox measureUnitBox = new KDBizPromptBox();
        measureUnitBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        measureUnitBox.setDisplayFormat("$name$");
        measureUnitBox.setEditFormat("$number$");
        measureUnitBox.setCommitFormat("$number$");
        measureUnitBox.setEditable(true);
        this.kdtEntries.getColumn("measurement").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)measureUnitBox));
        this.kdtEntries.getColumn("price").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)BizCollUtil.getMoneyEditor()));
        this.kdtEntries.getColumn("count").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)BizCollUtil.getMoneyEditor()));
        this.btnWFViewSubmitProccess.setVisible(false);
        this.menuItemViewSubmitProccess.setVisible(false);
        this.menuItemViewBudget.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        if (this.ifApproved()) {
            this.actionCopy.setEnabled(false);
        }
        this.setDisEnableWithAudit();
    }

    protected void setDisEnableWithAudit() {
        if (this.isFromWorkFlow() && this.getUIContext().get("isMultiApprove") != null && ((Boolean)this.getUIContext().get("isMultiApprove")).booleanValue()) {
            this.txtName.setEnabled(false);
            this.bizPromptApplier.setEnabled(false);
            this.txtNumber.setEnabled(false);
            this.dateBizReqDate.setEnabled(false);
            this.bizPromptOrgUnit.setEnabled(false);
            this.bizPromptPosition.setEnabled(false);
        }
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        KDTSelectManager kdtManager = this.getDetailTable().getSelectManager();
        IRow row = null;
        ICell cell = null;
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtEntries.getRow(i);
            cell = row.getCell("name");
            if (BizCollUtil.objectIsNull(cell.getValue())) {
                kdtManager.select(i, cell.getColumnIndex());
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYMATERIALNAME_EXCEPTION);
            }
            if (cell.getValue().toString().trim().length() > 80) {
                throw new ExpAccException(ExpAccException.MAT_TOO_LONG);
            }
            cell = row.getCell("price");
            if (cell.getValue() == null) {
                kdtManager.select(i, cell.getColumnIndex());
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYPRICE_EXCEPTION);
            }
            if (!BizCollUtil.greateThenZero(cell.getValue())) {
                kdtManager.select(i, cell.getColumnIndex());
                throw new ExpenseReqException(ExpenseReqException.NEGTIVE_PRICE_ERROR);
            }
            cell = row.getCell("count");
            if (cell.getValue() == null) {
                kdtManager.select(i, cell.getColumnIndex());
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYCOUNT_EXCEPTION);
            }
            if (!BizCollUtil.greateThenZero(cell.getValue())) {
                kdtManager.select(i, cell.getColumnIndex());
                throw new ExpenseReqException(ExpenseReqException.NEGTIVE_COUNT_ERROR);
            }
            cell = row.getCell("amount");
        }
    }

    @Override
    protected void setRequiredColumn() {
        String[] columns = new String[]{"name", "price", "count", "amount"};
        this.requiredColumn = columns;
    }

    private void setBtnViewRrcdsOfLendAndRepayState() {
        this.btnViewRcrdsOfLendAndRepay.setVisible(true);
        this.btnViewRcrdsOfLendAndRepay.setEnabled(true);
        this.btnViewRcrdsOfLendAndRepay.setIcon(EASResource.getIcon((String)"imgTbtn_requite"));
        this.menuItemViewRcds.setVisible(true);
        this.menuItemViewRcds.setEnabled(true);
        this.menuItemViewRcds.setIcon(EASResource.getIcon((String)"imgTbtn_requite"));
    }

    @Override
    public void actionViewRrcdsOfLendAndRepay_actionPerformed(ActionEvent e) throws Exception {
        Map ctx = this.perpareForUIContext();
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow messageDialog = uiFactory.create(RecordsOfLendAndRepayUI.class.getName(), ctx);
        messageDialog.show();
    }

    @Override
    protected AbstractObjectCollection getEntryCollection(BizCollCoreBillBaseInfo editData) {
        return null;
    }

    @Override
    public void verifyData() throws Exception {
        super.verifyData();
    }

    @Override
    protected PersonInfo getApplierId() {
        if (this.bizPromptApplier.getValue() != null) {
            return (PersonInfo)this.bizPromptApplier.getValue();
        }
        return null;
    }
}

